/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryAnalysisProvider;

public abstract class QueryProvider {
    private static String[] queryProviders = new String[]{"oql", "org.makumba.db.makumba.OQLQueryProvider", "hql", "org.makumba.db.hibernate.HQLQueryProvider"};
    static final Map<String, Class> providerClasses = new HashMap<String, Class>();
    private String dataSource;
    private QueryAnalysisProvider qap;

    public QueryProvider() {
        try {
            if (this.getQueryAnalysisProviderClass() != null && this.qap == null) {
                this.qap = (QueryAnalysisProvider)Class.forName(this.getQueryAnalysisProviderClass()).newInstance();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected String getQueryAnalysisProviderClass() {
        return null;
    }

    public static QueryProvider makeQueryAnalzyer(String name) {
        try {
            return (QueryProvider)providerClasses.get(name).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static QueryProvider makeQueryRunner(String dataSource, String name) {
        QueryProvider qeep = QueryProvider.makeQueryAnalzyer(name);
        qeep.init(dataSource);
        return qeep;
    }

    public void init(String dataSource) {
        this.dataSource = dataSource;
    }

    public abstract Vector execute(String var1, Map var2, int var3, int var4);

    public abstract void close();

    public abstract String getPrimaryKeyNotation(String var1);

    public QueryAnalysis getQueryAnalysis(String query) {
        return this.qap.getQueryAnalysis(query);
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public abstract boolean selectGroupOrOrderAsLabels();

    public abstract FieldDefinition getAlternativeField(DataDefinition var1, String var2);

    static {
        for (int i = 0; i < queryProviders.length; i += 2) {
            try {
                providerClasses.put(queryProviders[i], Class.forName(queryProviders[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

