/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.hql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.query.hql.ExprTypeAST;
import org.makumba.providers.query.hql.HqlAnalyzeBaseWalker;
import org.makumba.providers.query.hql.ParamTypeAST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HqlAnalyzeWalker
extends HqlAnalyzeBaseWalker {
    private List result;
    private String query;
    private static Map<String, Integer> methodTypes = new HashMap<String, Integer>();

    @Override
    void setAliasType(AST alias, String type) throws RecognitionException {
        if (this.aliasTypes.get(alias.getText()) != null) {
            throw new SemanticException("alias " + alias.getText() + " defined twice");
        }
        if (this.typeComputer.determineType(type, null) != null) {
            this.aliasTypes.put(alias.getText(), type);
        } else {
            int dot1;
            int dot = type.indexOf(46);
            if (dot == -1) {
                throw new DataDefinitionNotFoundError(type);
            }
            String label = type.substring(0, dot);
            String labelType = (String)this.aliasTypes.get(label);
            if (labelType == null) {
                throw new SemanticException("Unknown label: " + label + "\n" + new NoSuchFieldException(label).getStackTrace());
            }
            do {
                String field;
                Object tp;
                if (!((tp = this.typeComputer.determineType(labelType, field = (dot1 = type.indexOf(46, dot + 1)) == -1 ? type.substring(dot + 1) : type.substring(dot + 1, dot1))) instanceof String)) {
                    throw new SemanticException("composite type expected in FROM expression " + type + ". " + field + " is a non-composite field of type " + labelType);
                }
                labelType = (String)tp;
                dot = dot1;
            } while (dot1 != -1);
            this.aliasTypes.put(alias.getText(), labelType);
        }
    }

    @Override
    AST deriveParamExpr(AST pe) throws SemanticException {
        return new ParamTypeAST(100, pe.getText());
    }

    @Override
    AST deriveLogicalExpr(AST le) {
        if (le.getFirstChild() instanceof ExprTypeAST && le.getFirstChild().getNextSibling() instanceof ExprTypeAST) {
            ExprTypeAST firstValue = null;
            ExprTypeAST secondValue = null;
            firstValue = (ExprTypeAST)le.getFirstChild();
            secondValue = (ExprTypeAST)firstValue.getNextSibling();
            this.inferParam(firstValue, secondValue);
        }
        return new ExprTypeAST(4);
    }

    private void inferParam(ExprTypeAST firstValue, ExprTypeAST secondValue) {
        this.inferParam1(firstValue, secondValue);
        this.inferParam1(secondValue, firstValue);
    }

    private void inferParam1(ExprTypeAST firstValue, ExprTypeAST secondValue) {
        if (firstValue instanceof ParamTypeAST && secondValue != null) {
            this.paramTypes.put(firstValue.getText(), secondValue);
        }
    }

    @Override
    AST deriveFunctionCallExpr(AST fc, AST e) {
        String functionCall = fc.getText().toUpperCase();
        return new ExprTypeAST(methodTypes.get(functionCall));
    }

    @Override
    AST deriveQueryExpr(AST ae) throws SemanticException {
        ae = ae.getFirstChild().getFirstChild();
        return ae;
    }

    @Override
    AST deriveAggregateExpr(AST ae, AST ag) throws SemanticException {
        String agr = ag.getText();
        if ("max".equals(agr) || "min".equals(agr)) {
            return ae;
        }
        if ("avg".equals(agr)) {
            return new ExprTypeAST(15);
        }
        if ("count".equals(agr)) {
            return new ExprTypeAST(4);
        }
        return null;
    }

    @Override
    AST deriveArithmethicExpr(AST ae) throws SemanticException {
        if (ae instanceof ExprTypeAST) {
            return ae;
        }
        String operator = ae.getText();
        ExprTypeAST firstValue = null;
        ExprTypeAST secondValue = null;
        firstValue = (ExprTypeAST)ae.getFirstChild();
        secondValue = (ExprTypeAST)firstValue.getNextSibling();
        if (firstValue.getObjectType() != null || secondValue.getObjectType() != null) {
            throw new SemanticException("Cannot perform operation " + operator + " on elements " + firstValue.getText() + " and " + secondValue.getText());
        }
        if (firstValue.getDataType() == 100 || secondValue.getDataType() == 100) {
            return new ExprTypeAST(100);
        }
        return new ExprTypeAST(firstValue.getDataType() > secondValue.getDataType() ? firstValue.getDataType() : secondValue.getDataType());
    }

    @Override
    protected void setAlias(AST se, AST i) {
        if (se instanceof ExprTypeAST) {
            ((ExprTypeAST)se).setIdentifier(i.getText());
        }
    }

    @Override
    void getReturnTypes(AST r, Stack stackAliases) throws RecognitionException {
        if (this.isSubQuery()) {
            return;
        }
        this.result = new ArrayList();
        for (AST a = r.getFirstChild(); a != null; a = a.getNextSibling()) {
            this.result.add(a);
        }
    }

    @Override
    void beforeStatement(String statementName, int statementType) {
        super.beforeStatement(statementName, statementType);
        if (this.isSubQuery()) {
            HashMap aliasTypes1 = (HashMap)((HashMap)this.aliasTypes).clone();
            this.stackAliases.push(this.aliasTypes);
            this.aliasTypes = aliasTypes1;
        }
    }

    @Override
    void afterStatementCompletion(String statementName) {
        if (this.isSubQuery()) {
            this.aliasTypes = (HashMap)this.stackAliases.pop();
        }
        super.afterStatementCompletion(statementName);
    }

    public Map<String, String> getLabelTypes() {
        return this.aliasTypes;
    }

    public Map getParameterTypes() {
        return this.paramTypes;
    }

    public List getResult() {
        return this.result;
    }

    public void reportError(RecognitionException ex) {
        throw new RuntimeWrappedException(ex);
    }

    public void setDebug(String query1) {
        this.query = query1;
    }

    public String toString() {
        return this.query;
    }

    static {
        String[] methodReal = new String[]{"COS", "COSH", "EXP", "LN", "LOG", "SIN", "SINH", "SQRT", "TAN", "TANH", "ACOS", "ASIN", "ATAN"};
        String[] methodChar = new String[]{"CHR", "CONCAT", "INITCAP", "LOWER", "LPAD", "LTRIM", "NLS_INITCAP", "NLS_LOWER", "NLSSORT", "NLS_UPPER", "RPAD", "RTRIM", "SOUNDEX", "SUBSTR", "TRANSLATE", "TREAT", "TRIM", "UPPER"};
        String[] methodInt = new String[]{"ASCII", "INSTR", "LENGTH", "DAY", "MONTH", "YEAR"};
        String[] methodDate = new String[]{"ADD_MONTHS", "CURRENT_DATE", "CURRENT_TIMESTAMP", "DBTIMEZONE", "EXTRACT", "FROM_TZ", "LAST_DAY", "LOCALTIMESTAMP", "MONTHS_BETWEEN", "NEW_TIME", "NEXT_DAY", "NUMTODSINTERVAL", "NUMTOYMINTERVAL", "ROUND", "SESSIONTIMEZONE", "SYS_EXTRACT_UTC", "SYSDATE", "SYSTIMESTAMP", "TO_DSINTERVAL", "TO_TIMESTAMP", "TO_TIMESTAMP_TZ", "TO_YMINTERVAL", "TRUNC", "TZ_OFFSET", "DAYOFWEEK", "WEEKDAY", "DAYOFMONTH", "DAYOFYEAR", "DAYNAME", "MONTHNAME", "QUARTER", "WEEK", "YEARWEEK", "HOUR", "MINUTE", "SECOND", "PERIOD_ADD", "PERIOD_DIFF", "DATE_ADD", "DATE_SUB", "ADDDATE", "SUBDATE", "TO_DAYS", "FROM_DAYS", "DATE_FORMAT", "TIME_FORMAT", "CURDATE", "NOW", "UNIX_TIMESTAMP", "SEC_TO_TIME", "TIME_TO_SEC"};
        for (String method : methodReal) {
            methodTypes.put(method, new Integer(15));
        }
        for (String method : methodChar) {
            methodTypes.put(method, new Integer(6));
        }
        for (String method : methodInt) {
            methodTypes.put(method, new Integer(4));
        }
        for (String method : methodDate) {
            methodTypes.put(method, new Integer(9));
        }
    }
}

