/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.oql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.collections.AST;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaSystem;
import org.makumba.OQLAnalyzer;
import org.makumba.commons.NameResolver;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.query.oql.IdAST;
import org.makumba.providers.query.oql.OQLAST;
import org.makumba.providers.query.oql.OQLQueryAnalysisProvider;
import org.makumba.providers.query.oql.ParamAST;
import org.makumba.providers.query.oql.Projection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryAST
extends OQLAST
implements OQLAnalyzer,
QueryAnalysis {
    private static final long serialVersionUID = 1L;
    private DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    String originalQuery;
    AST fromAST;
    AST whereAST;
    AST groupAST;
    AST orderAST;
    AST afterWhereAST;
    AST firstProjection;
    QueryAST superQuery;
    String oneProjectionLabel;
    Vector<Projection> projections = new Vector();
    Vector projectionLabels;
    Hashtable<String, Projection> projectionLabelSearch = new Hashtable();
    Vector<ParamAST> parameters = new Vector();
    DataDefinition resultInfo;
    DataDefinition paramInfo;
    Hashtable<String, DataDefinition> labels = new Hashtable();
    Hashtable<String, DataDefinition> fromLabels = new Hashtable();
    Hashtable<String, String> aliases = new Hashtable();
    Vector<Join> joins = new Vector();
    Hashtable<String, String> joinNames = new Hashtable();
    Vector<AST> expressions = new Vector();
    Vector<AST> expressionIdentifiers = new Vector();

    public QueryAST() {
    }

    public QueryAST(Token t) {
        super(t);
    }

    public void setOQL(String s) {
        this.originalQuery = s;
    }

    @Override
    public String getOQL() {
        return this.originalQuery;
    }

    public void setFromAST(AST token) {
        this.fromAST = token;
    }

    public void setWhereAST(AST token) {
        this.whereAST = token;
    }

    public void setGroupAST(AST token) {
        this.groupAST = token;
        this.afterWhereAST = token;
    }

    public void setOrderAST(AST token) {
        this.orderAST = token;
        if (this.groupAST == null) {
            this.afterWhereAST = token;
        }
    }

    public void setSuperQuery(QueryAST sp) {
        this.superQuery = sp;
    }

    public QueryAST getSuperQuery() {
        return this.superQuery;
    }

    public void addProjection(Projection p) {
        this.projections.addElement(p);
        if (p.as.length() > 0) {
            this.projectionLabelSearch.put(p.as, p);
        }
    }

    public void addParameter(ParamAST p) {
        this.parameters.addElement(p);
    }

    @Override
    public int parameterNumber() {
        return this.parameters.size();
    }

    @Override
    public int parameterAt(int i) {
        return this.parameters.elementAt((int)i).number;
    }

    @Override
    public DataDefinition getProjectionType() {
        if (this.oneProjectionLabel != null) {
            return this.labels.get(this.oneProjectionLabel);
        }
        return this.resultInfo;
    }

    @Override
    public DataDefinition getParameterTypes() {
        return this.paramInfo;
    }

    @Override
    public DataDefinition getLabelType(String s) {
        String s1 = this.aliases.get(s);
        if (s1 != null) {
            s = s1;
        }
        return this.labels.get(s);
    }

    public void setOneProjection(String label) {
        this.oneProjectionLabel = label;
    }

    void computeProjectionTypes() throws RecognitionException {
        if (this.oneProjectionLabel != null) {
            if (this.labels.get(this.oneProjectionLabel) == null) {
                throw new SemanticException("undefined projection label: \"" + this.oneProjectionLabel + "\"");
            }
        } else {
            this.resultInfo = this.ddp.getVirtualDataDefinition("Result for " + this.originalQuery);
            for (int i = 0; i < this.projections.size(); ++i) {
                Object type;
                Projection proj = this.projections.elementAt(i);
                if (proj.as == null || proj.as.length() == 0) {
                    proj.as = "col" + (i + 1);
                }
                if ((type = proj.expr.getMakumbaType()) == null) {
                    System.out.println("\u0007\n\nno type computed for " + proj.expr.getText() + "\n\n");
                    type = "int";
                }
                if (type.toString().startsWith("set")) {
                    throw new SemanticException("You cannot select a set; projection \"" + proj.as + "\" with expression \"" + (Object)((Object)proj.expr) + "\" has type " + type);
                }
                FieldDefinition fd = type instanceof String ? this.ddp.makeFieldOfType(proj.as, (String)type, proj.expr.getText()) : this.ddp.makeFieldWithName(proj.as, (FieldDefinition)type, proj.expr.getText());
                this.resultInfo.addField(fd);
            }
        }
    }

    public void computeParameterTypes() {
        if (this.parameters.size() == 0) {
            return;
        }
        this.paramInfo = MakumbaSystem.getTemporaryDataDefinition("Parameters for " + this.originalQuery);
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParamAST param = this.parameters.elementAt(i);
            String nm = "param" + i;
            FieldDefinition fd = param.makumbaType instanceof String ? MakumbaSystem.makeFieldOfType(nm, (String)param.makumbaType) : MakumbaSystem.makeFieldWithName(nm, (FieldDefinition)param.makumbaType);
            this.paramInfo.addField(fd);
        }
    }

    String addJoin(String l1, String f1, String name, String f2, DataDefinition type, boolean leftJoin) throws SemanticException {
        this.joins.addElement(new Join(l1, f1, name, f2, leftJoin));
        this.joinNames.put(l1 + "." + f1, name);
        this.setLabelType(name, type);
        return name;
    }

    String join(String label, String field, String labelf, boolean leftJoin) throws RecognitionException {
        String s = this.joinNames.get(label + "." + field);
        if (s != null) {
            return s;
        }
        DataDefinition foreign = null;
        DataDefinition sub = null;
        DataDefinition type = this.labels.get(label);
        String index = type.getIndexPointerFieldName();
        FieldDefinition fi = type.getFieldDefinition(field);
        if (fi == null) {
            throw new SemanticException("no such field \"" + field + "\" in makumba type \"" + type.getName() + "\"");
        }
        try {
            foreign = fi.getForeignTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sub = fi.getSubtable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String label2 = label;
        if (labelf != null) {
            label2 = labelf;
        }
        while (this.labels.get(label2) != null) {
            label2 = label2 + "x";
        }
        if (fi.getType().equals("ptr")) {
            return this.addJoin(label, field, label2, foreign.getIndexPointerFieldName(), foreign, leftJoin);
        }
        if (fi.getType().equals("ptrOne")) {
            return this.addJoin(label, field, label2, sub.getIndexPointerFieldName(), sub, leftJoin);
        }
        if (fi.getType().equals("setComplex") || fi.getType().equals("setintEnum") || fi.getType().equals("setcharEnum")) {
            return this.addJoin(label, index, label2, index, sub, leftJoin);
        }
        if (fi.getType().equals("set")) {
            label2 = label + "x";
            while (this.labels.get(label2) != null) {
                label2 = label2 + "x";
            }
            this.addJoin(label, index, label2, index, sub, false);
            this.labels.put(label2, sub);
            String label3 = label;
            if (labelf != null) {
                label3 = labelf;
            }
            while (this.labels.get(label3) != null) {
                label3 = label3 + "x";
            }
            return this.addJoin(label2, sub.getSetMemberFieldName(), label3, foreign.getIndexPointerFieldName(), foreign, leftJoin);
        }
        throw new RecognitionException("\"" + field + "\" is not a set or pointer in makumba type \"" + type.getName() + "\"");
    }

    public void addFrom(String frm, String label, boolean leftJoin) throws RecognitionException {
        block10: {
            String iterator = frm;
            DataDefinition type = null;
            try {
                type = this.ddp.getDataDefinition(iterator);
            }
            catch (DataDefinitionNotFoundError e) {
            }
            catch (DataDefinitionParseError p) {
                throw new RecognitionException(p.getMessage());
            }
            if (type != null) {
                this.setLabelType(label, type);
                this.fromLabels.put(label, type);
                return;
            }
            int i = iterator.indexOf(46);
            if (i > 0) {
                String lbl = iterator.substring(0, i);
                while (true) {
                    if (this.labels.get(lbl) == null) {
                        String lbl1 = this.aliases.get(lbl);
                        if (lbl1 == null) {
                            throw new SemanticException("could not find type \"" + frm + "\" or label \"" + lbl + "\"");
                        }
                        lbl = lbl1;
                    }
                    String field = iterator = iterator.substring(i + 1);
                    i = iterator.indexOf(46);
                    if (i == -1) {
                        this.join(lbl, field, label, leftJoin);
                        break block10;
                    }
                    field = iterator.substring(0, i);
                    lbl = this.join(lbl, field, null, leftJoin);
                }
            }
            if (this.labels.get(frm) == null) {
                throw new SemanticException("could not find type \"" + frm + "\"");
            }
            this.aliases.put(label, frm);
        }
    }

    private void setLabelType(String label, DataDefinition type) throws SemanticException {
        if (this.labels.get(label) != null) {
            throw new SemanticException("label defined twice: " + label);
        }
        this.labels.put(label, type);
    }

    public void addExpression(AST token) {
        this.expressions.addElement(token);
    }

    void computeExpressionTypes() throws RecognitionException {
        Enumeration<AST> e = this.expressions.elements();
        while (e.hasMoreElements()) {
            OQLAST expr = (OQLAST)e.nextElement();
            expr.getMakumbaType();
        }
    }

    public void addExpressionIdentifier(AST token) {
        this.expressionIdentifiers.addElement(token);
    }

    void treatExpressionIdentifiers() throws RecognitionException {
        Enumeration<AST> e = this.expressionIdentifiers.elements();
        while (e.hasMoreElements()) {
            String stp;
            DataDefinition ri;
            String l1;
            AST token = e.nextElement();
            IdAST id = (IdAST)token;
            id.query = this;
            String s = token.getText();
            String field = null;
            String initial = s;
            int i = s.indexOf(".");
            String label = s;
            if (i != -1) {
                label = s.substring(0, i);
            }
            if ((l1 = this.aliases.get(label)) != null) {
                label = l1;
            }
            if ((ri = this.labels.get(label)) == null) {
                if (i == -1 && this.projectionLabelSearch.get(label) != null) {
                    boolean outOfWhere = true;
                    for (AST a = token; a != null; a = a.getNextSibling()) {
                        if (a != this.afterWhereAST) continue;
                        outOfWhere = false;
                        break;
                    }
                    if (outOfWhere) {
                        id.projectionLabel = label;
                        continue;
                    }
                }
                throw new SemanticException("undefined label: \"" + label + "\"");
            }
            if (i != -1) {
                while (true) {
                    FieldDefinition fi;
                    field = s = s.substring(i + 1);
                    i = s.indexOf(46);
                    if (i != -1) {
                        field = s.substring(0, i);
                    }
                    if ((fi = ri.getFieldDefinition(field)) == null) {
                        throw new SemanticException("no such field \"" + field + "\" in makumba type \"" + ri.getName() + "\"");
                    }
                    if ((fi.getType().equals("set") || fi.getType().equals("setComplex")) && i != -1) {
                        throw new SemanticException("set joins not allowed outside where clause; \"" + initial + "\" contains reference to \"" + ri.getName() + "->" + field + "\"");
                    }
                    if (i == -1) break;
                    label = this.join(label, field, null, false);
                    ri = fi.getPointedType();
                }
            }
            id.label = label;
            id.field = field;
            if (id.field == null && ri.getParentField() != null && ((stp = ri.getParentField().getType()).equals("setintEnum") || stp.equals("setcharEnum"))) {
                id.field = "enum";
            }
            if (id.field == null) {
                id.field = ri.getIndexPointerFieldName();
            }
            id.makumbaType = ri.getFieldDefinition(id.field);
        }
    }

    protected void writeDistinct(NameResolver nr, StringBuffer ret) {
        if (this.getFirstChild().getText().toLowerCase().equals("distinct")) {
            ret.append(" DISTINCT ");
            this.firstProjection = this.getFirstChild().getNextSibling();
        } else {
            this.firstProjection = this.getFirstChild();
        }
    }

    protected void writeProjection(NameResolver nr, StringBuffer ret) {
        if (this.oneProjectionLabel != null) {
            ret.append(" ").append(this.oneProjectionLabel).append(".*");
        } else {
            for (AST a = this.firstProjection; a != this.fromAST; a = a.getNextSibling()) {
                ret.append(" ").append(((OQLAST)a).writeInSQLQuery(nr));
            }
        }
    }

    protected void writeFrom(NameResolver nr, StringBuffer ret) {
        boolean comma = false;
        Enumeration<String> e = this.fromLabels.keys();
        while (e.hasMoreElements()) {
            String label = e.nextElement();
            if (comma) {
                ret.append(" JOIN ");
            }
            comma = true;
            ret.append(this.getTableName(label, nr)).append(" ").append(label);
        }
    }

    protected String getTableName(String label, NameResolver nr) {
        DataDefinition ri = this.labels.get(label);
        try {
            return nr.resolveTypeName(ri);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return ri.getName();
        }
    }

    protected String getFieldName(String label, String field, NameResolver nr) {
        DataDefinition ri = this.labels.get(label);
        try {
            return nr.resolveFieldName(ri, field);
        }
        catch (NullPointerException e) {
            return field;
        }
    }

    protected void writeJoins(NameResolver nr, StringBuffer ret) {
        Enumeration<Join> e = this.joins.elements();
        while (e.hasMoreElements()) {
            Join j = e.nextElement();
            if (j.leftJoin) {
                ret.append(" LEFT");
            }
            ret.append(" JOIN ");
            ret.append(this.getTableName(j.label2, nr)).append(" ").append(j.label2);
            ret.append(" ON ");
            ret.append(j.label1).append(".").append(this.getFieldName(j.label1, j.field1, nr)).append("= ").append(j.label2).append(".").append(this.getFieldName(j.label2, j.field2, nr));
        }
    }

    protected void writeConditions(NameResolver nr, StringBuffer ret) {
        ret.append("(");
        for (AST a = this.whereAST.getNextSibling(); a != this.afterWhereAST; a = a.getNextSibling()) {
            ret.append(" ").append(((OQLAST)a).writeInSQLQuery(nr));
        }
        ret.append(")");
    }

    protected void writeAfterWhere(NameResolver nr, StringBuffer ret) {
        for (AST a = this.afterWhereAST; a != null; a = a.getNextSibling()) {
            ret.append(" ").append(((OQLAST)a).writeInSQLQuery(nr));
        }
    }

    public void prepare() throws RecognitionException {
        this.treatExpressionIdentifiers();
        this.computeExpressionTypes();
        this.computeProjectionTypes();
        this.computeParameterTypes();
    }

    @Override
    public String writeInSQLQuery(NameResolver nr) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        this.writeDistinct(nr, sb);
        this.writeProjection(nr, sb);
        if (this.labels.size() > 0) {
            sb.append(" FROM ");
            this.writeFrom(nr, sb);
        }
        this.writeJoins(nr, sb);
        if (this.whereAST != null) {
            sb.append(" WHERE ");
            this.writeConditions(nr, sb);
        }
        this.writeAfterWhere(nr, sb);
        return sb.toString();
    }

    @Override
    public String getQuery() {
        return this.getOQL();
    }

    @Override
    public String getPreProcessedQuery(String query) {
        return this.getQuery();
    }

    @Override
    public Map<String, DataDefinition> getLabelTypes() {
        return this.labels;
    }

    @Override
    public DataDefinition getTypeOfExprField(String expr) {
        DataDefinition result;
        if (expr.indexOf(".") == -1) {
            return this.getLabelType(expr);
        }
        int lastDot = expr.lastIndexOf(".");
        String beforeLastDot = expr.substring(0, lastDot);
        if (beforeLastDot.indexOf(".") == -1) {
            result = this.getLabelType(beforeLastDot);
        } else {
            String dummyQuery = "SELECT " + beforeLastDot + " AS projection FROM " + this.getFrom();
            try {
                result = OQLQueryAnalysisProvider.parseQueryFundamental(dummyQuery).getProjectionType().getFieldDefinition("projection").getPointedType();
            }
            catch (RecognitionException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return result;
    }

    private String getFrom() {
        String[] splitAtFrom = this.originalQuery.split("\\s[f|F][r|R][o|O][m|M]\\s");
        String[] splitAtWhere = splitAtFrom[1].split("\\s[w|W][h|H][e|E][r|R][e|E]\\s");
        return splitAtWhere[0];
    }

    @Override
    public Dictionary<String, String> getProjections() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (int i = 0; i < this.projections.size(); ++i) {
            String expr = this.projections.get((int)i).expr.getText();
            if (expr.indexOf("count(") > -1 || expr.indexOf("max(") > -1 || expr.indexOf("min(") > -1 || expr.indexOf("avg(") > -1 || expr.indexOf("sum(") > -1) {
                expr = (String)this.projections.get((int)i).expr.extraInfo;
            }
            ((Dictionary)result).put(this.projections.get((int)i).as == null ? "col" + i : this.projections.get((int)i).as, expr);
        }
        return result;
    }

    @Override
    public String getFieldOfExpr(String expr) {
        if (expr.indexOf(".") > -1) {
            return expr.substring(expr.lastIndexOf(".") + 1);
        }
        return expr;
    }

    class Join {
        String label1;
        String field1;
        String label2;
        String field2;
        boolean leftJoin;

        public Join(String l1, String f1, String l2, String f2, boolean leftJoin) {
            this.label1 = l1;
            this.label2 = l2;
            this.field1 = f1;
            this.field2 = f2;
            this.leftJoin = leftJoin;
        }

        public String toString() {
            return this.label1 + "." + this.field1 + " JOIN " + this.label2 + "." + this.field2;
        }
    }
}

