/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.Pointer;
import org.makumba.db.makumba.ClosedDBConnection;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.Database;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.TransactionProviderInterface;

public class DBConnectionWrapper
extends DBConnection {
    DBConnection wrapped;
    private TransactionProvider tp;
    Throwable t;
    Date created;

    public DBConnection getWrapped() {
        return this.wrapped;
    }

    DBConnectionWrapper(TransactionProviderInterface tp) {
        super(tp);
    }

    DBConnectionWrapper(DBConnection wrapped, String dataSource, TransactionProviderInterface tp) {
        this(tp);
        this.t = new Throwable();
        this.created = new Date();
        this.wrapped = wrapped;
        this.dataSource = dataSource;
    }

    public String getName() {
        return this.getWrapped().getName();
    }

    public Database getHostDatabase() {
        return this.getWrapped().getHostDatabase();
    }

    public Dictionary read(Pointer ptr, Object fields) {
        return this.getWrapped().read(ptr, fields);
    }

    public Vector executeQuery(String OQL, Object parameterValues, int offset, int limit) {
        return this.getWrapped().executeQuery(OQL, parameterValues, offset, limit);
    }

    public Pointer insert(String type, Dictionary data) {
        return this.getWrapped().insert(type, data);
    }

    public Pointer insert(Pointer host, String subsetField, Dictionary data) {
        return this.getWrapped().insert(host, subsetField, data);
    }

    public void update(Pointer ptr, Dictionary fieldsToChange) {
        this.getWrapped().update(ptr, fieldsToChange);
    }

    public int update(String from, String set, String where, Object parameters) {
        return this.getWrapped().update(from, set, where, parameters);
    }

    public void delete(Pointer ptr) {
        this.getWrapped().delete(ptr);
    }

    public int delete(String from, String where, Object parameters) {
        return this.getWrapped().delete(from, where, parameters);
    }

    public void commit() {
        this.getWrapped().unlockAll();
        this.getWrapped().commit();
    }

    public void rollback() {
        this.getWrapped().unlockAll();
        this.getWrapped().rollback();
    }

    public void lock(String symbol) {
        this.getWrapped().lock(symbol);
    }

    public void unlock(String symbol) {
        this.getWrapped().lock(symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            this.commit();
            this.getHostDatabase().connections.put(this.getWrapped());
        }
        finally {
            this.wrapped = ClosedDBConnection.getInstance();
        }
    }

    protected synchronized void finalize() {
        if (this.wrapped != ClosedDBConnection.getInstance()) {
            Logger.getLogger("org.makumba.db").severe("Makumba connection " + this.getName() + " not closed\n" + this.getCreationStack());
            this.close();
        }
    }

    public String getCreationStack() {
        StringWriter sbw = new StringWriter();
        PrintWriter output = new PrintWriter(sbw);
        output.print("connection created on" + this.created + " with stacktrace: ");
        this.t.printStackTrace(output);
        return sbw.toString();
    }

    public String toString() {
        return this.getWrapped() + " " + this.getCreationStack();
    }
}

