/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.makumba.CompositeValidationException;
import org.makumba.InvalidValueException;
import org.makumba.commons.ControllerHandler;
import org.makumba.commons.ServletObjects;
import org.makumba.commons.StringUtils;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.responder.ResponderFactory;

public class ResponseControllerHandler
extends ControllerHandler {
    public static final String MAKUMBA_FORM_VALIDATION_ERRORS = "__makumba__formValidationErrors__";
    public static final String MAKUMBA_FORM_RELOAD = "__makumba__formReload__";
    private ResponderFactory factory = ResponderFactory.getInstance();

    public boolean beforeFilter(ServletRequest req, ServletResponse resp, FilterConfig conf, ServletObjects httpServletObjects) throws Exception {
        Exception e = this.factory.getResponse((HttpServletRequest)req, (HttpServletResponse)resp);
        if (e instanceof CompositeValidationException) {
            String message;
            CompositeValidationException v = (CompositeValidationException)e;
            req.setAttribute(MAKUMBA_FORM_VALIDATION_ERRORS, (Object)v);
            req.setAttribute(MAKUMBA_FORM_RELOAD, (Object)"true");
            Responder firstResponder = this.factory.getFirstResponder(req);
            Logger.getLogger("org.makumba.controller").fine("Caught a CompositeValidationException, reloading form page: " + firstResponder.getReloadFormOnError());
            if (firstResponder.getReloadFormOnError()) {
                String root = conf.getInitParameter(req.getServerName());
                httpServletObjects.setRequest(this.getFormReloadRequest(req));
                httpServletObjects.setResponse(this.getFormReloadResponse(resp, root));
                Logger.getLogger("org.makumba.controller").fine("CompositeValidationException: annotating form: " + firstResponder.getShowFormAnnotated());
                if (firstResponder.getShowFormAnnotated()) {
                    Logger.getLogger("org.makumba.controller").finer("Processing CompositeValidationException for annotation:\n" + v.toString());
                    ArrayList<InvalidValueException> unassignedExceptions = this.factory.getUnassignedExceptions(v, (HttpServletRequest)req);
                    Logger.getLogger("org.makumba.controller").finer("Exceptions not assigned:\n" + StringUtils.toString(unassignedExceptions));
                    message = "";
                    Iterator<InvalidValueException> i$ = unassignedExceptions.iterator();
                    while (i$.hasNext()) {
                        InvalidValueException invalidValueException;
                        InvalidValueException invEx = invalidValueException = i$.next();
                        message = message + invEx.getMessage() + "<br>";
                    }
                } else {
                    message = v.toString();
                }
            } else {
                message = v.toString();
            }
            message = Responder.errorMessage(message);
            req.setAttribute("makumba.response", (Object)message);
        }
        return true;
    }

    private ServletResponse getFormReloadResponse(ServletResponse resp, final String root) {
        resp = new HttpServletResponseWrapper((HttpServletResponse)resp){

            public void sendRedirect(String s) throws IOException {
                if (root != null && s.startsWith(root)) {
                    s = s.substring(root.length());
                }
                ((HttpServletResponse)this.getResponse()).sendRedirect(s);
            }
        };
        return resp;
    }

    private ServletRequest getFormReloadRequest(ServletRequest req) {
        req = new HttpServletRequestWrapper((HttpServletRequest)req){

            public String getServletPath() {
                String contextPath;
                HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
                String originatingPage = httpServletRequest.getParameter("__makumba__originatingPage__");
                if (originatingPage.startsWith(contextPath = httpServletRequest.getContextPath())) {
                    originatingPage = originatingPage.substring(contextPath.length());
                }
                if (originatingPage.indexOf("?") > 0) {
                    originatingPage = originatingPage.substring(0, originatingPage.indexOf("?"));
                }
                return originatingPage;
            }

            public String getRequestURI() {
                return this.getRequest().getParameter("__makumba__originatingPage__");
            }
        };
        return req;
    }
}

