/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.makumba.FieldDefinition;
import org.makumba.LogicException;
import org.makumba.ProgrammerError;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.attributes.PageAttributes;
import org.makumba.commons.tags.GenericMakumbaTag;
import org.makumba.forms.tags.FormTagBase;
import org.makumba.forms.tags.InputTag;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.FormDataProvider;

public abstract class BasicValueTag
extends GenericMakumbaTag {
    public static final String INPUT_TYPES = "org.makumba.inputtypes";
    protected DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    String valueExprOriginal = null;
    String dataType = null;
    public String expr = null;
    protected FormDataProvider fdp;

    public BasicValueTag() {
        try {
            this.fdp = (FormDataProvider)Class.forName("org.makumba.list.ListFormDataProvider").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void setValue(String value) {
        this.valueExprOriginal = value.trim();
    }

    public FormTagBase getForm() {
        return (FormTagBase)TagSupport.findAncestorWithClass((Tag)this, FormTagBase.class);
    }

    public boolean isNull() {
        return this.expr == null || this.expr.trim().length() == 0 || this.expr.trim().equals("nil");
    }

    boolean isValue() {
        return this.expr != null && !this.expr.startsWith("$") && !this.isNull();
    }

    boolean isAttribute() {
        return this.expr != null && this.expr.startsWith("$");
    }

    public void doStartAnalyze(PageCache pageCache) {
        if (this.isValue()) {
            this.fdp.onBasicValueStartAnalyze(this, this.isNull(), this.getForm().getTagKey(), pageCache, this.expr);
        }
    }

    public String checkPtrExpr(String expr2, PageCache pageCache) {
        return expr2;
    }

    abstract FieldDefinition getTypeFromContext(PageCache var1);

    public void doEndAnalyze(PageCache pageCache) {
        FieldDefinition contextType = this.getTypeFromContext(pageCache);
        FieldDefinition dataTypeInfo = null;
        FieldDefinition type = null;
        if (this.dataType != null) {
            dataTypeInfo = this.ddp.makeFieldDefinition("dummyName", this.dataType);
            if (contextType != null && !contextType.isAssignableFrom(dataTypeInfo)) {
                throw new ProgrammerError("declared data type '" + this.dataType + "' not compatible with the type computed from context '" + contextType + "'");
            }
        }
        if (this.isValue()) {
            type = this.fdp.onBasicValueEndAnalyze(this.getTagKey(), pageCache);
        }
        if (this.isAttribute()) {
            type = (FieldDefinition)pageCache.retrieve("org.makumba.types", this.expr.substring(1));
        }
        String fieldName = "";
        if (this instanceof InputTag) {
            fieldName = "Field <" + ((InputTag)this).name + ">: ";
        }
        if (type != null && dataTypeInfo != null && !dataTypeInfo.isAssignableFrom(type)) {
            throw new ProgrammerError(fieldName + "computed type for INPUT is different from the indicated dataType. The dataType is indicated to '" + this.dataType + "' type computed is '" + type + "'");
        }
        if (type != null && contextType != null && !contextType.isAssignableFrom(type)) {
            String contextTypeStr = contextType.getType();
            String typeStr = type.getType();
            if (contextTypeStr.equals("ptr") && typeStr.equals("ptr")) {
                contextTypeStr = contextTypeStr + " " + contextType.getSubtable().getName();
                typeStr = typeStr + " " + type.getSubtable().getName();
            }
            throw new ProgrammerError(fieldName + "The computed type is different from the type resulting from the analysis of the form. The context type was determined to '" + contextTypeStr + "', type computed is '" + typeStr + "'");
        }
        if (type == null && contextType == null && dataTypeInfo == null) {
            throw new ProgrammerError(fieldName + "cannot determine input type. Please specify the type using dataType=...");
        }
        if (contextType == null) {
            contextType = dataTypeInfo != null ? dataTypeInfo : type;
        }
        pageCache.cache(INPUT_TYPES, this.tagKey, contextType);
    }

    public int doAnalyzedEndTag(PageCache pageCache) throws JspException, LogicException {
        this.params.put("org.makumba.forms.queryLanguage", MakumbaJspAnalyzer.getQueryLanguage(pageCache));
        FieldDefinition type = (FieldDefinition)pageCache.retrieve(INPUT_TYPES, this.tagKey);
        Object val = null;
        if (this.isValue()) {
            val = this.fdp.getValue(this.getTagKey(), this.getPageContext(), pageCache);
        }
        if (this.isAttribute()) {
            val = PageAttributes.getAttributes(this.pageContext).getAttribute(this.expr.substring(1));
        }
        if (val != null) {
            val = type.checkValue(val);
        }
        return this.computedValue(val, type);
    }

    abstract int computedValue(Object var1, FieldDefinition var2) throws JspException, LogicException;

    protected void doAnalyzedCleanup() {
        super.doAnalyzedCleanup();
        this.dataType = null;
        this.valueExprOriginal = null;
        this.expr = null;
    }
}

