/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.oql;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.makumba.commons.NameResolver;
import org.makumba.commons.StringUtils;
import org.makumba.providers.query.oql.OQLAST;

public class FunctionAST
extends OQLAST {
    public static String[] simpleStringFunctions = new String[]{"lower(", "upper(", "trim(", "rtrim(", "ltrim("};
    public static String[] intToStringFunctions = new String[]{"char("};
    public static String[] stringToIntFunctions = new String[]{"ascii(", "character_length("};
    public static String[] dateToIntFunctions = new String[]{"dayOfMonth(", "dayOfWeek(", "dayOfYear(", "month(", "hour(", "minute(", "second("};
    public static String[] dateToStringFunctions = new String[]{"monthName(", "dayName("};
    public static String[] nonParametricDateFunctions = new String[]{"current_date", "current_time", "current_timestamp"};
    public static final String[] allNonParametricFunctions;
    public static final String[] allSingleParameterFunctions;
    public static final String[] allFunctions;
    private static final long serialVersionUID = 1L;
    OQLAST expr;

    public void setExpr(OQLAST e) {
        this.expr = e;
    }

    public String writeInSQLQuery(NameResolver nr) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getText());
        if (this.expr != null) {
            sb.append(this.expr.writeInSQLQuery(nr));
            AST a = this.expr.getNextSibling();
            while (!a.getText().equals(")")) {
                sb.append(((OQLAST)a).writeInSQLQuery(nr));
                a = a.getNextSibling();
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public Object getMakumbaType() throws RecognitionException {
        if (this.expr != null) {
            Object o = this.expr.getMakumbaType();
            String os = o.toString();
            if (StringUtils.startsWith(this.getText(), simpleStringFunctions)) {
                if (os.startsWith("char") || os.startsWith("text")) {
                    return o;
                }
                throw new SemanticException("cannot " + FunctionAST.printOptions(simpleStringFunctions) + " a '" + os + "' type");
            }
            if (StringUtils.startsWith(this.getText(), stringToIntFunctions)) {
                if (os.startsWith("char") || os.startsWith("text")) {
                    return "int";
                }
                throw new SemanticException("cannot " + FunctionAST.printOptions(stringToIntFunctions) + " a '" + os + "' type");
            }
            if (StringUtils.startsWith(this.getText(), intToStringFunctions)) {
                if (os.startsWith("int")) {
                    return "char";
                }
                throw new SemanticException("cannot " + FunctionAST.printOptions(intToStringFunctions) + " a '" + os + "' type");
            }
            if (StringUtils.startsWith(this.getText(), dateToIntFunctions)) {
                if (os.startsWith("date")) {
                    return "int";
                }
                throw new SemanticException("cannot " + FunctionAST.printOptions(dateToIntFunctions) + " a '" + os + "' type");
            }
            if (StringUtils.startsWith(this.getText(), dateToStringFunctions)) {
                if (os.startsWith("date")) {
                    return "text";
                }
                throw new SemanticException("cannot " + FunctionAST.printOptions(dateToStringFunctions) + " a '" + os + "' type");
            }
        } else {
            if (StringUtils.startsWith(this.getText(), nonParametricDateFunctions)) {
                return "date";
            }
            throw new SemanticException("non-parametric functions are: " + StringUtils.toString((Object[])allNonParametricFunctions, false));
        }
        throw new SemanticException("function expressions can be " + StringUtils.toString((Object[])allFunctions, false));
    }

    public static String printOptions(String[] functions) {
        String s = "";
        for (int i = 0; i < functions.length; ++i) {
            s = s + functions[i] + ")";
            if (i >= functions.length - 1) continue;
            s = s + " or ";
        }
        return s;
    }

    static {
        ArrayList allSingleParameter = new ArrayList();
        CollectionUtils.addAll(allSingleParameter, (Object[])simpleStringFunctions);
        CollectionUtils.addAll(allSingleParameter, (Object[])intToStringFunctions);
        CollectionUtils.addAll(allSingleParameter, (Object[])stringToIntFunctions);
        allSingleParameterFunctions = allSingleParameter.toArray(new String[allSingleParameter.size()]);
        ArrayList allNonParemtric = new ArrayList();
        CollectionUtils.addAll(allNonParemtric, (Object[])nonParametricDateFunctions);
        allNonParametricFunctions = allNonParemtric.toArray(new String[allNonParemtric.size()]);
        ArrayList all = new ArrayList();
        CollectionUtils.addAll(all, (Object[])allNonParametricFunctions);
        CollectionUtils.addAll(all, (Object[])allSingleParameterFunctions);
        allFunctions = all.toArray(new String[all.size()]);
    }
}

