///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: CodeGeneratorTemplate.java 2679 2008-06-28 20:26:20Z manuel_gay $
//  $Name$
/////////////////////////////////////

package org.makumba.devel;

import java.util.Properties;

/**
 * This class defines a template for JSP files generated by the code generator. Templates are stored and read from
 * {@link Properties} files. Makumba defines some code templates internally; custom templates can be defined by users
 * and put into a directory called <code>codeTemplates</code> in the classes path of the web application.
 * 
 * @author rudi
 * @version $Id: CodeGeneratorTemplate.java 2679 2008-06-28 20:26:20Z manuel_gay $
 */
public class CodeGeneratorTemplate {
    static final String DEFAULT_STYLE_HEADER = "<%@ taglib uri=\"http://java.sun.com/jstl/core_rt\" prefix=\"c\" %>\n";

    String afterField;

    String afterFieldName;

    String afterFieldTag;

    String afterFormBegin;

    String beforeField;

    String beforeFieldName;

    String beforeFieldTag;

    String beforeFormEnd;

    String footer;

    String header;

    String beforePageHeader;

    String afterPageHeader;

    String beforePageHeaderLevel2;

    String afterPageHeaderLevel2;

    public CodeGeneratorTemplate() {
    }

    public CodeGeneratorTemplate(Properties props, String queryLanguage) {
        if(queryLanguage.equals(CodeGenerator.QL_OQL)) {
            header = CodeGenerator.OQL_TLD_DEFINITION;
        } else if (queryLanguage.equals(CodeGenerator.QL_HQL)) {
            header = CodeGenerator.HQL_TLD_DEFINITION;
        }
        header +="\n";
        header += (String) props.getProperty("header", DEFAULT_STYLE_HEADER);
        footer = (String) props.getProperty("footer", "");
        afterFormBegin = (String) props.getProperty("afterFormBegin", "");
        beforeFormEnd = (String) props.getProperty("beforeFormEnd", "");
        beforeField = (String) props.getProperty("beforeField", "");
        afterField = (String) props.getProperty("afterField", "");
        beforeFieldName = (String) props.getProperty("beforeFieldName", "");
        afterFieldName = (String) props.getProperty("afterFieldName", "");
        beforeFieldTag = (String) props.getProperty("beforeFieldTag", "");
        afterFieldTag = (String) props.getProperty("afterFieldTag", "");
        beforePageHeader = (String) props.getProperty("beforePageHeader", "");
        afterPageHeader = (String) props.getProperty("afterPageHeader", "");
        beforePageHeaderLevel2 = (String) props.getProperty("beforePageHeaderLevel2", beforePageHeader);
        afterPageHeaderLevel2 = (String) props.getProperty("afterPageHeaderLevel2", afterPageHeader);
    }
}
