///////////////////////////////
//  Makumba, Makumba tag library
//  Copyright (C) 2000-2003  http://www.makumba.org
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2.1 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//  -------------
//  $Id: AggregateAST.java 2046 2007-11-13 16:45:44Z manuel_gay $
//  $Name$
/////////////////////////////////////

package org.makumba.providers.query.oql;
import org.makumba.commons.NameResolver;

import antlr.collections.AST;

public class AggregateAST extends OQLAST
{
  /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
OQLAST expr;

  public AggregateAST(){}
  //  public IdAST(antlr.Token t) { super(t); }

    public void setExpr(OQLAST e){ expr=e; }

    @Override
    public String writeInSQLQuery(NameResolver nr)
    {
		StringBuffer sb= new StringBuffer();
		sb.append(getText());
		sb.append(expr.writeInSQLQuery(nr));
		 for(AST a= expr.getNextSibling(); !a.getText().equals(")"); a=a.getNextSibling())
			  sb.append(((OQLAST)a).writeInSQLQuery(nr));
		 
		sb.append(")");
		return sb.toString();	
    }
    @Override   
    public Object getMakumbaType() throws antlr.RecognitionException
    {
	Object o= expr.getMakumbaType();
	String os= ""+o;
	if(getText().startsWith("max")||getText().startsWith("min"))
	    {
		if(os.startsWith("int") ||os.startsWith("real") || os.startsWith("date") || os.startsWith("ptr") || os.startsWith("char") || os.startsWith("text"))
		    return o;
		throw new antlr.SemanticException("cannot min() or max() a "+os);
	    }

	if(getText().startsWith("sum"))
	    {
		if(os.startsWith("int"))
		    return "int";
		if(os.startsWith("real"))
		    return "real";
		throw new antlr.SemanticException("cannot sum() a "+os);
	   } 

	if(getText().startsWith("avg"))
	    {
		if(os.startsWith("int") || os.startsWith("real"))
		    return "real";
		throw new antlr.SemanticException("cannot avg() a "+os);
	   } 

	throw new antlr.SemanticException("aggregate expressions can be sum, min, max, avg");
    }

}
