/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.makumba.analyser.AnalysableTag;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.analyser.interfaces.JspAnalyzer;
import org.makumba.commons.ParseStatus;

public class MakumbaJspAnalyzer
implements JspAnalyzer {
    static String[] listTags;
    static String[] oldFormTags;
    static String[] formTags;
    static String[] formTagNames;
    static final Map<String, Class<?>> tagClasses;
    static final List<String> formTagNamesList;
    public static final String TAG_CACHE = "org.makumba.tags";
    public static final String DEPENDENCY_CACHE = "org.makumba.dependency";
    static final String QUERY_LANGUAGE = "org.makumba.queryLanguage";

    protected MakumbaJspAnalyzer() {
    }

    public static JspAnalyzer getInstance() {
        return SingletonHolder.singleton;
    }

    public void systemTag(TagData td, Object status) {
        if (td.name.equals("taglib")) {
            if (td.attributes.get("uri") != null && td.attributes.get("uri").toString().startsWith("http://www.makumba.org/")) {
                String prefix = td.attributes.get("prefix");
                String URI2 = td.attributes.get("uri");
                if (URI2.equals("http://www.makumba.org/presentation") || URI2.equals("http://www.makumba.org/list")) {
                    ((ParseStatus)status).makumbaPrefix = prefix;
                    ((ParseStatus)status).makumbaURI = URI2;
                    ((ParseStatus)status).pageCache.cache(QUERY_LANGUAGE, QUERY_LANGUAGE, "oql");
                } else if (URI2.equals("http://www.makumba.org/view-hql") || URI2.equals("http://www.makumba.org/hibernate") || URI2.equals("http://www.makumba.org/list-hql")) {
                    ((ParseStatus)status).makumbaPrefix = prefix;
                    ((ParseStatus)status).makumbaURI = URI2;
                    ((ParseStatus)status).pageCache.cache(QUERY_LANGUAGE, QUERY_LANGUAGE, "hql");
                } else if (URI2.equals("http://www.makumba.org/forms")) {
                    ((ParseStatus)status).formPrefix = prefix;
                    ((ParseStatus)status).formMakumbaURI = URI2;
                    if (((ParseStatus)status).pageCache.retrieve(QUERY_LANGUAGE, QUERY_LANGUAGE) == null) {
                        ((ParseStatus)status).pageCache.cache(QUERY_LANGUAGE, QUERY_LANGUAGE, "oql");
                    }
                }
            }
        } else {
            this.handleNonMakumbaSystemTags(td, status);
        }
    }

    public void simpleTag(TagData td, Object status) {
        String makumbaPrefix = ((ParseStatus)status).makumbaPrefix + ":";
        String formsPrefix = ((ParseStatus)status).formPrefix + ":";
        if (!td.name.startsWith(makumbaPrefix) && !td.name.startsWith(formsPrefix)) {
            this.handleNonMakumbaTags(td, status);
        } else {
            String tagName = "";
            if (td.name.startsWith(makumbaPrefix)) {
                tagName = td.name.substring(makumbaPrefix.length());
            } else if (td.name.startsWith(formsPrefix)) {
                tagName = td.name.substring(formsPrefix.length());
            }
            Class<?> c = tagClasses.get(tagName);
            if (c == null) {
                return;
            }
            AnalysableTag.analyzedTag.set(td);
            AnalysableTag t = null;
            try {
                t = (AnalysableTag)((Object)c.newInstance());
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
            td.tagObject = t;
            t.setTagDataAtAnalysis(td);
            ((ParseStatus)status).addTag(t, td);
            AnalysableTag.analyzedTag.set(null);
        }
    }

    protected void handleNonMakumbaTags(TagData td, Object status) {
    }

    protected void handleNonMakumbaSystemTags(TagData td, Object status) {
    }

    public void startTag(TagData td, Object status) {
        this.simpleTag(td, status);
        ((ParseStatus)status).start((AnalysableTag)((Object)td.tagObject));
    }

    public void endTag(TagData td, Object status) {
        AnalysableTag.analyzedTag.set(td);
        ((ParseStatus)status).end(td);
        AnalysableTag.analyzedTag.set(null);
    }

    public Object makeStatusHolder(Object initialStatus) {
        return new ParseStatus();
    }

    public Object endPage(Object status) {
        ((ParseStatus)status).endPage();
        return ((ParseStatus)status).pageCache;
    }

    public static String getQueryLanguage(PageCache pageCache) {
        return (String)pageCache.retrieve(QUERY_LANGUAGE, QUERY_LANGUAGE);
    }

    static {
        int i;
        listTags = new String[]{"value", "org.makumba.list.tags.ValueTag", "list", "org.makumba.list.tags.QueryTag", "object", "org.makumba.list.tags.ObjectTag", "if", "org.makumba.list.tags.IfTag", "resultList", "org.makumba.list.tags.ResultListTag", "pagination", "org.makumba.list.pagination.PaginationTag"};
        oldFormTags = new String[]{"form", "org.makumba.forms.tags.FormTagBase", "newForm", "org.makumba.forms.tags.NewTag", "addForm", "org.makumba.forms.tags.AddTag", "editForm", "org.makumba.forms.tags.EditTag", "deleteLink", "org.makumba.forms.tags.DeleteTag", "delete", "org.makumba.forms.tags.DeleteTag", "input", "org.makumba.forms.tags.InputTag", "action", "org.makumba.forms.tags.ActionTag", "option", "org.makumba.forms.tags.OptionTag", "searchForm", "org.makumba.forms.tags.SearchTag", "criterion", "org.makumba.forms.tags.CriterionTag", "searchField", "org.makumba.forms.tags.SearchFieldTag", "matchMode", "org.makumba.forms.tags.MatchModeTag"};
        formTags = new String[]{"form", "org.makumba.forms.tags.FormTagBase", "new", "org.makumba.forms.tags.NewTag", "add", "org.makumba.forms.tags.AddTag", "edit", "org.makumba.forms.tags.EditTag", "deleteLink", "org.makumba.forms.tags.DeleteTag", "delete", "org.makumba.forms.tags.DeleteTag", "input", "org.makumba.forms.tags.InputTag", "action", "org.makumba.forms.tags.ActionTag", "option", "org.makumba.forms.tags.OptionTag"};
        formTagNames = new String[]{"form", "newForm", "addForm", "editForm", "deleteLink", "delete", "searchForm", "new", "add", "edit"};
        tagClasses = new HashMap();
        formTagNamesList = Arrays.asList(formTagNames);
        for (i = 0; i < listTags.length; i += 2) {
            try {
                tagClasses.put(listTags[i], Class.forName(listTags[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        for (i = 0; i < oldFormTags.length; i += 2) {
            try {
                tagClasses.put(oldFormTags[i], Class.forName(oldFormTags[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        for (i = 0; i < formTags.length; i += 2) {
            try {
                tagClasses.put(formTags[i], Class.forName(formTags[i + 1]));
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static final class SingletonHolder {
        static final JspAnalyzer singleton = new MakumbaJspAnalyzer();

        private SingletonHolder() {
        }
    }
}

