/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.makumba.DBError;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.sql.Database;
import org.makumba.db.makumba.sql.SQLDBConnection;

public class MsSqlDatabase
extends Database {
    public MsSqlDatabase(Properties p) {
        super(MsSqlDatabase.addProperties(p));
    }

    private static Properties addProperties(Properties p) {
        p.put("sql.DatabaseName", p.getProperty("#database"));
        p.put("sql.SelectMethod", "Cursor");
        return p;
    }

    protected String getJdbcUrl(Properties p) {
        super.getJdbcUrl(p);
        String url = "jdbc:microsoft:sqlserver://";
        String host = p.getProperty("#host");
        host = host.replaceAll("!", "\\\\");
        url = url + host;
        return url;
    }

    protected DBConnection makeDBConnection() {
        SQLDBConnection dbc = (SQLDBConnection)super.makeDBConnection();
        try {
            Statement s = dbc.createStatement();
            s.execute("SET QUOTED_IDENTIFIER OFF");
        }
        catch (SQLException e) {
            MsSqlDatabase.logException(e);
            throw new DBError(e);
        }
        return dbc;
    }

    public boolean supportsLimitInQuery() {
        return false;
    }
}

