/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.html;

import java.util.Dictionary;
import org.makumba.ProgrammerError;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.InvalidValueException;
import org.makumba.commons.formatters.RecordFormatter;

public class FieldEditor
extends FieldFormatter {
    public static final String ERROR_NO_INT = "invalid integer";
    public static final String ERROR_NO_BOOLEAN = "invalid boolean";
    public static final String ERROR_NO_REAL = "invalid real";
    static String[] params = new String[]{"default", "empty", "type"};
    static String[][] paramValues = new String[][]{null, null, {"hidden"}};
    static final String suffixName = "org.makumba.editorSuffix";
    public static final String extraFormattingParam = "makumba.extraFormatting";

    protected FieldEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String[] getAcceptedParams() {
        return params;
    }

    public String[][] getAcceptedValue() {
        return paramValues;
    }

    public static String getSuffix(RecordFormatter rf, int fieldIndex, Dictionary formatParams) {
        return (String)formatParams.get(suffixName);
    }

    public static void setSuffix(Dictionary formatParams, String suffix) {
        formatParams.put(suffixName, suffix);
    }

    public void checkParam(RecordFormatter rf, int fieldIndex, String name, String val) {
        if (name.equals(extraFormattingParam)) {
            return;
        }
        if (name.equals("type") && val.equals("hidden")) {
            return;
        }
        super.checkParam(rf, fieldIndex, name, val);
    }

    public String format(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        String s = (String)formatParams.get("type");
        if (s != null && s.equals("hidden")) {
            return this.formatHidden(rf, fieldIndex, o, formatParams);
        }
        return this.formatShow(rf, fieldIndex, o, formatParams);
    }

    public String formatShow(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        return super.format(rf, fieldIndex, o, formatParams);
    }

    public String formatHidden(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        return "<input type=\"hidden\" name=\"" + this.getInputName(rf, fieldIndex, formatParams) + "\" value=\"" + this.formatHiddenValue(rf, fieldIndex, o, formatParams) + "\" " + FieldEditor.getExtraFormatting(rf, fieldIndex, formatParams) + ">";
    }

    public String formatHiddenValue(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        return this.formatValue(rf, fieldIndex, o, formatParams);
    }

    public String formatValue(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        throw new ProgrammerError("If this method is needed, overload it in the inheriting class");
    }

    public void onStartup(RecordFormatter rf, int fieldIndex) {
    }

    public String getInputName(RecordFormatter rf, int fieldIndex, Dictionary formatParams) {
        return this.getInputName(rf, fieldIndex, FieldEditor.getSuffix(rf, fieldIndex, formatParams));
    }

    public String getInputName(RecordFormatter rf, int fieldIndex, String suffix) {
        return rf.expr[fieldIndex] + suffix;
    }

    public static String getExtraFormatting(RecordFormatter rf, int fieldIndex, Dictionary formatParams) {
        return (String)formatParams.get(extraFormattingParam);
    }

    public static void setExtraFormatting(Dictionary formatParams, String extraFormatting) {
        formatParams.put(extraFormattingParam, extraFormatting);
    }

    public Object readFrom(RecordFormatter rf, int fieldIndex, HttpParameters p, String suffix) {
        return p.getParameter(this.getInputName(rf, fieldIndex, suffix));
    }

    protected Integer toInt(RecordFormatter rf, int fieldIndex, Object o) {
        if (o == null) {
            return null;
        }
        String s = ("" + o).trim();
        if (s.length() == 0) {
            return null;
        }
        try {
            return new Integer(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(rf.expr[fieldIndex], "invalid integer: " + o);
        }
    }

    protected Boolean toBoolean(RecordFormatter rf, int fieldIndex, Object o) {
        if (o == null) {
            return null;
        }
        if (o.toString().equalsIgnoreCase("true") || o.toString().equalsIgnoreCase("yes") || o.toString().equalsIgnoreCase("1")) {
            return true;
        }
        if (o.toString().equalsIgnoreCase("false") || o.toString().equalsIgnoreCase("no") || o.toString().equalsIgnoreCase("0")) {
            return false;
        }
        throw new InvalidValueException(rf.expr[fieldIndex], "invalid boolean: " + o);
    }

    protected Double toReal(RecordFormatter rf, int fieldIndex, Object o) {
        if (o == null) {
            return null;
        }
        String s = ("" + o).trim();
        if (s.length() == 0) {
            return null;
        }
        try {
            return new Double(Double.parseDouble(s));
        }
        catch (NumberFormatException e) {
            try {
                return new Double(Double.parseDouble(s.replace(',', '.')));
            }
            catch (NumberFormatException e2) {
                try {
                    return new Double(Double.parseDouble(s.replace('.', ',')));
                }
                catch (NumberFormatException e3) {
                    throw new InvalidValueException(rf.expr[fieldIndex], "invalid real: " + o);
                }
            }
        }
    }

    private static final class SingletonHolder {
        static final FieldEditor singleton = new FieldEditor();

        private SingletonHolder() {
        }
    }
}

