/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.html;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.InvalidValueException;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.commons.formatters.dateFormatter;
import org.makumba.forms.html.FieldEditor;

public class dateEditor
extends FieldEditor {
    static String[] _params = new String[]{"format", "calendarEditor", "calendarEditorLink"};
    static String[][] _paramValues = new String[][]{null, {"true", "false"}, null};
    static final String recognized = "dMyHms";
    static int[] lowLimits = new int[]{1, 0, -1, 0, 0, 0};
    static int[] hiLimits = new int[]{31, 11, -1, 23, 59, 59};
    public static int[] components = new int[]{5, 2, 1, 11, 12, 13};
    static String[] componentNames = new String[]{"day", "month", "year", "hour", "minute", "second"};

    private dateEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String[] getAcceptedParams() {
        return _params;
    }

    public String[][] getAcceptedValue() {
        return _paramValues;
    }

    String getNullName(RecordFormatter rf, int fieldIndex, Dictionary formatParams) {
        return this.getNullName(rf, fieldIndex, dateEditor.getSuffix(rf, fieldIndex, formatParams));
    }

    String getNullName(RecordFormatter rf, int fieldIndex, String suffix) {
        return this.getInputName(rf, fieldIndex, suffix) + "_null";
    }

    String getComponentName(RecordFormatter rf, int fieldIndex, int i, String suffix) {
        return this.getInputName(rf, fieldIndex, suffix) + "_" + i;
    }

    String getComponentName(RecordFormatter rf, int fieldIndex, int i, Dictionary formatParams) {
        return this.getComponentName(rf, fieldIndex, i, dateEditor.getSuffix(rf, fieldIndex, formatParams));
    }

    public String format(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        String format = (String)formatParams.get("format");
        if (format == null) {
            format = "dd MMMMM yyyy";
        }
        if (o == Pointer.NullDate) {
            o = null;
        }
        Date d = (Date)o;
        StringBuffer sb = new StringBuffer();
        boolean hidden = "hidden".equals(formatParams.get("type"));
        if (d == null) {
            d = (Date)rf.dd.getFieldDefinition(fieldIndex).getDefaultValue();
            sb.append("<input type=\"hidden\" name=\"").append(this.getNullName(rf, fieldIndex, formatParams)).append("\">");
        }
        int n = 0;
        while ((n = this.findNextFormatter(rf, fieldIndex, sb, format, n, hidden)) != -1) {
            n = this.formatFrom(rf, fieldIndex, sb, d, format, n, hidden, formatParams);
        }
        String inputName = this.getInputName(rf, fieldIndex, dateEditor.getSuffix(rf, fieldIndex, formatParams));
        String calendarEditor = (String)formatParams.get("calendarEditor");
        if (calendarEditor != null && !"false".equals(calendarEditor)) {
            sb.append(MakumbaSystem.getCalendarProvider().formatEditorCode(inputName, (String)formatParams.get("calendarEditorLink")));
        }
        return sb.toString();
    }

    void formatComponent(RecordFormatter rf, int fieldIndex, StringBuffer sb, Date d, String fmt, int component, boolean hidden, Dictionary formatParams) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, MakumbaSystem.getLocale());
        df.setCalendar(dateFormatter.calendar);
        String name = this.getComponentName(rf, fieldIndex, component, formatParams);
        if (hidden) {
            GregorianCalendar c = new GregorianCalendar(MakumbaSystem.getTimeZone());
            c.setTime(d);
            sb.append("<input type=\"hidden\" name=\"").append(name).append("\" id=\"").append(name).append("\" value=\"").append(c.get(components[component])).append("\">");
        } else {
            String val = df.format(d);
            if (lowLimits[component] == -1) {
                sb.append("<input type=\"text\" name=\"").append(name).append("\" id=\"").append(name).append("\" value=\"").append(val).append("\" maxlength=\"").append(fmt.length()).append("\" size=\"").append(fmt.length()).append("\"").append(dateEditor.getExtraFormatting(rf, fieldIndex, formatParams)).append(">");
            } else {
                sb.append("<select name=\"").append(name).append("\" id=\"").append(name).append("\"").append(dateEditor.getExtraFormatting(rf, fieldIndex, formatParams)).append(">");
                GregorianCalendar c = new GregorianCalendar(MakumbaSystem.getTimeZone());
                c.clear();
                c.set(1900, 0, 1);
                for (int i = lowLimits[component]; i <= hiLimits[component]; ++i) {
                    c.set(components[component], i);
                    String opt = df.format(c.getTime());
                    sb.append("<option value=\"").append(i).append("\"");
                    if (opt.equals(val)) {
                        sb.append(" selected");
                    }
                    sb.append(">").append(opt).append("</option>");
                }
                sb.append("</select>");
            }
        }
    }

    public Object readFrom(RecordFormatter rf, int fieldIndex, HttpParameters pr, String suffix) {
        GregorianCalendar c = new GregorianCalendar(MakumbaSystem.getTimeZone());
        c.clear();
        for (int i = 0; i < components.length; ++i) {
            String name = this.getComponentName(rf, fieldIndex, i, suffix);
            Object o = pr.getParameter(name);
            if (o == null) continue;
            if (o instanceof Vector) {
                throw new InvalidValueException(rf.expr[fieldIndex], "Multiple value not allowed for '" + componentNames[i] + "' component");
            }
            int n = -1;
            try {
                n = Integer.parseInt((String)o);
            }
            catch (NumberFormatException e) {
                throw new InvalidValueException(rf.expr[fieldIndex], "Non-integer value not allowed for '" + componentNames[i] + "' component: " + o);
            }
            c.set(components[i], n);
        }
        Date d = c.getTime();
        if (d.equals(rf.dd.getFieldDefinition(fieldIndex).getDefaultValue()) && pr.getParameter(this.getNullName(rf, fieldIndex, suffix)) != null) {
            return null;
        }
        return d;
    }

    public static Object readFrom(String name, HttpParameters pr) {
        GregorianCalendar c = new GregorianCalendar(MakumbaSystem.getTimeZone());
        c.clear();
        for (int i = 0; i < components.length; ++i) {
            Object o = pr.getParameter(name + "_" + i);
            if (o == null) continue;
            int n = -1;
            try {
                n = Integer.parseInt((String)o);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            c.set(components[i], n);
        }
        return c.getTime();
    }

    int formatFrom(RecordFormatter rf, int fieldIndex, StringBuffer sb, Date d, String format, int n, boolean hidden, Dictionary formatParams) {
        int m = n;
        char c = format.charAt(n);
        while (++n < format.length() && format.charAt(n) == c) {
        }
        this.formatComponent(rf, fieldIndex, sb, d, format.substring(m, n), recognized.indexOf(c), hidden, formatParams);
        return n;
    }

    int findNextFormatter(RecordFormatter rf, int fieldIndex, StringBuffer sb, String format, int n, boolean hidden) {
        StringBuffer quoted = null;
        while (n < format.length()) {
            char c = format.charAt(n);
            if (c == '\'') {
                if (quoted != null) {
                    if (quoted.length() == 0) {
                        if (!hidden) {
                            sb.append('\'');
                        }
                        quoted = null;
                    } else {
                        if (!hidden) {
                            sb.append(quoted.toString());
                        }
                        quoted = null;
                    }
                } else {
                    quoted = new StringBuffer();
                }
            } else if (quoted != null) {
                quoted.append(c);
            } else if (!Character.isLetter(c)) {
                if (!hidden) {
                    sb.append(c);
                }
            } else {
                if (recognized.indexOf(c) == -1) {
                    throw new InvalidValueException(rf.expr[fieldIndex], "unrecognized formatting letter '" + c + "' in date format string <" + format + ">");
                }
                return n;
            }
            ++n;
        }
        if (quoted != null) {
            throw new InvalidValueException(rf.expr[fieldIndex], "unterminated single quote in date format string <" + format + ">");
        }
        return -1;
    }

    private static final class SingletonHolder {
        static final FieldEditor singleton = new dateEditor();

        private SingletonHolder() {
        }
    }
}

