/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.makumba.commons.NamedResources;

public class NamedResourcesContextListener
implements ServletContextListener {
    public NamedResourcesContextListener() {
        Logger.getLogger("org.makumba.system").info("loading makumba context listener");
    }

    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        Logger.getLogger("org.makumba.system").info("destroying makumba caches");
        NamedResources.cleanup();
        this.JDBCUnload();
    }

    private void JDBCUnload() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        ArrayList<Driver> driversToUnload = new ArrayList<Driver>();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() == null || !driver.getClass().getClassLoader().equals(this.getClass().getClassLoader())) continue;
            driversToUnload.add(driver);
        }
        for (Driver driver : driversToUnload) {
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

