/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.NoSuchFieldException;
import org.makumba.commons.ArrayMap;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.DBConnectionWrapper;
import org.makumba.db.makumba.Database;
import org.makumba.db.makumba.sql.NameResolverHook;
import org.makumba.db.makumba.sql.ParameterAssigner;
import org.makumba.db.makumba.sql.SQLDBConnection;
import org.makumba.db.makumba.sql.TableManager;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.query.oql.QueryAST;

public class Query
implements org.makumba.db.makumba.Query {
    String query;
    TableManager resultHandler;
    String command;
    ParameterAssigner assigner;
    String limitSyntax;
    boolean offsetFirst;
    boolean supportsLimitInQuery;
    String insertIn;
    TableManager insertHandler;

    public String getCommand() {
        return this.command;
    }

    public Query(Database db, String OQLQuery, String insertIn) {
        QueryAnalysisProvider qap = null;
        try {
            qap = (QueryAnalysisProvider)Class.forName("org.makumba.providers.query.oql.OQLQueryAnalysisProvider").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        QueryAnalysis qA = qap.getQueryAnalysis(OQLQuery);
        this.command = ((QueryAST)qA).writeInSQLQuery(new NameResolverHook(db));
        this.resultHandler = (TableManager)db.makePseudoTable(qA.getProjectionType());
        this.assigner = new ParameterAssigner(db, qA);
        this.limitSyntax = ((org.makumba.db.makumba.sql.Database)db).getLimitSyntax();
        this.offsetFirst = ((org.makumba.db.makumba.sql.Database)db).isLimitOffsetFirst();
        this.supportsLimitInQuery = ((org.makumba.db.makumba.sql.Database)db).supportsLimitInQuery();
        this.insertIn = insertIn;
        if (insertIn != null && insertIn.length() > 0) {
            this.analyzeInsertIn(qA.getProjectionType(), db);
        }
    }

    public Vector execute(Object[] args, DBConnection dbc, int offset, int limit) {
        String com = this.command;
        if (this.supportsLimitInQuery) {
            com = com + " " + this.limitSyntax;
        }
        PreparedStatement ps = ((SQLDBConnection)dbc).getPreparedStatement(com);
        try {
            String s = this.assigner.assignParameters(ps, args);
            if (this.supportsLimitInQuery) {
                int limit1;
                int n = limit1 = limit == -1 ? Integer.MAX_VALUE : limit;
                if (this.offsetFirst) {
                    ps.setInt(this.assigner.tree.parameterNumber() + 1, offset);
                    ps.setInt(this.assigner.tree.parameterNumber() + 2, limit1);
                } else {
                    ps.setInt(this.assigner.tree.parameterNumber() + 1, limit1);
                    ps.setInt(this.assigner.tree.parameterNumber() + 2, offset);
                }
            }
            if (s != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + com + "\n" + s);
            }
            Logger.getLogger("org.makumba.db.query.execution").fine("" + ps);
            Date d = new Date();
            ResultSet rs = null;
            try {
                rs = ps.executeQuery();
            }
            catch (SQLException se) {
                org.makumba.db.makumba.sql.Database.logException(se, dbc);
                throw new DBError(se, com);
            }
            long diff = new Date().getTime() - d.getTime();
            Logger.getLogger("org.makumba.db.query.performance").fine("" + diff + " ms " + com);
            Vector vector = this.goThru(rs, this.resultHandler);
            return vector;
        }
        catch (SQLException e) {
            throw new DBError(e);
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new DBError(e);
            }
        }
    }

    Vector goThru(ResultSet rs, TableManager rm) {
        int size = rm.keyIndex.size();
        Vector<ArrayMap> ret = new Vector<ArrayMap>(100, 100);
        try {
            while (rs.next()) {
                Object[] dt = new Object[size];
                rm.fillResult(rs, dt);
                ret.addElement(new ArrayMap(rm.keyIndex, dt));
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new DBError(e, rm.getDataDefinition().getName());
        }
        return ret;
    }

    void analyzeInsertIn(DataDefinition proj, Database db) {
        DataDefinition insert = DataDefinitionProvider.getInstance().getDataDefinition(this.insertIn);
        for (String string : proj.getFieldNames()) {
            if (insert.getFieldDefinition(string) != null) continue;
            throw new NoSuchFieldException(insert, string);
        }
        this.insertHandler = (TableManager)db.getTable(insert);
    }

    public int insert(Object[] args, DBConnection dbc) {
        String comma = "";
        StringBuffer fieldList = new StringBuffer();
        for (String string : this.resultHandler.getDataDefinition().getFieldNames()) {
            fieldList.append(comma);
            comma = ",";
            fieldList.append(this.insertHandler.getFieldDBName(string));
        }
        String tablename = "temp_" + (int)(Math.random() * 10000.0);
        String com = "INSERT INTO " + tablename + " ( " + fieldList + ") " + this.command;
        try {
            SQLDBConnection sqldbc = (SQLDBConnection)((DBConnectionWrapper)dbc).getWrapped();
            this.resultHandler.create(sqldbc, tablename, true);
            PreparedStatement ps = sqldbc.getPreparedStatement(com);
            String s = this.assigner.assignParameters(ps, args);
            if (s != null) {
                throw new InvalidValueException("Errors while trying to assign arguments to query:\n" + com + "\n" + s);
            }
            int n = ps.executeUpdate();
            ps.close();
            com = "INSERT INTO " + this.insertHandler.getDBName() + " (" + fieldList + ") SELECT " + fieldList + " FROM " + tablename;
            ps = sqldbc.getPreparedStatement(com);
            int m = ps.executeUpdate();
            if (m != n) {
                throw new MakumbaError("inserted in temp " + n + " inserted in final " + m);
            }
            Statement st = sqldbc.createStatement();
            st.execute("DROP TABLE " + tablename);
            st.close();
            ps.close();
            return n;
        }
        catch (SQLException e) {
            throw new DBError(e);
        }
    }
}

