/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.FieldDefinition;
import org.makumba.commons.StringUtils;
import org.makumba.devel.CodeGeneratorTemplate;
import org.makumba.devel.DataServlet;
import org.makumba.providers.DataDefinitionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator {
    public static Hashtable<String, String> nameToTypeMapping = new Hashtable();
    public static final String TYPE_ADDFORM = "Add";
    public static final String TYPE_BUSINESS_LOGICS = "Logic";
    public static final String TYPE_DELETE = "Delete";
    public static final String TYPE_EDITFORM = "Edit";
    public static final String TYPE_LIST = "List";
    public static final String TYPE_NEWFORM = "New";
    public static final String TYPE_OBJECT = "Object";
    static final String[] ALL_PROCESSABLE_TYPES = new String[]{"New", "Object", "Edit", "List", "Delete", "Logic"};
    private static final String[] allCodeTypes;
    private static final List<String> DEFAULTUSED_ACCESS_KEYS;
    public static final String QL_OQL = "OQL";
    public static final String QL_HQL = "HQL";
    public static final String OQL_TLD_DEFINITION = "<%@ taglib uri=\"http://www.makumba.org/presentation\" prefix=\"mak\" %>";
    public static final String HQL_TLD_DEFINITION = "<%@ taglib uri=\"http://www.makumba.org/view-hql\" prefix=\"mak\" %>";
    private Hashtable<DataDefinition, ArrayList<String>> accessKeys = new Hashtable();

    public static FileFilter getFileFilter() {
        return new TemplateFileFilter();
    }

    public static String getFileNameFromObject(DataDefinition dd, String type) {
        if (type == TYPE_OBJECT) {
            type = "View";
        }
        return CodeGenerator.getLabelNameFromDataDefinition(dd) + type + ".jsp";
    }

    public static String getLogicNameFromDataDefinition(DataDefinition dd) {
        return StringUtils.upperCaseBeginning(CodeGenerator.getLabelNameFromDataDefinition(dd)) + TYPE_BUSINESS_LOGICS;
    }

    public static String getLabelNameFromDataDefinition(DataDefinition dd) {
        String objectName = dd.getName();
        if (objectName.indexOf(46) != -1) {
            objectName = objectName.substring(objectName.lastIndexOf(46) + 1);
        }
        return StringUtils.lowerCaseBeginning(objectName);
    }

    public static void main(String[] args) throws IOException {
        DataDefinition dd;
        String object = args[0];
        String path = "";
        if (args.length > 1) {
            path = args[1];
        }
        if (!path.equals("") && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        File outputDir = new File(path);
        outputDir.mkdirs();
        CodeGeneratorTemplate template = new CodeGeneratorTemplate();
        try {
            dd = DataDefinitionProvider.getInstance().getDataDefinition(object);
        }
        catch (Throwable t) {
            throw new DataDefinitionNotFoundError("Could not find such a data defintion");
        }
        for (int i = 0; i < ALL_PROCESSABLE_TYPES.length; ++i) {
            String fileName = path + CodeGenerator.getFileNameFromObject(dd, ALL_PROCESSABLE_TYPES[i]);
            File f = new File(fileName);
            FileWriter fw = new FileWriter(f);
            BufferedWriter out = new BufferedWriter(fw);
            StringBuffer sb = new StringBuffer();
            String action = CodeGenerator.getLabelNameFromDataDefinition(dd) + "View.jsp";
            new CodeGenerator().generateCode(sb, ALL_PROCESSABLE_TYPES[i], dd, action, template, QL_OQL);
            out.write(sb.toString());
            out.close();
        }
    }

    public void generateCode(StringBuffer sb, String type, DataDefinition dd, String action, CodeGeneratorTemplate template, String queryLanguage) {
        this.generateCode(sb, type, dd, action, DataServlet.extractFields(dd, true), template, 0, queryLanguage);
    }

    public void generateJavaBusinessLogicCode(DataDefinition dd, String packageName, boolean hasSuperLogic, String[] types, StringBuffer sb) {
        int indent = 0;
        String directoryName = "";
        String className = directoryName + CodeGenerator.getLogicNameFromDataDefinition(dd);
        String userName = "yourName";
        if (packageName == null) {
            packageName = "";
        }
        String ddMethodName = this.getMethodHandlerName(dd.getName());
        if (!packageName.equals("")) {
            this.appendLine(sb, "package org.eu.best.privatearea;");
            this.appendEmptyLine(sb);
        }
        this.appendLine(sb, "import java.util.Dictionary;");
        this.appendEmptyLine(sb);
        this.appendLine(sb, "import org.makumba.Attributes;");
        this.appendLine(sb, "import org.makumba.Transaction;");
        this.appendLine(sb, "import org.makumba.LogicException;");
        this.appendLine(sb, "import org.makumba.Pointer;");
        this.appendEmptyLine(sb);
        this.appendLine(sb, "/**");
        this.appendLine(sb, " * TODO: add javadoc comments!");
        this.appendLine(sb, " *");
        this.appendLine(sb, " * @author " + userName);
        this.appendLine(sb, " * @version $Id: " + className + ",v 1.1 " + new SimpleDateFormat("yyyy/MM/dd hh:mm:ss").format(new Date()) + " " + userName + " Exp $");
        this.appendLine(sb, " */");
        this.append(sb, "public class " + className);
        if (hasSuperLogic) {
            this.append(sb, " extends Logic");
        }
        this.appendLine(sb, " {");
        this.appendEmptyLine(sb);
        this.appendJavaLine(sb, ++indent, "// add your specific authentication checking by uncommenting & adapting the code below");
        this.appendJavaLine(sb, indent, "public void checkAttributes(Attributes a, Transaction t) throws LogicException {");
        ++indent;
        if (hasSuperLogic) {
            this.appendJavaLine(sb, indent, "super.checkAttributes(a, t);");
            this.appendEmptyLine(sb);
        }
        this.appendJavaLine(sb, indent, "// do authentication checking, e.g. check for existance of an attribute by");
        this.appendJavaLine(sb, indent, "a.getAttribute(\"username\");");
        this.appendEmptyLine(sb);
        this.appendJavaLine(sb, indent, "// then add your specific authorization checking here, e.g. check for being superuser by");
        this.appendJavaLine(sb, indent, "// if (!new Boolean((String) a.getAttribute(\"superUser\")).equals(Boolean.TRUE)) {");
        this.appendJavaLine(sb, ++indent, "// in case of not being authorized add:");
        this.appendJavaLine(sb, indent, "// throw new UnauthorizedException(\"You are not authorized to access this page!\");");
        this.appendJavaLine(sb, --indent, "// }");
        this.appendJavaLine(sb, --indent, "}");
        this.appendEmptyLine(sb);
        this.addOnNewHandler(sb, indent, ddMethodName);
        this.addOnEditHandler(sb, indent, ddMethodName);
        this.addOnDeleteHandler(sb, indent, ddMethodName);
        Vector<FieldDefinition> fields = this.extractSetComplex(dd);
        for (int i = 0; i < fields.size(); ++i) {
            FieldDefinition fd = fields.elementAt(i);
            String handlerName = this.getMethodHandlerName(dd.getName() + "." + fd.getName());
            this.addOnAddHandler(sb, indent, handlerName);
            this.addOnEditHandler(sb, indent, handlerName);
            this.addOnDeleteHandler(sb, indent, handlerName);
        }
        this.appendLine(sb, "}");
    }

    private void addOnAddHandler(StringBuffer sb, int indent, String ddMethodName) {
        this.writeHandler(sb, "add", "Pointer p, Dictionary d, Attributes a, Transaction t", indent, ddMethodName);
    }

    private void addOnDeleteHandler(StringBuffer sb, int indent, String ddMethodName) {
        this.writeHandler(sb, "delete", "Pointer p, Attributes a, Transaction t", indent, ddMethodName);
    }

    private void addOnEditHandler(StringBuffer sb, int indent, String ddMethodName) {
        this.writeHandler(sb, "edit", "Pointer p, Dictionary d, Attributes a, Transaction t", indent, ddMethodName);
    }

    private void addOnNewHandler(StringBuffer sb, int indent, String ddMethodName) {
        this.writeHandler(sb, "new", "Dictionary d, Attributes a, Transaction t", indent, ddMethodName);
    }

    private void writeHandler(StringBuffer sb, String type, String params, int indent, String ddMethodName) {
        this.appendJavaLine(sb, indent, "public void on_" + type + ddMethodName + "(" + params + ") throws LogicException {");
        this.appendJavaLine(sb, ++indent, "");
        this.appendJavaLine(sb, --indent, "}");
        this.appendLine(sb, "");
    }

    private void append(StringBuffer sb, String s) {
        if (s != null && !s.equals("")) {
            sb.append(s);
        }
    }

    private void appendEmptyLine(StringBuffer sb) {
        sb.append("\n");
    }

    private void appendJavaLine(StringBuffer sb, int indent, String s) {
        sb.append(this.getJavaIndentation(indent)).append(s).append("\n");
    }

    private void appendJSP(StringBuffer sb, int indent, String s) {
        sb.append(this.getJSPIndentation(indent)).append(s);
    }

    private void appendJSPLine(StringBuffer sb, int indent, String s) {
        sb.append(this.getJSPIndentation(indent)).append(s).append("\n");
    }

    private void appendLine(StringBuffer sb, String s) {
        if (s != null && !s.equals("")) {
            sb.append(s).append("\n");
        }
    }

    private String formatLabelName(String name, char key) {
        int index = name.toLowerCase().indexOf(key);
        if (index == -1) {
            return StringUtils.upperCaseBeginning(name);
        }
        String s = name.substring(0, index);
        s = s + "<span class=\"accessKey\">" + name.charAt(index) + "</span>";
        s = s + name.substring(index + 1);
        return StringUtils.upperCaseBeginning(s);
    }

    private void generateCode(StringBuffer sb, String type, DataDefinition dd, String action, Vector<FieldDefinition>[] processData, CodeGeneratorTemplate template, int indent, String queryLanguage) {
        long beginTime = System.currentTimeMillis();
        Vector<FieldDefinition> fields = processData[0];
        Vector<FieldDefinition> sets = processData[1];
        String labelName = CodeGenerator.getLabelNameFromDataDefinition(dd);
        action = action + "?" + labelName + "=${" + labelName + "Pointer}";
        try {
            this.appendLine(sb, template.header);
            this.appendLine(sb, "<%-- Makumba Generator - START OF  *** " + type.toUpperCase() + " ***  PAGE FOR OBJECT " + dd + " --%>");
            if (type == TYPE_LIST) {
                this.generateListCode(sb, dd, template, indent, labelName, queryLanguage);
            } else if (type == TYPE_DELETE) {
                this.generateDeleteCode(sb, dd, template, labelName, indent, queryLanguage);
            } else {
                FieldDefinition fd;
                int i;
                ++indent;
                if (type == TYPE_NEWFORM) {
                    this.appendLine(sb, template.beforePageHeader + "New " + StringUtils.upperCaseBeginning(labelName) + template.afterPageHeader);
                    this.appendLine(sb, "<mak:newForm type=\"" + dd + "\" action=\"" + action + "\" name=\"" + labelName + "\" >");
                } else if (type == TYPE_OBJECT) {
                    this.appendLine(sb, "<mak:object from=\"" + dd + " " + labelName + "\" where=\"" + labelName + (queryLanguage.equals(QL_OQL) ? "=$" : ".id=:") + labelName + "\">");
                    this.appendLine(sb, "<mak:value expr=\"" + labelName + (queryLanguage.equals(QL_OQL) ? "" : ".id") + "\" var=\"" + labelName + "Pointer\" />");
                    this.appendJSPLine(sb, indent, template.beforePageHeader + StringUtils.upperCaseBeginning(labelName) + " <i><mak:value expr=\"" + labelName + "." + dd.getTitleFieldName() + "\" /></i>" + template.afterPageHeader);
                } else if (type == TYPE_EDITFORM) {
                    this.appendLine(sb, "<mak:object from=\"" + dd + " " + labelName + "\" where=\"" + labelName + (queryLanguage.equals(QL_OQL) ? "=$" : ".id=:") + labelName + "\">");
                    this.appendLine(sb, "<mak:value expr=\"" + labelName + (queryLanguage.equals(QL_OQL) ? "" : ".id") + "\" var=\"" + labelName + "Pointer\" />");
                    this.appendJSPLine(sb, indent, template.beforePageHeader + "Edit " + StringUtils.upperCaseBeginning(labelName) + " <i><mak:value expr=\"" + labelName + "." + dd.getTitleFieldName() + "\" /></i>" + template.afterPageHeader);
                    this.appendJSPLine(sb, indent, "<mak:editForm object=\"" + labelName + "\" action=\"" + action + "\" method=\"post\">");
                    ++indent;
                }
                this.appendJSPLine(sb, indent, template.afterFormBegin);
                this.appendJSPLine(sb, indent, "<%-- Makumba Generator - START OF NORMAL FIELDS --%>");
                for (i = 0; i < fields.size(); ++i) {
                    fd = fields.get(i);
                    if (fd.isFixed() && fd.isNotNull() && fd.getType().equals("ptr")) continue;
                    this.processFieldDefinition(sb, type, template, labelName, fd, indent);
                }
                if (type == TYPE_OBJECT) {
                    this.appendJSPLine(sb, indent, template.beforeFormEnd);
                } else if (type == TYPE_EDITFORM) {
                    this.writeButtons(template, sb, "Save changes", indent);
                    this.appendJSPLine(sb, indent, template.beforeFormEnd);
                    this.appendJSPLine(sb, --indent, "</mak:editForm>");
                }
                this.appendJSPLine(sb, indent, "<%-- Makumba Generator - END OF NORMAL FIELDS --%>");
                if (type != TYPE_NEWFORM) {
                    this.appendEmptyLine(sb);
                    this.appendJSPLine(sb, indent, "<%-- Makumba Generator - START OF SETS --%>");
                    DataServlet.logger.finer("DEBUG INFO: Number of sets of MDD " + dd + " is " + sets.size());
                    for (i = 0; i < sets.size(); ++i) {
                        fd = sets.get(i);
                        DataServlet.logger.finest("DEBUG INFO: Currently processing set with fieldname " + fd.getName() + " and type " + fd.getType());
                        DataDefinition setDd = this.getDataDefinitionFromType(fd);
                        if (setDd == null) {
                            DataServlet.logger.warning("Problem generating code - did not find field definition for set '" + fd.getName() + "' in data definition '" + dd.getName() + "'.");
                            continue;
                        }
                        Vector<FieldDefinition> innerFields = this.extractInnerFields(setDd);
                        DataServlet.logger.finer("DEBUG INFO: Number of inner fields of MDD " + dd + ", subset " + setDd.getName() + " is " + innerFields.size());
                        this.generateSetCode(sb, type, fd, action, template, innerFields, indent, labelName);
                        if (type != TYPE_EDITFORM) continue;
                        this.generateSetCode(sb, TYPE_ADDFORM, fd, action, template, innerFields, indent, labelName);
                    }
                    this.appendEmptyLine(sb);
                    this.appendJSPLine(sb, indent, "<%-- Makumba Generator - END OF SETS --%>");
                    this.appendEmptyLine(sb);
                    --indent;
                }
                if (type == TYPE_NEWFORM) {
                    this.writeButtons(template, sb, TYPE_ADDFORM, indent);
                    this.appendJSPLine(sb, indent, template.beforeFormEnd);
                    this.appendLine(sb, "</mak:newForm>");
                }
                if (type == TYPE_ADDFORM || type == TYPE_OBJECT) {
                    this.appendJSPLine(sb, indent, template.beforeFormEnd);
                    this.appendLine(sb, "</mak:object>");
                }
                if (type == TYPE_EDITFORM) {
                    this.appendJSPLine(sb, indent, template.beforeFormEnd);
                    this.appendLine(sb, "</mak:object>");
                }
            }
            this.appendEmptyLine(sb);
            this.appendLine(sb, "<%-- Makumba Generator - END OF *** " + type.toUpperCase() + " ***  PAGE FOR OBJECT " + dd + " --%>");
            this.appendLine(sb, template.footer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DataServlet.logger.info("Generation of " + CodeGenerator.getFileNameFromObject(dd, type) + " took " + (System.currentTimeMillis() - beginTime) + " ms");
    }

    private void generateDeleteCode(StringBuffer sb, DataDefinition dd, CodeGeneratorTemplate template, String labelName, int indent, String queryLanguage) {
        this.appendLine(sb, template.beforePageHeader + "Delete confirmation" + template.afterPageHeader);
        this.appendLine(sb, "<mak:object from=\"" + dd + " " + labelName + "\" where=\"" + labelName + (queryLanguage.equals(QL_OQL) ? "=$" : ".id=:") + labelName + "\">");
        this.appendJSPLine(sb, ++indent, "Delete " + labelName + " '<mak:value expr=\"" + labelName + "." + dd.getTitleFieldName() + "\" />'?");
        this.appendJSPLine(sb, indent, "<a href=\"javascript:back();\">No</a> &nbsp;");
        this.appendJSPLine(sb, indent, "<mak:delete object=\"" + labelName + "\" action=\"" + CodeGenerator.getFileNameFromObject(dd, TYPE_LIST) + "\">");
        this.appendJSPLine(sb, indent + 1, TYPE_DELETE);
        this.appendJSPLine(sb, indent, "</mak:delete>");
        --indent;
        this.appendLine(sb, "</mak:object>");
    }

    private void generateInnerFieldFormCode(CodeGeneratorTemplate template, StringBuffer sb, Vector<FieldDefinition> innerFields, int indent) throws IOException {
        for (int i = 0; i < innerFields.size(); ++i) {
            FieldDefinition innerFd = innerFields.get(i);
            this.appendJSPLine(sb, indent, template.beforeField);
            this.writeInput(sb, template, innerFd, indent);
        }
    }

    private void generateListCode(StringBuffer sb, DataDefinition dd, CodeGeneratorTemplate template, int indent, String labelName, String queryLanguage) {
        this.appendJSPLine(sb, indent, template.beforePageHeader + "List " + StringUtils.upperCaseBeginning(labelName) + "s" + template.afterPageHeader);
        String cgiParam = "?" + labelName + "=<mak:value expr=\"" + labelName + (queryLanguage.equals(QL_OQL) ? "" : ".id") + "\" />";
        String thisFile = CodeGenerator.getFileNameFromObject(dd, TYPE_LIST) + "?sortBy=";
        this.appendEmptyLine(sb);
        this.appendLine(sb, "<c:choose>");
        this.appendJSPLine(sb, ++indent, "<c:when test=\"${param.sortBy == 'created'}\">");
        this.appendJSPLine(sb, indent + 1, "<c:set var=\"sortBy\" value=\"" + labelName + ".TS_create\" />");
        this.appendJSPLine(sb, indent, "</c:when>");
        this.appendJSPLine(sb, indent, "<c:when test=\"${param.sortBy == 'modified'}\">");
        this.appendJSPLine(sb, indent + 1, "<c:set var=\"sortBy\" value=\"" + labelName + ".TS_modify\" />");
        this.appendJSPLine(sb, indent, "</c:when>");
        this.appendJSPLine(sb, indent, "<c:when test=\"${!empty param.sortBy}\">");
        this.appendJSPLine(sb, indent + 1, "<c:set var=\"sortBy\" value=\"" + labelName + ".${param.sortBy}\" />");
        this.appendJSPLine(sb, indent, "</c:when>");
        this.appendJSPLine(sb, indent, "<c:otherwise>");
        this.appendJSPLine(sb, indent + 1, "<c:set var=\"sortBy\" value=\"" + labelName + "." + dd.getTitleFieldName() + "\" />");
        this.appendJSPLine(sb, indent, "</c:otherwise>");
        this.appendLine(sb, "</c:choose>");
        this.appendEmptyLine(sb);
        this.appendJSPLine(sb, --indent, template.afterFormBegin);
        this.appendJSPLine(sb, indent, template.beforeField);
        this.appendJSPLine(sb, indent, template.beforeFieldName + "<a href=\"" + thisFile + "created\">#</a>" + template.afterFieldName);
        this.appendJSPLine(sb, indent, template.beforeFieldName + "<a href=\"" + thisFile + dd.getTitleFieldName() + "\">" + dd.getTitleFieldName() + "</a>" + template.afterFieldName);
        this.appendJSPLine(sb, indent, template.beforeFieldName + "<a href=\"" + thisFile + "created\">Created</a>" + template.afterFieldName);
        this.appendJSPLine(sb, indent, template.beforeFieldName + "<a href=\"" + thisFile + "modified\">Modified</a>" + template.afterFieldName);
        this.appendJSPLine(sb, indent, template.beforeFieldName + "Actions" + template.afterFieldName);
        this.appendJSPLine(sb, indent, template.afterField);
        this.appendJSPLine(sb, ++indent, "<mak:list from=\"" + dd + " " + labelName + "\" orderBy=\"" + "#{sortBy}\">");
        this.appendJSPLine(sb, indent, template.beforeField);
        this.appendJSPLine(sb, indent, template.beforeFieldTag + "${mak:count()}" + template.afterFieldTag);
        this.appendJSPLine(sb, indent, template.beforeFieldTag + "<mak:value expr=\"" + labelName + "." + dd.getTitleFieldName() + "\" />" + template.afterFieldTag);
        this.appendJSPLine(sb, indent, template.beforeFieldTag + "<mak:value expr=\"" + labelName + ".TS_create\" format=\"yyyy-MM-dd hh:mm:ss\" />" + template.afterFieldTag);
        this.appendJSPLine(sb, indent, template.beforeFieldTag + "<mak:value expr=\"" + labelName + ".TS_modify\" format=\"yyyy-MM-dd hh:mm:ss\" />" + template.afterFieldTag);
        this.appendJSPLine(sb, indent, template.beforeFieldTag);
        this.append(sb, "<a href=\"" + CodeGenerator.getFileNameFromObject(dd, TYPE_OBJECT) + cgiParam + "\">[View]</a> ");
        this.append(sb, "<a href=\"" + CodeGenerator.getFileNameFromObject(dd, TYPE_EDITFORM) + cgiParam + "\">[Edit]</a> ");
        this.append(sb, "<a href=\"" + CodeGenerator.getFileNameFromObject(dd, TYPE_DELETE) + cgiParam + "\">[Delete]</a> ");
        this.append(sb, template.afterFieldTag);
        this.appendJSPLine(sb, indent, template.afterField);
        this.appendJSPLine(sb, indent, "</mak:list>");
        this.appendJSPLine(sb, --indent, template.beforeFormEnd);
        this.appendLine(sb, "<a href=\"" + CodeGenerator.getFileNameFromObject(dd, TYPE_NEWFORM) + "\">[New]</a>");
    }

    private void generateSetCode(StringBuffer sb, String type, FieldDefinition fd, String action, CodeGeneratorTemplate template, Vector<FieldDefinition> innerFields, int indent, String labelName) throws IOException {
        this.appendEmptyLine(sb);
        if (type == TYPE_ADDFORM) {
            this.appendJSPLine(sb, indent, "<%-- Makumba Generator - START ADDFORM FOR FIELD " + fd.getName() + " --%>");
            this.appendJSPLine(sb, indent, "<mak:addForm object=\"" + labelName + "\" field=\"" + fd.getName() + "\" action=\"" + action + "\" >");
            this.appendJSPLine(sb, ++indent, template.afterFormBegin);
            this.generateInnerFieldFormCode(template, sb, innerFields, indent);
            this.writeButtons(template, sb, TYPE_ADDFORM, indent);
            this.appendJSPLine(sb, indent, template.beforeFormEnd);
            this.appendJSPLine(sb, --indent, "</mak:addForm>");
            this.appendJSPLine(sb, indent, "<%-- Makumba Generator - END ADDFORM FOR FIELD " + fd.getName() + " --%>");
        } else if (type == TYPE_EDITFORM) {
            this.appendJSPLine(sb, indent, "<%-- Makumba Generator - START LIST & EDITFORM FOR FIELD " + fd.getName() + " --%>");
            this.appendJSPLine(sb, indent, template.beforePageHeaderLevel2 + StringUtils.upperCaseBeginning(fd.getName()) + template.afterPageHeaderLevel2);
            this.appendJSPLine(sb, indent, "<mak:list from=\"" + labelName + "." + fd.getName() + " " + fd.getName() + "\" >");
            this.appendJSPLine(sb, ++indent, "<mak:editForm object=\"" + fd.getName() + "\" action=\"" + action + "\" />" + "\" >");
            this.appendJSPLine(sb, ++indent, template.afterFormBegin);
            this.generateInnerFieldFormCode(template, sb, innerFields, indent);
            this.writeButtons(template, sb, "Save changes", indent);
            this.appendJSPLine(sb, indent, template.beforeFormEnd);
            this.appendJSPLine(sb, --indent, "</mak:editForm>");
            this.appendJSPLine(sb, --indent, "</mak:list>");
            this.appendJSPLine(sb, indent, "<%-- Makumba Generator - END LIST & EDITFORM FOR FIELD " + fd.getName() + " --%>");
        } else if (type == TYPE_OBJECT) {
            int i;
            this.appendJSPLine(sb, indent, "<%-- Makumba Generator - START LIST FIELD " + fd.getName() + " --%>");
            this.appendJSPLine(sb, indent, template.beforePageHeaderLevel2 + StringUtils.upperCaseBeginning(fd.getName()) + template.afterPageHeaderLevel2);
            this.appendJSPLine(sb, indent, template.afterFormBegin);
            this.appendJSPLine(sb, indent, template.beforeField);
            for (i = 0; i < innerFields.size(); ++i) {
                FieldDefinition innerFd = innerFields.get(i);
                this.appendJSPLine(sb, indent, template.beforeFieldName + innerFd.getName() + template.afterFieldName);
            }
            this.appendJSPLine(sb, indent, template.afterField);
            this.appendJSPLine(sb, ++indent, "<mak:list from=\"" + labelName + "." + fd.getName() + " " + fd.getName() + "\">");
            this.appendJSPLine(sb, indent, template.beforeField);
            for (i = 0; i < innerFields.size(); ++i) {
                this.appendJSPLine(sb, indent, template.beforeFieldTag + "<mak:value expr=\"" + fd.getName() + "." + innerFields.get(i).getName() + "\"/>" + template.afterFieldTag);
            }
            this.appendJSPLine(sb, indent, template.afterField);
            this.appendJSPLine(sb, indent, "</mak:list>");
            this.appendJSPLine(sb, --indent, template.beforeFormEnd);
            this.appendJSPLine(sb, indent, "<%-- Makumba Generator - END LIST FOR FIELD " + fd.getName() + " --%>");
        }
    }

    private char getAccessKey(DataDefinition dd, String fieldName) {
        ArrayList<String> usedKeys = this.accessKeys.get(dd);
        if (usedKeys == null) {
            usedKeys = new ArrayList<String>(DEFAULTUSED_ACCESS_KEYS);
            this.accessKeys.put(dd, usedKeys);
        }
        fieldName = fieldName.toLowerCase();
        for (int i = 0; i < fieldName.length(); ++i) {
            char key = fieldName.charAt(i);
            if (key == ' ' || usedKeys.contains(String.valueOf(key))) continue;
            usedKeys.add(String.valueOf(key));
            return key;
        }
        return ' ';
    }

    private StringBuffer getJavaIndentation(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("    ");
        }
        return sb;
    }

    private StringBuffer getJSPIndentation(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        return sb;
    }

    private String getMethodHandlerName(String ddName) {
        String methodName = "";
        StringTokenizer st = new StringTokenizer(ddName, ".");
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            methodName = methodName + StringUtils.upperCaseBeginning(s);
        }
        return methodName;
    }

    private void processFieldDefinition(StringBuffer sb, String type, CodeGeneratorTemplate template, String labelName, FieldDefinition fd, int indent) throws IOException {
        this.appendJSPLine(sb, indent, template.beforeField);
        if (type == TYPE_NEWFORM || type == TYPE_EDITFORM) {
            this.writeInput(sb, template, fd, indent);
        } else if (type == TYPE_OBJECT) {
            this.appendJSPLine(sb, indent, template.beforeFieldName + fd.getName() + template.afterFieldName);
            this.appendJSP(sb, indent, template.beforeFieldTag);
            this.append(sb, "<mak:value expr=\"" + labelName + "." + fd.getName() + "\"/>");
        }
        this.appendLine(sb, template.afterFieldTag);
        this.appendJSPLine(sb, indent, template.afterField);
    }

    private void writeButtons(CodeGeneratorTemplate template, StringBuffer sb, String buttonText, int indent) {
        this.appendJSPLine(sb, indent, template.beforeField);
        this.appendJSP(sb, indent, template.beforeFieldTag);
        this.writeSubmitButton(template, sb, buttonText, indent);
        this.writeResetButton(template, sb, indent);
        this.writeCancelButton(template, sb, indent);
        this.appendJSPLine(sb, indent, template.afterFieldTag);
        this.appendJSPLine(sb, indent, template.afterField);
    }

    private void writeCancelButton(CodeGeneratorTemplate template, StringBuffer sb, int indent) {
        this.appendJSP(sb, indent, "<input type=\"reset\" value=\"Cancel\" accessKey=\"C\" onClick=\"javascript:back();\">");
    }

    private void writeResetButton(CodeGeneratorTemplate template, StringBuffer sb, int indent) {
        this.appendJSP(sb, indent, "<input type=\"reset\" accessKey=\"R\">");
    }

    private void writeSubmitButton(CodeGeneratorTemplate template, StringBuffer sb, String buttonText, int indent) {
        this.appendJSP(sb, indent, "<input type=\"submit\" value=\"" + buttonText + "\" accessKey=\"" + buttonText.charAt(0) + "\">");
    }

    private void writeInput(StringBuffer sb, CodeGeneratorTemplate template, FieldDefinition fd, int indent) {
        String fieldName = fd.getDescription() != null && !fd.getDescription().equals("") ? fd.getDescription() : fd.getName();
        fieldName = fieldName.trim();
        char key = this.getAccessKey(fd.getDataDefinition(), fieldName);
        this.appendJSPLine(sb, indent, template.beforeFieldName + "<label for=\"" + fd.getName() + "\">" + this.formatLabelName(fieldName, key) + "</label>" + template.afterFieldName);
        this.appendJSP(sb, indent, template.beforeFieldTag);
        this.append(sb, "<mak:input field=\"" + fd.getName() + "\" styleId=\"" + fd.getName() + "\" accessKey=\"" + key + "\" />");
    }

    private Vector<FieldDefinition> extractInnerFields(DataDefinition dd) {
        Vector<FieldDefinition> innerFields = new Vector<FieldDefinition>();
        if (dd != null && dd.getFieldNames() != null) {
            for (int i = 0; i < dd.getFieldNames().size(); ++i) {
                FieldDefinition fd = dd.getFieldDefinition(i);
                if (fd.isDefaultField() || fd.getIntegerType() == 1 || !fd.shouldEditBySingleInput()) continue;
                innerFields.add(fd);
            }
        }
        return innerFields;
    }

    private Vector<FieldDefinition> extractSetComplex(DataDefinition dd) {
        Vector<FieldDefinition> sets = new Vector<FieldDefinition>();
        for (int i = 0; i < dd.getFieldNames().size(); ++i) {
            FieldDefinition fd = dd.getFieldDefinition(i);
            if (fd.getIntegerType() != 13) continue;
            sets.add(fd);
        }
        return sets;
    }

    private DataDefinition getDataDefinitionFromType(FieldDefinition fd) {
        if (fd.isInternalSet()) {
            return fd.getSubtable();
        }
        if (fd.isExternalSet()) {
            return fd.getDataDefinition();
        }
        if (fd.isPointer()) {
            return fd.getForeignTable();
        }
        return null;
    }

    static {
        DEFAULTUSED_ACCESS_KEYS = Arrays.asList("a", "s", "c", "r");
        allCodeTypes = new String[]{TYPE_NEWFORM, TYPE_ADDFORM, TYPE_EDITFORM, TYPE_LIST, TYPE_OBJECT, TYPE_DELETE, TYPE_BUSINESS_LOGICS};
        for (int i = 0; i < allCodeTypes.length; ++i) {
            nameToTypeMapping.put(allCodeTypes[i], allCodeTypes[i]);
        }
    }

    private static class TemplateFileFilter
    implements FileFilter {
        private TemplateFileFilter() {
        }

        public boolean accept(File fileName) {
            return fileName.canRead() && fileName.isFile() && fileName.getName().endsWith(".properties");
        }
    }
}

