/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel.relations;

import antlr.RecognitionException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.makumba.DataDefinition;
import org.makumba.MakumbaError;
import org.makumba.analyser.engine.JavaParseData;
import org.makumba.devel.JavaSourceAnalyzer;
import org.makumba.devel.relations.JavaMDDParser;
import org.makumba.devel.relations.RelationCrawler;
import org.makumba.devel.relations.RelationMiner;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.query.oql.OQLQueryAnalysisProvider;

public class JavaRelationMiner
extends RelationMiner {
    private Vector<String> webappJavaPackages = new Vector();

    public JavaRelationMiner(RelationCrawler rc) {
        super(rc);
    }

    public void crawl(String path) {
        if (!new File(this.rc.getWebappRoot() + File.separator + path).exists()) {
            this.logger.warning("Java file " + path + " does not exist in webapp " + this.rc.getWebappRoot());
            return;
        }
        this.computeJava2JavaRelations(path);
        this.computeJava2MDDRelations(path);
    }

    private void computeJava2MDDRelations(String path) {
        JavaMDDParser jqp = new JavaMDDParser(this.rc.getWebappRoot() + File.separator + path);
        Vector<String> queries = jqp.getQueries();
        for (String query : queries) {
            String s;
            QueryAnalysis qA = null;
            try {
                qA = OQLQueryAnalysisProvider.parseQueryFundamental(query);
            }
            catch (RecognitionException e) {
                s = "Could not parse query " + query + " from file " + path + ": " + e.getMessage();
                this.logger.warning(s);
                this.rc.addJavaAnalysisError(s);
                continue;
            }
            catch (MakumbaError me) {
                s = "Could not parse query " + query + " from file " + path + ": " + me.getMessage();
                this.logger.warning(s);
                continue;
            }
            Dictionary<String, String> projections = qA.getProjections();
            Enumeration<String> e = projections.elements();
            while (e.hasMoreElements()) {
                String type;
                String expr = e.nextElement();
                String field = qA.getFieldOfExpr(expr);
                DataDefinition dd = qA.getTypeOfExprField(expr);
                if (dd == null) {
                    int n = -1;
                    n = expr.indexOf("(");
                    if (n > -1) {
                        String realExpr = expr.substring(n + 1, expr.length() - 1);
                        if (realExpr.equals("*")) continue;
                        field = qA.getFieldOfExpr(realExpr);
                        dd = qA.getTypeOfExprField(realExpr);
                    }
                }
                if ((type = dd.getName()).indexOf("->") > -1) {
                    field = type.substring(type.indexOf("->") + 2) + "." + field;
                    type = type.substring(0, type.indexOf("->"));
                }
                this.addJava2MDDRelation(path, type, expr, field, query);
            }
            Map<String, DataDefinition> labelTypes = qA.getLabelTypes();
            for (String labelName : labelTypes.keySet()) {
                String field;
                String type = labelTypes.get(labelName).getName();
                String string = field = type.indexOf("->") > -1 ? type.substring(type.indexOf("->") + 2) : type.substring(type.lastIndexOf(".") + 1);
                if (type.indexOf("->") > -1) {
                    type = type.substring(0, type.indexOf("->"));
                }
                this.addJava2MDDRelation(path, type, labelName, field, query);
            }
        }
    }

    private void computeJava2JavaRelations(String path) {
        JavaParseData jpd = JavaParseData.getParseData(this.rc.getWebappRoot(), path, JavaSourceAnalyzer.getInstance());
        jpd.getAnalysisResult(null);
        if (this.webappJavaPackages == null) {
            this.readMakumbaControllerPackages();
        }
        Hashtable<String, String> importedClasses = jpd.getImportedClasses();
        for (String key : importedClasses.keySet()) {
            String className = importedClasses.get(key);
            boolean isWebappJava = false;
            Iterator<String> packages = this.webappJavaPackages.iterator();
            while (packages.hasNext() && !isWebappJava) {
                isWebappJava = className.startsWith(packages.next());
            }
            if (!isWebappJava) continue;
            this.addJava2JavaRelation(path, className, "import");
        }
    }

    private void readMakumbaControllerPackages() {
        String makumbaControllerPath = this.rc.getWebappRoot() + File.separator + "/WEB-INF/classes/MakumbaController.properties";
        Properties p = null;
        try {
            p.load(new FileInputStream(makumbaControllerPath));
        }
        catch (Exception e) {
            this.logger.severe("Could not read " + makumbaControllerPath + ", hence relations in Java files won't be correctly analysed.");
            return;
        }
        for (String string : p.keySet()) {
            String packageName = p.getProperty(string);
            if (packageName == null || packageName.length() <= 0) continue;
            this.webappJavaPackages.add(packageName);
        }
    }

    private void addJava2JavaRelation(String fromFile, String className, String reason) {
        String toFile = "/WEB-INF/classes/" + className.replace(".", File.separator);
        Hashtable<String, Object> relationOrigin = new Hashtable<String, Object>();
        ((Dictionary)relationOrigin).put("reason", reason);
        this.rc.addRelation(fromFile, toFile, relationOrigin);
    }

    private void addJava2MDDRelation(String fromFile, String type, String expr, String field, String query) {
        String toFile = "/WEB-INF/classes/dataDefinitions/" + type.replace(".", "/") + ".mdd";
        Hashtable<String, Object> relationOrigin = new Hashtable<String, Object>();
        ((Dictionary)relationOrigin).put("expr", expr);
        ((Dictionary)relationOrigin).put("field", field);
        ((Dictionary)relationOrigin).put("reason", query);
        this.rc.addRelation(fromFile, toFile, relationOrigin);
    }
}

