/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityDeleteAction
extends EntityAction {
    private final Object version;
    private CacheConcurrencyStrategy.SoftLock lock;
    private final boolean isCascadeDeleteEnabled;
    private final Object[] state;

    public EntityDeleteAction(Serializable id, Object[] state, Object version, Object instance, EntityPersister persister, boolean isCascadeDeleteEnabled, SessionImplementor session) {
        super(session, id, instance, persister);
        this.version = version;
        this.isCascadeDeleteEnabled = isCascadeDeleteEnabled;
        this.state = state;
    }

    public void execute() throws HibernateException {
        PersistenceContext persistenceContext;
        EntityEntry entry;
        CacheKey ck;
        Serializable id = this.getId();
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean stats = session.getFactory().getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.currentTimeMillis();
        }
        boolean veto = this.preDelete();
        Object version = this.version;
        if (persister.isVersionPropertyGenerated()) {
            version = persister.getVersion(instance, session.getEntityMode());
        }
        if (persister.hasCache()) {
            ck = new CacheKey(id, persister.getIdentifierType(), persister.getRootEntityName(), session.getEntityMode(), session.getFactory());
            this.lock = persister.getCache().lock(ck, version);
        } else {
            ck = null;
        }
        if (!this.isCascadeDeleteEnabled && !veto) {
            persister.delete(id, version, instance, session);
        }
        if ((entry = (persistenceContext = session.getPersistenceContext()).removeEntry(instance)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entry.postDelete();
        EntityKey key = new EntityKey(entry.getId(), entry.getPersister(), session.getEntityMode());
        persistenceContext.removeEntity(key);
        persistenceContext.removeProxy(key);
        if (persister.hasCache()) {
            persister.getCache().evict(ck);
        }
        this.postDelete();
        if (stats && !veto) {
            this.getSession().getFactory().getStatisticsImplementor().deleteEntity(this.getPersister().getEntityName(), System.currentTimeMillis() - startTime);
        }
    }

    private boolean preDelete() {
        PreDeleteEventListener[] preListeners = this.getSession().getListeners().getPreDeleteEventListeners();
        boolean veto = false;
        if (preListeners.length > 0) {
            PreDeleteEvent preEvent = new PreDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister());
            for (int i = 0; i < preListeners.length; ++i) {
                veto = preListeners[i].onPreDelete(preEvent) || veto;
            }
        }
        return veto;
    }

    private void postDelete() {
        PostDeleteEventListener[] postListeners = this.getSession().getListeners().getPostDeleteEventListeners();
        if (postListeners.length > 0) {
            PostDeleteEvent postEvent = new PostDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostDelete(postEvent);
            }
        }
    }

    private void postCommitDelete() {
        PostDeleteEventListener[] postListeners = this.getSession().getListeners().getPostCommitDeleteEventListeners();
        if (postListeners.length > 0) {
            PostDeleteEvent postEvent = new PostDeleteEvent(this.getInstance(), this.getId(), this.state, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostDelete(postEvent);
            }
        }
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        if (this.getPersister().hasCache()) {
            CacheKey ck = new CacheKey(this.getId(), this.getPersister().getIdentifierType(), this.getPersister().getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
            this.getPersister().getCache().release(ck, this.lock);
        }
        this.postCommitDelete();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitDeleteEventListeners().length > 0;
    }
}

