/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.Tidy;
import org.w3c.tidy.TidyMessage;
import org.w3c.tidy.TidyMessageListener;
import org.w3c.tidy.servlet.RepositoryFactory;
import org.w3c.tidy.servlet.ResponseRecord;
import org.w3c.tidy.servlet.ResponseRecordRepository;
import org.w3c.tidy.servlet.jsp.tagext.ValidationImageTag;
import org.w3c.tidy.servlet.properties.JTidyServletProperties;

public class TidyProcessor {
    HttpSession httpSession;
    HttpServletRequest request;
    HttpServletResponse response;
    private String config;
    private boolean validateOnly;
    private boolean doubleValidation;
    private boolean commentsSubst;
    private Log log = LogFactory.getLog((Class)(class$org$w3c$tidy$servlet$TidyProcessor == null ? (class$org$w3c$tidy$servlet$TidyProcessor = TidyProcessor.class$("org.w3c.tidy.servlet.TidyProcessor")) : class$org$w3c$tidy$servlet$TidyProcessor));
    static /* synthetic */ Class class$org$w3c$tidy$servlet$TidyProcessor;

    public TidyProcessor(HttpSession httpSession, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.httpSession = httpSession;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    private void parsConfig(Configuration configuration) {
        if (this.config == null) {
            return;
        }
        Properties properties = new Properties();
        StringTokenizer st = new StringTokenizer(this.config, ";");
        while (st.hasMoreTokens()) {
            String nv = st.nextToken();
            int split = nv.indexOf(58);
            if (split <= 0) continue;
            String n = nv.substring(0, split).trim();
            String v = nv.substring(split + 1).trim();
            if (Configuration.isKnownOption((String)n)) {
                properties.put(n, v);
                this.log.debug((Object)("add option " + n + "=" + v));
                continue;
            }
            this.log.warn((Object)("TidyTag unknown option " + n));
        }
        configuration.addProps(properties);
        configuration.adjust();
    }

    public boolean parse(InputStream in, OutputStream out, String html) {
        if (this.request.getAttribute("JTidyIgnore") != null) {
            this.log.debug((Object)"IGNORE");
            return false;
        }
        RepositoryFactory factory = JTidyServletProperties.getInstance().getRepositoryFactoryInstance();
        Object requestID = factory.getResponseID(this.httpSession, this.request, this.response, false);
        if (requestID == null) {
            this.log.debug((Object)"IGNORE requestID == null");
            return false;
        }
        boolean secondPass = false;
        if (this.request.getAttribute("JTidyProcessed") != null) {
            if (!this.doubleValidation) {
                this.log.debug((Object)"IGNORE !doubleValidation");
                return false;
            }
            requestID = factory.getResponseID(this.httpSession, this.request, this.response, true);
            secondPass = true;
        }
        if (!secondPass) {
            this.log.debug((Object)"addCookie");
            this.response.addCookie(new Cookie("JTidyRequestID", requestID.toString()));
        }
        boolean rc = this.parse(in, out, html, requestID, factory);
        if (!secondPass) {
            this.request.setAttribute("JTidyProcessed", requestID);
        }
        if (rc && !this.validateOnly && this.request.getAttribute("JTidyPass") != null) {
            rc = false;
        }
        return rc;
    }

    public boolean parse(InputStream in, OutputStream out, String html, Object requestID, RepositoryFactory factory) {
        long start = System.currentTimeMillis();
        Tidy tidy = new Tidy();
        this.parsConfig(tidy.getConfiguration());
        tidy.setSmartIndent(true);
        tidy.setQuiet(true);
        ByteArrayOutputStream mesageBuffer = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(mesageBuffer);
        tidy.setErrout(pw);
        boolean useOut = false;
        ResponseRecord result = factory.createRecord(requestID, this.httpSession, this.request, this.response);
        result.setRequestID(requestID);
        tidy.setMessageListener((TidyMessageListener)result);
        boolean fatalError = false;
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        try {
            this.log.debug((Object)("processing request " + requestID + "..."));
            tidy.parse(in, (OutputStream)outBuffer);
            boolean bl = useOut = result.getParseErrors() == 0;
            if (this.commentsSubst) {
                this.doCommentsSubst(outBuffer, requestID);
            }
            if (out != null) {
                outBuffer.writeTo(out);
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"JTidy parsing error", e);
            result.messageReceived(new TidyMessage(0, 0, 0, TidyMessage.Level.ERROR, "JTidy parsing error" + e.getMessage()));
            fatalError = true;
        }
        result.setHtmlInput(html);
        if (result.getParseErrors() > 0 || fatalError) {
            result.setHtmlOutput(html);
        } else {
            result.setHtmlOutput(outBuffer.toString());
        }
        if (!fatalError) {
            // empty if block
        }
        long time = System.currentTimeMillis() - start;
        result.setParsTime(time);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processed in " + time + " millis"));
        }
        ResponseRecordRepository repository = factory.getRepositoryInstance(this.httpSession);
        repository.addRecord(result);
        String shortMessage = result.getParseErrors() != 0 || result.getParseWarnings() != 0 ? (result.getParseErrors() == 0 ? "found " + result.getParseWarnings() + " warnings in generated HTML" : "found " + result.getParseErrors() + " errors and " + result.getParseWarnings() + " warnings in generated HTML") : "no problems found";
        this.log.info((Object)(shortMessage + " request " + requestID));
        return useOut && out != null;
    }

    private void doCommentsSubst(ByteArrayOutputStream outBuffer, Object requestID) {
        this.log.debug((Object)"doCommentsSubst");
        if (this.response != null) {
            this.response.setHeader("Pragma", "No-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            this.response.setDateHeader("Expires", -1L);
        }
        String html = outBuffer.toString();
        html = this.replaceAll(html, "<!--jtidy:requestID-->", requestID.toString());
        String aLink = ValidationImageTag.getImageHTML(requestID.toString(), null, null, this.request);
        html = this.replaceAll(html, "<!--jtidy:validationImage-->", aLink);
        outBuffer.reset();
        try {
            outBuffer.write(html.getBytes());
        }
        catch (IOException e) {
            this.log.error((Object)"Internal error", (Throwable)e);
        }
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public boolean isDoubleValidation() {
        return this.doubleValidation;
    }

    public void setDoubleValidation(boolean doubleValidation) {
        this.doubleValidation = doubleValidation;
    }

    public void setValidateOnly(boolean validateOnly) {
        this.validateOnly = validateOnly;
    }

    public void setCommentsSubst(boolean commentsSubst) {
        this.commentsSubst = commentsSubst;
    }

    public String replaceAll(String str, String replace, String replacement) {
        StringBuffer sb = new StringBuffer(str);
        int firstOccurrence = str.indexOf(replace);
        while (firstOccurrence != -1) {
            sb.replace(firstOccurrence, firstOccurrence + replace.length(), replacement);
            firstOccurrence = sb.toString().indexOf(replace);
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

