/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.text.ParseException;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Checkout
extends SvnCommand {
    private SVNUrl url = null;
    private boolean recurse = true;
    private File destPath = null;
    private SVNRevision revision = SVNRevision.HEAD;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.validateAttributes();
        this.log("Svn : Checking out a working copy from a repository :");
        try {
            iSVNClientAdapter.checkout(this.url, this.destPath, this.revision, this.recurse);
        }
        catch (Exception exception) {
            throw new BuildException("Can't checkout", (Throwable)exception);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.destPath == null) {
            this.destPath = this.getProject().getBaseDir();
        }
        if (this.url == null) {
            throw new BuildException("url must be set");
        }
        if (this.revision == null) {
            throw new BuildException("Invalid revision. Revision should be a number, a date in MM/DD/YYYY HH:MM AM_PM format or HEAD, BASE, COMMITED or PREV");
        }
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setDestpath(File file) {
        this.destPath = file;
    }

    public void setRevision(String string) {
        try {
            this.revision = SVNRevision.getRevision((String)string);
        }
        catch (ParseException parseException) {
            this.revision = null;
        }
    }
}

