/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.devel.relations;

import antlr.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.analyser.PageCache;
import org.makumba.analyser.TagData;
import org.makumba.analyser.engine.JspParseData;
import org.makumba.commons.MakumbaJspAnalyzer;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.devel.relations.JspRelationsAnalyzer;
import org.makumba.devel.relations.RelationCrawler;
import org.makumba.devel.relations.RelationMiner;
import org.makumba.devel.relations.RelationParseStatus;
import org.makumba.forms.tags.InputTag;
import org.makumba.forms.tags.NewTag;
import org.makumba.forms.tags.SearchFieldTag;
import org.makumba.list.engine.ComposedQuery;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.query.hql.HQLQueryAnalysisProvider;
import org.makumba.providers.query.oql.OQLQueryAnalysisProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPRelationMiner
extends RelationMiner {
    private Pattern expression = Pattern.compile("[a-zA-Z]\\w*(?:\\.\\w+)?");

    public JSPRelationMiner(RelationCrawler rc) {
        super(rc);
    }

    @Override
    public void crawl(String path) {
        Map<Object, Object> tagDataCache;
        JspParseData jpd = JspParseData.getParseData(this.rc.getWebappRoot(), path, JspRelationsAnalyzer.getInstance());
        PageCache pageCache = null;
        try {
            pageCache = (PageCache)jpd.getAnalysisResult(new RelationParseStatus());
        }
        catch (Throwable t) {
            this.logger.warning("Page analysis for page " + path + " failed due to error: " + t.getMessage());
            this.rc.addJSPAnalysisError(path, t);
            return;
        }
        Map<Object, Object> queryCache = pageCache.retrieveCache("org.makumba.query");
        if (queryCache != null) {
            for (Object queryKey : queryCache.keySet()) {
                Object query = queryCache.get(queryKey);
                if (!(query instanceof ComposedQuery)) continue;
                ComposedQuery cq = (ComposedQuery)query;
                this.computeJSPMDDProjectionRelations(path, pageCache, queryKey, cq);
                try {
                    this.computeJSPMDDLabelRelations(path, pageCache, queryKey, cq);
                }
                catch (RuntimeException e) {
                    System.out.println("Could not compute JSP<->MDD label relation for " + path + ": " + e.getMessage());
                }
            }
        }
        if ((tagDataCache = pageCache.retrieveCache("org.makumba.tagData")) != null) {
            for (Object tagKey : tagDataCache.keySet()) {
                TagData tagData = (TagData)tagDataCache.get(tagKey);
                this.computeJSPMDDFormRelations(path, pageCache, tagDataCache, tagKey, tagData);
                this.computeJSPJSPRelations(tagData, path);
            }
        }
    }

    private void computeJSPJSPRelations(TagData tagData, String currentPage) {
        String toPage;
        if (tagData.name.equals("jsp:include")) {
            toPage = tagData.attributes.get("page");
            toPage = this.transformIncludePath(toPage, currentPage);
            this.addJSP2JSPRelation(currentPage, toPage, tagData);
        }
        if (tagData.name.equals("include")) {
            toPage = tagData.attributes.get("file");
            toPage = this.transformIncludePath(toPage, currentPage);
            this.addJSP2JSPRelation(currentPage, toPage, tagData);
        }
    }

    private void computeJSPMDDFormRelations(String fromFile, PageCache pageCache, Map<Object, Object> tagDataCache, Object tagKey, TagData tagData) {
        Object tag = tagData.getTagObject();
        if (tag != null) {
            if (tag instanceof NewTag) {
                String baseObjectType = tagData.attributes.get("type");
                String field = baseObjectType.substring(baseObjectType.lastIndexOf(".") + 1);
                this.addJSP2MDDRelation(fromFile, baseObjectType, tagData, baseObjectType, field);
            }
            if (tag instanceof InputTag && !(tag instanceof SearchFieldTag)) {
                String expr;
                MultipleKey formTagKey = ((InputTag)((Object)tag)).getForm().getTagKey();
                String baseObjectType = (String)pageCache.retrieve("org.makumba.basePointerTypes", formTagKey);
                if (baseObjectType == null) {
                    baseObjectType = ((TagData)tagDataCache.get((Object)formTagKey)).attributes.get("type");
                }
                if (baseObjectType == null) {
                    return;
                }
                FieldDefinition tagFieldType = (FieldDefinition)pageCache.retrieve("org.makumba.inputtypes", tagKey);
                String string = expr = tagData.attributes.get("field") == null ? tagData.attributes.get("name") : tagData.attributes.get("field");
                if (expr.indexOf(".") > -1) {
                    String typeDeterminationQuery = "SELECT typeLabel." + expr.substring(0, expr.lastIndexOf(".")) + " AS type FROM " + baseObjectType + " typeLabel";
                    QueryAnalysis qA = null;
                    String ql = MakumbaJspAnalyzer.getQueryLanguage(pageCache);
                    if (ql.equals("oql")) {
                        try {
                            qA = OQLQueryAnalysisProvider.parseQueryFundamental(typeDeterminationQuery);
                        }
                        catch (RecognitionException e) {
                            this.logger.warning("Could not determine type using query " + typeDeterminationQuery + " in file " + fromFile);
                            return;
                        }
                    }
                    if (ql.equals("hql")) {
                        try {
                            qA = HQLQueryAnalysisProvider.getHqlAnalyzer(typeDeterminationQuery);
                        }
                        catch (RuntimeWrappedException e) {
                            this.logger.warning("Could not determine type using query " + typeDeterminationQuery + " in file " + fromFile);
                            return;
                        }
                    }
                    baseObjectType = qA.getProjectionType().getFieldDefinition("type").getPointedType().getName();
                    if (baseObjectType != null) {
                        this.addJSP2MDDRelation(fromFile, baseObjectType, tagData, expr, tagFieldType.getName());
                    }
                }
            }
        }
    }

    private String transformIncludePath(String toPage, String currentPage) {
        if (!toPage.startsWith("/")) {
            toPage = new File(currentPage).getParent() + File.separator + toPage;
        }
        if (toPage.indexOf("?") > -1) {
            toPage = toPage.substring(0, toPage.indexOf("?"));
        }
        if (toPage.indexOf("#") > -1) {
            toPage = toPage.substring(0, toPage.indexOf("#"));
        }
        try {
            toPage = new File(this.rc.getWebappRoot() + toPage).getCanonicalPath();
            toPage = toPage.substring(this.rc.getWebappRoot().length());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toPage;
    }

    private void computeJSPMDDLabelRelations(String fromFile, PageCache pageCache, Object queryKey, ComposedQuery cq) {
        Map<String, DataDefinition> labelTypes = cq.getFromLabelTypes();
        Set<String> labels = labelTypes.keySet();
        for (String labelName : labels) {
            String field;
            TagData td = (TagData)pageCache.retrieve("org.makumba.tagData", (MultipleKey)queryKey);
            if (td == null) continue;
            String type = cq.getFromLabelTypes().get(labelName).getName();
            String string = field = type.indexOf("->") > -1 ? type.substring(type.indexOf("->") + 2) : type.substring(type.lastIndexOf(".") + 1);
            if (type.indexOf("->") > -1) {
                type = type.substring(0, type.indexOf("->"));
            }
            this.addJSP2MDDRelation(fromFile, type, td, labelName, field);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computeJSPMDDProjectionRelations(String fromFile, PageCache pageCache, Object queryKey, ComposedQuery cq) {
        Vector<Object> projections = cq.getProjections();
        for (String string : projections) {
            void var7_7;
            MultipleKey valueTagKey = (MultipleKey)pageCache.retrieve("org.makumba.projectionOrigin", new MultipleKey((Vector)((MultipleKey)queryKey), string));
            if (valueTagKey == null) continue;
            TagData td = (TagData)pageCache.retrieve("org.makumba.tagData", valueTagKey);
            String field = cq.getFieldOfExpr(string);
            String realExpr = null;
            DataDefinition projectionParentType = null;
            try {
                projectionParentType = cq.getTypeOfExprField(string);
            }
            catch (RuntimeWrappedException e) {
                this.rc.addJSPAnalysisError(fromFile, e.getCause() == null ? e : e.getCause());
            }
            catch (RuntimeException e1) {
                this.rc.addJSPAnalysisError(fromFile, e1.getCause() == null ? e1 : e1.getCause());
            }
            if (projectionParentType == null) {
                int n = -1;
                n = string.indexOf("(");
                if (n > -1) {
                    realExpr = string.substring(n + 1, string.length() - 1);
                    if (realExpr.equals("*")) continue;
                    field = cq.getFieldOfExpr(realExpr);
                    projectionParentType = cq.getTypeOfExprField(realExpr);
                } else {
                    String string2 = this.getAnalysableExpression(string);
                    try {
                        projectionParentType = cq.getTypeOfExprField(string2);
                    }
                    catch (RuntimeWrappedException e) {
                        this.rc.addJSPAnalysisError(fromFile, e.getCause() == null ? e : e.getCause());
                    }
                    catch (RuntimeException e1) {
                        this.rc.addJSPAnalysisError(fromFile, e1.getCause() == null ? e1 : e1.getCause());
                    }
                }
            }
            if (projectionParentType == null) {
                this.logger.warning("Error while crawling file " + fromFile + ": could not figure out type of the parent of field pointed by expression " + (String)var7_7);
                continue;
            }
            String type = projectionParentType.getName();
            if (field.equals(realExpr == null ? var7_7 : realExpr) && type.indexOf("->") == -1) {
                field = type.substring(type.lastIndexOf(".") + 1);
            }
            if (type.indexOf("->") > -1) {
                field = type.substring(type.indexOf("->") + 2) + "." + field;
                type = type.substring(0, type.indexOf("->"));
            }
            this.addJSP2MDDRelation(fromFile, type, td, (String)var7_7, field);
        }
    }

    private String getAnalysableExpression(String expr) {
        Matcher m = this.expression.matcher(expr);
        String match = "";
        while (m.find()) {
            match = expr.substring(m.start(), m.end());
        }
        return match;
    }

    private void addJSP2MDDRelation(String fromFile, String type, TagData originTagData, String expr, String field) {
        String toFile = "/WEB-INF/classes/dataDefinitions/" + type.replace(".", "/") + ".mdd";
        Hashtable<String, Object> relationOrigin = new Hashtable<String, Object>();
        ((Dictionary)relationOrigin).put("startcol", originTagData.getStartColumn());
        ((Dictionary)relationOrigin).put("endcol", originTagData.getEndColumn());
        ((Dictionary)relationOrigin).put("startline", originTagData.getStartLine());
        ((Dictionary)relationOrigin).put("endline", originTagData.getEndLine());
        ((Dictionary)relationOrigin).put("tagname", originTagData.name);
        ((Dictionary)relationOrigin).put("expr", expr);
        ((Dictionary)relationOrigin).put("field", field);
        this.rc.addRelation(fromFile, toFile, "jsp2mdd", relationOrigin);
    }

    private void addJSP2JSPRelation(String fromFile, String toFile, TagData originTagData) {
        Hashtable<String, Object> relationOrigin = new Hashtable<String, Object>();
        ((Dictionary)relationOrigin).put("startcol", originTagData.getStartColumn());
        ((Dictionary)relationOrigin).put("endcol", originTagData.getEndColumn());
        ((Dictionary)relationOrigin).put("startline", originTagData.getStartLine());
        ((Dictionary)relationOrigin).put("endline", originTagData.getEndLine());
        ((Dictionary)relationOrigin).put("tagname", originTagData.name);
        this.rc.addRelation(fromFile, toFile, "jsp2jsp", relationOrigin);
    }
}

