/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Vector;
import org.makumba.HtmlChoiceWriter;
import org.makumba.ProgrammerError;
import org.makumba.ValidationRule;
import org.makumba.commons.StringUtils;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.InvalidValueException;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.forms.html.FieldEditor;
import org.makumba.forms.html.charEditor;
import org.makumba.providers.datadefinition.makumba.validation.NumberRangeValidationRule;

public class intEditor
extends charEditor {
    static String[] __params = new String[]{"default", "empty", "size", "maxlength", "type", "stepSize"};
    static String[][] __paramValues = new String[][]{null, null, null, null, {"spinner", "select", "radio"}, null};

    protected intEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String[] getAcceptedParams() {
        return __params;
    }

    public String[][] getAcceptedValue() {
        return __paramValues;
    }

    public int getWidth(RecordFormatter rf, int fieldIndex) {
        return 10;
    }

    public String formatValue(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        String s = o == null ? null : o.toString();
        return this.resetValueFormat(rf, fieldIndex, s, formatParams);
    }

    public Object readFrom(RecordFormatter rf, int fieldIndex, HttpParameters par, String suffix) {
        Object o = par.getParameter(intEditor.getInputName(rf, fieldIndex, suffix));
        if (o instanceof Vector) {
            throw new InvalidValueException(rf.expr[fieldIndex], "multiple value not accepted for integer: " + o);
        }
        return this.toInt(rf, fieldIndex, o);
    }

    public String formatNotNull(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        int stepSize = 1;
        try {
            stepSize = Integer.parseInt((String)formatParams.get("stepSize"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (StringUtils.equals(formatParams.get("type"), "spinner")) {
            StringBuffer spinner = new StringBuffer();
            spinner.append(super.formatNotNull(rf, fieldIndex, o, formatParams)).append("\n");
            spinner.append("<table valign=\"top\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"display: inline;\">\n<tr><td>");
            String inputValue = "document.getElementById('" + intEditor.getInputName(rf, fieldIndex, formatParams) + "').value";
            spinner.append("<input type=\"button\" value=\"+\" onclick=\"" + inputValue + " = " + inputValue + "==''? " + stepSize + ":parseInt(" + inputValue + ") + " + stepSize + ";\" style=\"font-size:5px;margin:0;padding:0;width:15px;height:12px;\">");
            spinner.append("</td></tr>\n<tr><td>");
            spinner.append("<input type=\"button\" value=\"-\" onclick=\"" + inputValue + "-=" + stepSize + ";\" style=\"font-size:5px;margin:0;padding:0;width:15px;height:12px;\">");
            spinner.append("</td></tr>\n    </table>");
            return spinner.toString();
        }
        if (StringUtils.equalsAny(formatParams.get("type"), "select", "radio")) {
            Collection<ValidationRule> validationRules = rf.dd.getFieldDefinition(fieldIndex).getValidationRules();
            for (ValidationRule validationRule : validationRules) {
                if (!(validationRule instanceof NumberRangeValidationRule)) continue;
                int lower = ((NumberRangeValidationRule)validationRule).getLowerLimit().intValue();
                int upper = ((NumberRangeValidationRule)validationRule).getUpperLimit().intValue();
                HtmlChoiceWriter writer = new HtmlChoiceWriter(intEditor.getInputName(rf, fieldIndex, formatParams));
                ArrayList<String> values = new ArrayList<String>();
                for (int i = lower; i <= upper; i += stepSize) {
                    values.add(String.valueOf(i));
                }
                if (!values.contains(String.valueOf(upper))) {
                    values.add(String.valueOf(upper));
                }
                writer.setValues(values);
                writer.setLabels(values);
                if (o != null) {
                    writer.setSelectedValues(o.toString());
                }
                return StringUtils.equals(formatParams.get("type"), "select") ? writer.getSelectOne() : writer.getRadioSelect();
            }
            throw new ProgrammerError("");
        }
        return super.formatNotNull(rf, fieldIndex, o, formatParams);
    }

    private static final class SingletonHolder {
        static final FieldEditor singleton = new intEditor();

        private SingletonHolder() {
        }
    }
}

