/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.oql;

import antlr.RecognitionException;
import antlr.SemanticException;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.providers.query.oql.FunctionAST;
import org.makumba.providers.query.oql.OQLAST;
import org.makumba.providers.query.oql.ParamAST;

public class AnalysisTree {
    public static final int OR = 1;
    public static final int AND = 2;
    public static final int SIM_COMP = 3;
    public static final int ASIM_COMP = 4;
    public static final int LIKE = 5;
    public static final int ADD = 6;
    public static final int MUL = 7;
    public static final int CONCAT = 9;
    public static final int UNION = 9;
    public static final int EXCEPT = 9;
    public static final int INTERSECT = 9;
    public static final int IN = 10;
    OQLAST leaf;
    Object makumbaType;
    int op;
    AnalysisTree left;
    AnalysisTree right;

    public AnalysisTree(OQLAST leaf) {
        this.leaf = leaf;
    }

    public AnalysisTree(Object left, int op, Object right) {
        this.left = this.getTree(left);
        this.right = this.getTree(right);
        this.op = op;
    }

    AnalysisTree getTree(Object o) {
        if (o instanceof AnalysisTree) {
            return (AnalysisTree)o;
        }
        OQLAST ast = (OQLAST)((Object)o);
        if (ast.tree == null) {
            return new AnalysisTree(ast);
        }
        return ast.tree;
    }

    public String toString() {
        if (this.left == null) {
            return this.leaf.toString();
        }
        return this.left + " " + this.op + " " + this.right;
    }

    public Object getMakumbaType() throws RecognitionException {
        if (this.makumbaType == null) {
            this.computeType();
        }
        return this.makumbaType;
    }

    public void computeType() throws RecognitionException {
        if (this.leaf != null) {
            this.makumbaType = this.leaf instanceof FunctionAST ? this.leaf.getMakumbaType() : this.leaf.makumbaType;
            return;
        }
        this.left.computeType();
        this.right.computeType();
        this.adjustType(this.left, this.right);
        this.adjustType(this.right, this.left);
        this.checkOperandTypes();
        this.makumbaType = this.computeTypeFromOperands();
    }

    void adjustType(AnalysisTree t1, AnalysisTree t2) {
        if (t1.makumbaType == null) {
            if (!(t1.leaf instanceof ParamAST)) {
                throw new MakumbaError("no makumba type assigned for " + ((Object)((Object)t1.leaf)).getClass() + " " + (Object)((Object)t1.leaf));
            }
            t1.leaf.makumbaType = t2.makumbaType != null ? (t1.makumbaType = this.guessParameterType(t2.makumbaType)) : (t1.makumbaType = this.guessParameterType());
        }
    }

    public Object computeTypeFromOperands() {
        return "int";
    }

    public Object guessParameterType(Object otherOperandType) {
        return "int";
    }

    public Object guessParameterType() {
        return "int";
    }

    public void checkOperandTypes() throws RecognitionException {
        this.checkOperandTypes(this.left.makumbaType, this.right.makumbaType);
    }

    public void checkOperandTypes(Object t1, Object t2) throws RecognitionException {
        if (t1 instanceof FieldDefinition) {
            t1 = ((FieldDefinition)t1).getDataType();
        }
        if (t2 instanceof FieldDefinition) {
            t2 = ((FieldDefinition)t2).getDataType();
        }
        if (!t1.equals(t2)) {
            this.negociateOperandTypes(t1, t2);
        }
    }

    public void negociateOperandTypes(Object t1, Object t2) throws RecognitionException {
        throw new SemanticException("Operand type check failed:\n\t'" + this.left + "' has type <" + t1 + "> and '" + this.right + "' has type <" + t2 + ">");
    }
}

