/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.aop.BaseInterceptor;
import org.jboss.cache.aop.CacheInterceptor;
import org.jboss.cache.aop.CachedType;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.TreeCacheAopDelegate;
import org.jboss.cache.aop.util.AopUtil;

public class ObjectGraphHandler {
    protected TreeCacheAop cache_;
    protected InternalDelegate internal_;
    protected static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$aop$ObjectGraphHandler == null ? (class$org$jboss$cache$aop$ObjectGraphHandler = ObjectGraphHandler.class$("org.jboss.cache.aop.ObjectGraphHandler")) : class$org$jboss$cache$aop$ObjectGraphHandler));
    protected TreeCacheAopDelegate delegate_;
    static /* synthetic */ Class class$org$jboss$cache$aop$ObjectGraphHandler;

    public ObjectGraphHandler(TreeCacheAop cache, InternalDelegate internal, TreeCacheAopDelegate delegate) {
        this.cache_ = cache;
        this.internal_ = internal;
        this.delegate_ = delegate;
    }

    Object objectGraphGet(Fqn fqn) throws CacheException {
        String refFqn = this.internal_.getRefFqn(fqn);
        if (refFqn != null) {
            Object obj;
            if (log.isDebugEnabled()) {
                log.debug((Object)("getObject(): obtain value from reference fqn: " + refFqn));
            }
            if ((obj = this.cache_.getObject(refFqn)) == null) {
                throw new RuntimeException("ObjectGraphHandler.objectGraphGet(): null object from internal ref node. Original fqn: " + fqn + " Internal ref node: " + refFqn);
            }
            return obj;
        }
        return null;
    }

    boolean objectGraphPut(Fqn fqn, Interceptor interceptor, CachedType type, Object obj) throws CacheException {
        Fqn originalFqn = null;
        if (interceptor == null) {
            return false;
        }
        originalFqn = ((BaseInterceptor)interceptor).getFqn();
        if (originalFqn == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("handleObjectGraph(): fqn: " + fqn + " is child for circular ref fqn " + originalFqn));
        }
        this.cache_.removeObject(fqn);
        this.setupRefCounting(fqn, originalFqn);
        this.internal_.putAopClazz(fqn, type.getType());
        return true;
    }

    boolean objectGraphRemove(Fqn fqn, boolean removeCacheInterceptor, Object pojo, boolean evict) throws CacheException {
        boolean isTrue = false;
        String refFqn = this.internal_.getRefFqn(fqn);
        if (refFqn != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("objectGraphRemove(): removing object fqn: " + fqn + " but is actually from ref fqn: " + refFqn + " Will just de-reference it."));
            }
            this.removeFromReference(fqn, refFqn, removeCacheInterceptor, evict);
            this.internal_.cleanUp(fqn, evict);
            isTrue = true;
        } else if (this.internal_.isReferenced(fqn)) {
            this.decrementRefCount(fqn, null);
            Fqn newFqn = this.internal_.getNextFqnInLine(fqn);
            if (newFqn.isChildOf(fqn)) {
                this.internal_.removeRefFqn(newFqn);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("objectGraphRemove(): this node " + fqn + " is currently referenced by a cyclic reference: " + newFqn.toString() + "Will only decrement reference count."));
                }
            } else {
                this.internal_.relocate(fqn, newFqn);
                InstanceAdvisor advisor = ((Advised)pojo)._getInstanceAdvisor();
                CacheInterceptor interceptor = (CacheInterceptor)AopUtil.findCacheInterceptor(advisor);
                if (interceptor == null) {
                    throw new IllegalStateException("ObjectGraphHandler.objectGraphRemove(): null interceptor");
                }
                interceptor.setFqn(newFqn);
                this.internal_.setIndirectFqn(fqn.toString(), newFqn.toString());
                isTrue = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("objectGraphRemove(): this node " + fqn + " is currently referenced by " + this.internal_.getRefCount(newFqn) + " other pojos after relocating to " + newFqn.toString()));
                }
            }
        }
        return isTrue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromReference(Fqn fqn, String refFqn, boolean removeCacheInterceptor, boolean evict) throws CacheException {
        String string = refFqn;
        synchronized (string) {
            if (this.decrementRefCount(Fqn.fromString(refFqn), fqn) == -1) {
                this.delegate_._removeObject(Fqn.fromString(refFqn), removeCacheInterceptor, evict);
            }
        }
        this.internal_.removeRefFqn(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupRefCounting(Fqn fqn, Fqn refFqn) throws CacheException {
        Fqn fqn2 = refFqn;
        synchronized (fqn2) {
            String aliasFqn = null;
            aliasFqn = this.incrementRefCount(refFqn, fqn) == 1 ? this.internal_.createIndirectFqn(refFqn.toString()) : this.internal_.getIndirectFqn(refFqn.toString());
            if (log.isTraceEnabled()) {
                log.trace((Object)("setupRefCounting(): current fqn: " + fqn + " set to point to: " + refFqn));
            }
            this.internal_.setRefFqn(fqn, aliasFqn);
        }
    }

    int incrementRefCount(Fqn originalFqn, Fqn referencingFqn) throws CacheException {
        return this.internal_.incrementRefCount(originalFqn, referencingFqn);
    }

    int decrementRefCount(Fqn originalFqn, Fqn referencingFqn) throws CacheException {
        int count = 0;
        count = this.internal_.decrementRefCount(originalFqn, referencingFqn);
        if (count == 0) {
            this.internal_.removeIndirectFqn(originalFqn.toString());
        }
        return count;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

