/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpUtils {
    public static final String identifier = "\\w[\\w|\\d]*";
    public static final String whitespace = "[\\s]*";
    public static final String minOneWhitespace = "[\\s]+";
    public static final String minOneLineWhitespace = "[ \\t]+";
    public static final String LineWhitespaces = "[ \\t]*";
    public static final String digit = "\\d";
    public static final String minOneDigit = "\\d+";
    public static final String nonDigit = "\\D";
    public static final String nonWhitespace = "[^\\s]";
    public static final String nonWhitespaces = "[^\\s]+";
    public static final String minOneNonWhitespace = "[^\\s]+";
    public static final String word = "\\w";
    public static final String minOneWord = "\\w+";
    public static final String nonWord = "\\W";
    public static final String fieldName = "[a-zA-Z]\\w*(?:\\.\\w+)?";
    public static final String fieldNameAndSpaces = "[a-zA-Z]\\w*(?:\\.\\w+)?[ \\t]*";

    public static String or(String[] options) {
        String s = "(";
        for (int i = 0; i < options.length; ++i) {
            s = s + options[i];
            if (i + 1 >= options.length) continue;
            s = s + "|";
        }
        return s + ")";
    }

    public static void main(String[] args) {
        System.out.println(RegExpUtils.or(new String[]{"a", "b", "c"}));
        RegExpUtils.testIdentifiers();
    }

    public static void testIdentifiers() {
        for (int i = 0; i < 256; ++i) {
            char ch = (char)i;
            if (!Character.isJavaIdentifierPart(ch)) continue;
            System.out.print(i + ":\t");
            if (Character.isJavaIdentifierStart(ch)) {
                System.out.print(ch);
            }
            System.out.println("\t" + ch);
        }
    }

    public static void evaluate(Pattern p, String[] rules, boolean details) {
        System.out.println(p.pattern());
        for (int i = 0; i < rules.length; ++i) {
            Matcher matcher = p.matcher(rules[i].trim());
            System.out.println(rules[i].trim() + ":" + matcher.matches());
            if (!matcher.matches() || !details) continue;
            System.out.print("groups:" + matcher.groupCount());
            for (int j = 0; j < matcher.groupCount(); ++j) {
                System.out.print("\t|" + matcher.group(j + 1) + "|");
            }
            System.out.println();
        }
    }

    public static void evaluate(Pattern p, String ... rules) {
        RegExpUtils.evaluate(p, rules, true);
    }
}

