/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.tags;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.makumba.MakumbaSystem;
import org.makumba.commons.Base64;
import org.makumba.commons.ReadableFormatter;
import org.makumba.providers.TransactionProvider;

public class MakumbaInfoTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private int line = 0;
    String applicationProperties;
    Properties sysprops = System.getProperties();

    public void setApplicationProperties(String applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public int doStartTag() throws JspException {
        try {
            String tomcatLocation;
            String hotspot;
            String password;
            String username;
            Properties projectProperties = new Properties();
            try {
                if (this.applicationProperties != null) {
                    projectProperties.load(new FileInputStream(this.applicationProperties));
                }
            }
            catch (IOException e) {
                System.err.println("IGNORED " + e);
            }
            JspWriter out = this.pageContext.getOut();
            out.println("<style type=\"text/css\"> h1,h2,h3,h4 {color: blue; margin-bottom:0px}</style>");
            out.println("<h1>Makumba System Information (&lt;mak:info /&gt;)</h1>");
            String startupProp = "startupTime";
            SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm");
            if (System.getProperty("startupTime") == null) {
                System.setProperty("startupTime", df.format(MakumbaSystem.loadingTime));
            }
            Runtime rt = Runtime.getRuntime();
            long maxHeap = rt.maxMemory();
            String initialHeap = System.getProperty("tomcat.jvm.initial_memory");
            if (initialHeap == null && (initialHeap = projectProperties.getProperty("tomcat.jvm.initial_memory")) == null) {
                initialHeap = "N/A";
            }
            if ((username = System.getProperty("tomcat.manager.user")) == null) {
                username = projectProperties.getProperty("tomcat.manager.user");
            }
            if ((password = System.getProperty("tomcat.manager.pass")) == null && (password = projectProperties.getProperty("tomcat.manager.pass")) != null) {
                projectProperties.remove("tomcat.manager.pass");
            }
            if ((hotspot = System.getProperty("tomcat.jvm.hotspot")) == null && (hotspot = projectProperties.getProperty("tomcat.jvm.hotspot")) == null) {
                hotspot = "N/A";
            }
            if ((tomcatLocation = System.getProperty("tomcat.manager.location")) == null) {
                tomcatLocation = projectProperties.getProperty("tomcat.manager.location");
            }
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpSession session = request.getSession(true);
            int port = request.getServerPort();
            String activeSessions = null;
            String activeSessionsTitle = null;
            String serverInfo = session.getServletContext().getServerInfo();
            if (serverInfo.indexOf("Tomcat") != -1) {
                if (username != null && password != null) {
                    try {
                        int found;
                        int n;
                        HttpURLConnection uc = (HttpURLConnection)new URL("http://localhost:" + port + "/" + (tomcatLocation != null ? tomcatLocation : "") + "manager/list").openConnection();
                        uc.setRequestProperty("connection", "close");
                        uc.setRequestProperty("Authorization", "Basic " + Base64.encode((username + ":" + password).getBytes()));
                        uc.setUseCaches(false);
                        uc.connect();
                        if (uc.getResponseCode() != 200) {
                            throw new RuntimeException(uc.getResponseMessage());
                        }
                        if (uc.getContentLength() == 0) {
                            throw new RuntimeException("content zero");
                        }
                        StringWriter sw = new StringWriter();
                        InputStreamReader ir = new InputStreamReader(uc.getInputStream());
                        char[] buf = new char[1024];
                        while ((n = ir.read(buf)) != -1) {
                            sw.write(buf, 0, n);
                        }
                        String list = sw.toString();
                        String marker = request.getContextPath();
                        if (marker.length() == 0) {
                            marker = "/";
                        }
                        if ((found = list.indexOf(marker = marker + ":running:") + marker.length()) == -1) {
                            throw new RuntimeException("context not found");
                        }
                        activeSessions = list.substring(found, list.indexOf(":", found + 1));
                    }
                    catch (Throwable t) {
                        out.println(" <p>could connect to /manager/list: " + t.getMessage() + " </p>");
                    }
                } else {
                    activeSessionsTitle = "Could not authenticate: 'applicationProperties' attribute must specify 'tomcat.manager.user' and 'tomcat.manager.pass' entries!";
                }
            } else {
                activeSessionsTitle = "This feature is currentely only supported for Apache Tomcat!";
            }
            if (activeSessions == null) {
                activeSessions = "<span title=\"" + activeSessionsTitle + "\">Unknwon</span>";
            }
            out.println("<table border=\"0\" bgcolor=\"white\" cellspacing=\"3\" cellpadding=\"3\" >");
            out.println("  <tr>");
            out.println("    <td valign=\"top\" nowrap=\"nowrap\"><font size=\"+1\"><b>Client:</td>");
            out.println("    <td>");
            out.println("      <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
            this.printSystemInfoRow(out, "Browser", request.getHeader("User-Agent"));
            this.printSystemInfoRow(out, "Host (IP)", request.getRemoteHost() + "(" + request.getRemoteAddr() + ")");
            out.println("      </table>");
            out.println("    </td>");
            out.println("  </tr>");
            out.println("  <tr>");
            out.println("    <td valign=\"top\"><font size=\"+1\"><b>Server:</b></font> JVM mode: <b>" + hotspot);
            out.println("    <td>");
            out.println("      <table border=\"0\" cellspacing=\"3\" cellpadding=\"3\">");
            String serverUpSince = ReadableFormatter.readableAge(new Date().getTime() - new Date(System.getProperty("startupTime")).getTime());
            String serverURL = request.getScheme() + "://" + request.getServerName() + ":" + port;
            this.line = 0;
            this.printSystemInfoRow(out, "Initial heap (-Xms)", initialHeap);
            this.printSystemInfoRow(out, "Max heap (-Xmx)", ReadableFormatter.readableBytes(maxHeap));
            this.printSystemInfoRow(out, "Current heap size", ReadableFormatter.readableBytes(rt.totalMemory()));
            this.printSystemInfoRow(out, "Heap in use", ReadableFormatter.readableBytes(rt.totalMemory() - rt.freeMemory()));
            this.printSystemInfoRow(out, "Free heap", ReadableFormatter.readableBytes(rt.freeMemory()));
            this.printSystemInfoRow(out, "Server is up since", System.getProperty("startupTime") + "</b>(" + serverUpSince + " ago)");
            this.printSystemInfoRow(out, "Last application (re)load", df.format(MakumbaSystem.loadingTime) + "(" + ReadableFormatter.readableAge(new Date().getTime() - MakumbaSystem.loadingTime.getTime()) + " ago)");
            this.printSystemInfoRow(out, "Server time", df.format(new Date()));
            this.printSystemInfoRow(out, "Active sessions", activeSessions);
            this.printSystemInfoRow(out, "Server protocol, name and port", "<a href=\"" + serverURL + "\">" + serverURL + "</a>");
            this.printSystemInfoRow(out, "Server software", this.pageContext.getServletContext().getServerInfo());
            out.println("        <tr bgcolor=\"#" + (this.line++ % 2 == 0 ? "eeeeee" : "ffffff") + "\">");
            out.print("          <td colspan=\"2\">");
            if (StringUtils.equals((String)request.getParameter("garbageCollection"), (String)"true")) {
                System.gc();
                out.print("Performed garbage collection. <a href=\"?\">Run without</a>");
            } else {
                out.print("<a href=\"?garbageCollection=true\">Request garbage collection</a>");
            }
            out.println("          </td>");
            out.println("        </tr>");
            out.println("      </table>");
            out.println("    </td>");
            out.println("  </tr>");
            out.println("</table>");
            if (this.applicationProperties != null) {
                out.println("<h2>Application specific properties <span style=\"font-size:smaller\">(" + this.applicationProperties + ")</span> </h2>");
                try {
                    projectProperties.load(new FileInputStream(this.applicationProperties));
                    this.printProperties(out, projectProperties);
                }
                catch (IOException io) {
                    out.println("<p style=\"color: red;\">Could not find application specific properties file <i>'" + this.applicationProperties + "'</i> in the current directory '" + new File("").getAbsolutePath() + "'</p>");
                }
            }
            out.println();
            out.println("<h2><a href=\"/makumba-docs/\"> Makumba</a></h2>");
            out.println("<table border=\"0\" cellspacing=\"3\" cellpadding=\"3\">");
            out.println("  <tr bgcolor=\"#cccccc\"> <th>Property</th> <th>Value</th> </tr>");
            String dbname = TransactionProvider.getInstance().getDefaultDataSourceName();
            this.line = 0;
            this.printMakumbaPropertyRow(out, "<a href=\"/makumba-docs/CHANGELOG.txt\">version</a>", MakumbaSystem.getVersion());
            this.printMakumbaPropertyRow(out, "Default database name", dbname);
            this.printMakumbaPropertyRow(out, "DBSV", MakumbaSystem.getDatabaseProperty(dbname, "dbsv"));
            this.printMakumbaPropertyRow(out, "Number of connections open", MakumbaSystem.getDatabaseProperty(dbname, "jdbc_connections"));
            this.printMakumbaPropertyRow(out, "Out of this, unused connections in the pool", MakumbaSystem.getDatabaseProperty(dbname, "resource_pool_size"));
            this.printMakumbaPropertyRow(out, "SQL engine and version", MakumbaSystem.getDatabaseProperty(dbname, "sql_engine.name"));
            this.printMakumbaPropertyRow(out, "JDBC driver and version", MakumbaSystem.getDatabaseProperty(dbname, "jdbc_driver.name") + " " + MakumbaSystem.getDatabaseProperty(dbname, "jdbc_driver.version"));
            out.println("</table>");
            out.println("<h3>Makumba caches: </h3>");
            out.println("<table border=\"0\" cellspacing=\"5\" cellpadding=\"3\">");
            out.println("  <tr> <th>Name</th> <th>size</th> <th>hits</th> <th>misses</th> </tr>");
            this.line = 0;
            Map<String, int[]> m = MakumbaSystem.getCacheInfo();
            TreeSet<String> treeSet = new TreeSet<String>(m.keySet());
            for (String nm : treeSet) {
                int[] o = m.get(nm);
                out.println("  <tr bgcolor=\"#" + (this.line++ % 2 == 0 ? "eeeeee" : "ffffff") + "\">");
                out.println("    <td>" + nm + "</td");
                if (o instanceof int[]) {
                    int[] intArray = o;
                    for (int i = 0; i < intArray.length; ++i) {
                        out.println("    <td align=right><code>" + intArray[i] + "</code></td>");
                    }
                } else {
                    out.println("    <td align=right><code>" + o + "</code></td>");
                }
                out.println("  </tr>");
            }
            out.println("</table>");
            out.println("<h2>User Session</h2>");
            out.print("Created: " + ReadableFormatter.readableAge(new Date().getTime() - session.getCreationTime()) + " ago ");
            out.println("(" + session.getCreationTime() + ")<br/>");
            out.print("Last Accessed: " + ReadableFormatter.readableAge(new Date().getTime() - session.getLastAccessedTime()) + " ago ");
            out.println("(" + session.getLastAccessedTime() + ")<br>");
            out.print("Max inactive interval:" + ReadableFormatter.readableAge(session.getMaxInactiveInterval() * 1000));
            out.println("(" + session.getMaxInactiveInterval() + ")<br>");
            Enumeration attribs = session.getAttributeNames();
            out.println("<table border=\"0\" cellspacing=\"3\" cellpadding=\"3\">");
            out.println("  <tr bgcolor=\"#cccccc\"> <th>Attribute</th> <th>Value</th> <th>Class</th> </tr>");
            this.line = 0;
            while (attribs.hasMoreElements()) {
                String key = (String)attribs.nextElement();
                out.println("  <tr bgcolor=\"#" + (this.line++ % 2 == 0 ? "eeeeee" : "ffffff") + "\">");
                out.println("    <td valign=\"top\">" + key + ":</td>");
                out.println("    <td><pre>" + session.getAttribute(key) + "</pre></td>");
                out.println("    <td>" + session.getAttribute(key).getClass().getName() + "</td>");
                out.println("  </tr>");
            }
            out.println("</table>");
            out.println("<h2>Java Virtual Machine properties</h2>");
            this.printProperties(out, this.sysprops);
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 1;
    }

    private void printProperties(JspWriter out, Properties props) throws IOException {
        Enumeration<?> enprop = props.propertyNames();
        out.println("<table border=\"0\" cellspacing=\"3\" cellpadding=\"3\">");
        out.println("  <tr bgcolor=\"#cccccc\"> <th>Property</th> <th>Value</th> </tr>");
        this.line = 0;
        while (enprop.hasMoreElements()) {
            String key = (String)enprop.nextElement();
            out.println("  <tr bgcolor=\"#" + (this.line++ % 2 == 0 ? "eeeeee" : "ffffff") + "\">");
            out.println("    <td valign=\"top\">" + key + "</td>");
            out.print("    <td><pre>");
            if (key != null) {
                if (key.endsWith("path")) {
                    out.print(props.getProperty(key).replace(this.sysprops.getProperty("path.separator").charAt(0), '\n'));
                } else if (props.getProperty(key).startsWith("http://")) {
                    out.print("<a href=" + props.getProperty(key) + ">" + props.getProperty(key) + "</a>");
                } else {
                    out.print(props.getProperty(key));
                }
            }
            out.println("</pre></td>");
            out.println("  </tr>");
        }
        out.println("</table>");
    }

    public void printMakumbaPropertyRow(JspWriter out, String key, String value) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("  <tr bgcolor=\"#" + (this.line++ % 2 == 0 ? "eeeeee" : "ffffff") + "\">");
        sb.append("    <td>" + key + "</td>");
        sb.append("    <td><code>" + value + "</code></td>");
        sb.append("  </tr>");
        out.println((Object)sb);
    }

    public void printSystemInfoRow(JspWriter out, String key, String value) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("        <tr bgcolor=\"#" + (this.line++ % 2 == 0 ? "eeeeee" : "ffffff") + "\">");
        sb.append("          <td>" + key + ":&nbsp;&nbsp;&nbsp;</td>");
        sb.append("          <td>" + value + "</td>");
        sb.append("        </tr>");
        out.println((Object)sb);
    }
}

