/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.html;

import java.util.Dictionary;
import org.makumba.HtmlUtils;
import org.makumba.commons.StringUtils;
import org.makumba.commons.formatters.FieldFormatter;
import org.makumba.commons.formatters.RecordFormatter;
import org.makumba.forms.html.FieldEditor;
import org.makumba.forms.html.binaryEditor;
import org.makumba.forms.tags.SearchFieldTag;

public class textEditor
extends FieldEditor {
    private boolean forceInput;
    static String[] _params = new String[]{"default", "empty", "type", "rows", "cols", "forceInputStyle"};
    static String[][] _paramValues = new String[][]{null, null, {"textarea", "file"}, null, null, SearchFieldTag.allowedSelectTypes};

    private textEditor() {
    }

    public static FieldFormatter getInstance() {
        return SingletonHolder.singleton;
    }

    public String[] getAcceptedParams() {
        return _params;
    }

    public String[][] getAcceptedValue() {
        return _paramValues;
    }

    public String getParams(RecordFormatter rf, int fieldIndex, Dictionary formatParams) {
        return this.getIntParamString(rf, fieldIndex, formatParams, "rows") + this.getIntParamString(rf, fieldIndex, formatParams, "cols");
    }

    public String format(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        this.forceInput = StringUtils.equals(formatParams.get("forceInputStyle"), "input");
        formatParams.remove("forceInputStyle");
        return super.format(rf, fieldIndex, o, formatParams);
    }

    public String formatNull(RecordFormatter rf, int fieldIndex, Dictionary formatParams) {
        return this.formatNotNull(rf, fieldIndex, null, formatParams);
    }

    public String formatNotNull(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        if (this.isTextArea(rf, fieldIndex, formatParams)) {
            return (this.forceInput ? "<INPUT type=\"text\"" : "<TEXTAREA") + " name=\"" + textEditor.getInputName(rf, fieldIndex, formatParams) + "\" " + this.getParams(rf, fieldIndex, formatParams) + textEditor.getExtraFormatting(rf, fieldIndex, formatParams) + " >" + this.formatValue(rf, fieldIndex, o, formatParams) + (this.forceInput ? "</INPUT>" : "</TEXTAREA>");
        }
        return binaryEditor.fileInput(rf, fieldIndex, formatParams);
    }

    public String formatValue(RecordFormatter rf, int fieldIndex, Object o, Dictionary formatParams) {
        String s = o == null ? null : HtmlUtils.string2html(o.toString());
        return this.resetValueFormat(rf, fieldIndex, s, formatParams);
    }

    boolean isTextArea(RecordFormatter rf, int fieldIndex, Dictionary formatParams) {
        String s = (String)formatParams.get("type");
        if (s == null) {
            return true;
        }
        return s.equals("textarea");
    }

    private static final class SingletonHolder {
        static final FieldEditor singleton = new textEditor();

        private SingletonHolder() {
        }
    }
}

