/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.forms.responder;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.makumba.CompositeValidationException;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.Transaction;
import org.makumba.commons.DbConnectionProvider;
import org.makumba.commons.StringUtils;
import org.makumba.forms.html.FieldEditor;
import org.makumba.forms.html.RecordEditor;
import org.makumba.forms.responder.Responder;
import org.makumba.forms.validation.ClientsideValidationProvider;
import org.makumba.providers.DataDefinitionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormResponder
extends Responder {
    private static final long serialVersionUID = 1L;
    RecordEditor editor;
    Hashtable<String, Integer> indexes = new Hashtable();
    DataDefinition dd = DataDefinitionProvider.getInstance().getVirtualDataDefinition("Form responder");
    int max = 0;
    Hashtable<String, Dictionary<String, Object>> fieldParameters = new Hashtable();
    Hashtable<String, String> fieldNames = new Hashtable();
    protected String action;
    protected String method = "GET";
    protected boolean multipart;
    StringBuffer extraFormatting;
    private ClientsideValidationProvider provider = MakumbaSystem.getClientsideValidationProvider();
    private HashMap<String, String> lazyEvaluatedInputs;

    @Override
    public Dictionary<String, Object> getHttpData(HttpServletRequest req, String suffix) {
        if (this.editor != null) {
            Dictionary<String, Object> data = this.editor.readFrom(req, suffix, !this.operation.equals("search"));
            HashMap results = (HashMap)req.getAttribute("org.makumba.formResults");
            if (this.lazyEvaluatedInputs != null) {
                for (String key : this.lazyEvaluatedInputs.keySet()) {
                    if (results.get(key) == null) continue;
                    data.put(this.lazyEvaluatedInputs.get(key), results.get(key));
                }
            }
            return data;
        }
        return new Hashtable<String, Object>(1);
    }

    @Override
    public ArrayList<InvalidValueException> getUnassignedExceptions(CompositeValidationException e, ArrayList<InvalidValueException> unassignedExceptions, String suffix) {
        if (this.editor != null) {
            return this.editor.getUnassignedExceptions(e, unassignedExceptions, suffix);
        }
        return null;
    }

    public String format(String fname, FieldDefinition ftype, Object fval, Hashtable<String, Object> formatParams, String extraFormatting, Object formIdentifier) {
        Dictionary paramCopy = (Dictionary)formatParams.clone();
        if (!ftype.isDateType() && !StringUtils.equalsAny(formatParams.get("type"), "radio", "checkbox", "tickbox")) {
            extraFormatting = extraFormatting + "id=\"" + fname + this.storedSuffix + "_" + formIdentifier + "\" ";
        }
        FieldEditor.setSuffix(paramCopy, this.storedSuffix);
        FieldEditor.setExtraFormatting(paramCopy, extraFormatting);
        boolean display = formatParams.get("org.makumba.noDisplay") == null;
        Integer i = this.indexes.get(fname);
        if (i != null) {
            return display ? this.editor.format(i, fval, paramCopy) : "";
        }
        this.indexes.put(fname, new Integer(this.max));
        String colName = "col" + this.max;
        this.fieldNames.put(colName, fname);
        this.fieldParameters.put(colName, formatParams);
        this.dd.addField(DataDefinitionProvider.getInstance().makeFieldWithName(colName, ftype));
        this.editor = new RecordEditor(this.dd, this.fieldNames, this.database, this.operation.equals("search"), formIdentifier);
        this.editor.config();
        if (!this.operation.equals("search") && StringUtils.equalsAny(this.clientSideValidation, "true", "live")) {
            this.provider.initField(fname + this.storedSuffix + "_" + formIdentifier, ftype, this.clientSideValidation.equals("live"));
        }
        ++this.max;
        return display ? this.editor.format(this.max - 1, fval, paramCopy) : "";
    }

    @Override
    public String responderKey() {
        return "" + this.fieldNames + this.fieldParameters + super.responderKey();
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setExtraFormatting(StringBuffer extraFormatting) {
        this.extraFormatting = extraFormatting;
    }

    public void writeFormPreamble(StringBuffer sb, String basePointer) {
        if (!this.storedSuffix.equals("")) {
            return;
        }
        String sep = this.action.indexOf(63) >= 0 ? "&" : "?";
        String actionBase = this.action;
        String actionAnchor = "";
        int actionHashPos = this.action.indexOf(35);
        if (actionHashPos > -1) {
            actionBase = this.action.substring(0, actionHashPos);
            actionAnchor = this.action.substring(actionHashPos);
        }
        if (this.operation.equals("deleteLink")) {
            sb.append("<a href=\"").append(actionBase).append(sep).append("__makumba__base__").append("=").append(basePointer).append('&').append("__makumba__responder__").append("=").append(this.getPrototype()).append(actionAnchor).append("\" ").append(this.extraFormatting).append(">");
        } else if (this.operation.equals("deleteForm")) {
            sb.append("<form action=").append("\"").append(actionBase).append(actionAnchor).append("\"");
            sb.append(" method=").append("\"").append(this.method).append("\"");
            if (this.multipart) {
                sb.append(" enctype=\"multipart/form-data\" ");
            }
            sb.append(this.extraFormatting);
            sb.append(">");
            sb.append("<input type=\"submit\" ").append("value=\"");
        } else {
            StringBuffer onSubmitValidation;
            sb.append("<form action=");
            sb.append("\"" + this.action + "\"");
            sb.append(" method=");
            sb.append("\"" + this.method + "\"");
            if (this.multipart) {
                sb.append(" enctype=\"multipart/form-data\" ");
            }
            if (!this.operation.equals("search") && StringUtils.equalsAny(this.clientSideValidation, "true", "live") && (onSubmitValidation = this.provider.getOnSubmitValidation(org.apache.commons.lang.StringUtils.equals((String)this.clientSideValidation, (String)"live"))) != null && onSubmitValidation.length() > 0) {
                sb.append(" onsubmit=\"return ");
                sb.append(onSubmitValidation);
                sb.append("\"");
            }
            sb.append(this.extraFormatting);
            sb.append(">");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFormPostamble(StringBuffer sb, String basePointer, HttpServletRequest request) {
        String session = request.getSession().getId();
        this.factory.setResponderWorkingDir(request);
        if (this.storedSuffix.equals("") && this.operation.equals("deleteLink")) {
            sb.append("</a>");
            return;
        }
        if (this.storedSuffix.equals("") && this.operation.equals("deleteForm")) {
            sb.append("\"/>");
        }
        if (basePointer != null) {
            this.writeInput(sb, "__makumba__base__", basePointer, this.storedSuffix);
        }
        String responderValue = this.getResponderValue();
        String formSessionValue = responderValue + session;
        this.writeInput(sb, "__makumba__responder__", responderValue, "");
        if (this.multipleSubmitErrorMsg != null && !this.multipleSubmitErrorMsg.equals("")) {
            sb.append('\n');
            this.writeInput(sb, "__makumba__formSession__", formSessionValue, "");
            Transaction db = ((DbConnectionProvider)request.getAttribute("org.makumba.providerAttribute")).getTransactionProvider().getConnectionTo(this.database);
            try {
                Hashtable<String, Object> p = new Hashtable<String, Object>();
                ((Dictionary)p).put("formSession", formSessionValue);
                db.insert("org.makumba.controller.MultipleSubmit", p);
            }
            finally {
                db.close();
            }
        }
        if (!this.operation.equals("search") && this.reloadFormOnError) {
            String url = request.getRequestURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                if (queryString.indexOf("__makumba__originatingPage__") > 0) {
                    queryString = queryString.substring(0, queryString.indexOf("__makumba__originatingPage__") - 1);
                }
                url = url + "?" + queryString;
            }
            this.writeInput(sb, "__makumba__originatingPage__", url, "");
            sb.append('\n');
        }
        if (this.storedSuffix.equals("")) {
            sb.append("\n</form>");
        }
    }

    public String getResponderValue() {
        return this.getPrototype() + this.storedSuffix + this.storedParentSuffix;
    }

    void writeInput(StringBuffer sb, String name, String value, String suffix) {
        sb.append("<input type=\"hidden\" name=\"").append(name).append(suffix).append("\" value=\"").append(value).append("\">");
    }

    @Override
    protected void postDeserializaton() {
        if (this.editor != null) {
            this.editor.initFormatters();
        }
    }

    public void writeClientsideValidation(StringBuffer sb) {
        sb.append(this.provider.getClientValidation(this.clientSideValidation.equals("live")));
    }

    public void setLazyEvaluatedInputs(HashMap<String, String> unresolvedInputValues) {
        this.lazyEvaluatedInputs = unresolvedInputValues;
    }

    public HashMap<String, String> getLazyEvaluatedInputs() {
        return this.lazyEvaluatedInputs;
    }
}

