/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class FloatParser
implements DataParser {
    public Class getType() {
        return Float.TYPE;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)value).floatValue()) + "f";
    }

    public boolean canParse(String text) {
        try {
            Float.parseFloat(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Object parse(String text) throws DataParseException {
        return new Float(FloatParser.parseFloat(text));
    }

    public static float parseFloat(String text) throws DataParseException {
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException e) {
            throw new DataParseException(e);
        }
    }
}

