/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ContentWriter
implements ContentHandler {
    final boolean useIndent;
    private String indent = "   ";
    private int depth = 0;
    private boolean started = false;
    private final Writer writer;

    public ContentWriter(Writer writer, boolean indent) {
        this.writer = writer;
        this.useIndent = indent;
    }

    public void setDocumentLocator(Locator locator) {
        throw new UnsupportedOperationException();
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        throw new UnsupportedOperationException();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        throw new UnsupportedOperationException();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        int colon;
        if (this.useIndent) {
            ContentWriter.write(this.writer, 10);
            for (int j = 0; j < this.depth; ++j) {
                ContentWriter.write(this.writer, this.indent);
            }
        }
        if (!this.started) {
            this.started = true;
        }
        ++this.depth;
        ContentWriter.write(this.writer, 60);
        ContentWriter.write(this.writer, qName);
        if (atts != null && atts.getLength() > 0) {
            for (int i = 0; i < atts.getLength(); ++i) {
                ContentWriter.write(this.writer, 32);
                ContentWriter.write(this.writer, atts.getQName(i));
                ContentWriter.write(this.writer, "=\"");
                ContentWriter.write(this.writer, atts.getValue(i));
                ContentWriter.write(this.writer, 34);
            }
        }
        if (namespaceURI != null && namespaceURI.length() > 1 && (colon = qName.indexOf(58)) >= 0) {
            String prefix = qName.substring(0, colon);
            if (this.useIndent) {
                ContentWriter.write(this.writer, 10);
                for (int i = 0; i < this.depth + 1; ++i) {
                    ContentWriter.write(this.writer, this.indent);
                }
            } else {
                ContentWriter.write(this.writer, 32);
            }
            ContentWriter.write(this.writer, "xmlns:");
            ContentWriter.write(this.writer, prefix);
            ContentWriter.write(this.writer, "=\"");
            ContentWriter.write(this.writer, namespaceURI);
            ContentWriter.write(this.writer, "\"");
        }
        ContentWriter.write(this.writer, 62);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        --this.depth;
        if (!this.started) {
            if (this.useIndent) {
                ContentWriter.write(this.writer, 10);
                for (int j = 0; j < this.depth; ++j) {
                    ContentWriter.write(this.writer, this.indent);
                }
            }
        } else {
            this.started = false;
        }
        ContentWriter.write(this.writer, "</");
        ContentWriter.write(this.writer, qName);
        ContentWriter.write(this.writer, 62);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        ContentWriter.write(this.writer, ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        throw new UnsupportedOperationException();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        throw new UnsupportedOperationException();
    }

    public void skippedEntity(String name) throws SAXException {
        throw new UnsupportedOperationException();
    }

    private static void write(Writer writer, String str) throws SAXException {
        try {
            writer.write(str);
        }
        catch (IOException e) {
            throw new SAXException("Writting failed: " + e.getMessage(), e);
        }
    }

    private static void write(Writer writer, int ch) throws SAXException {
        try {
            writer.write(ch);
        }
        catch (IOException e) {
            throw new SAXException("Writting failed: " + e.getMessage(), e);
        }
    }

    private static void write(Writer writer, char[] ch, int start, int length) throws SAXException {
        try {
            writer.write(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException("Writting failed: " + e.getMessage(), e);
        }
    }
}

