/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.makumba.db.makumba.sql.SQLDBConnection;
import org.makumba.db.makumba.sql.TableManager;

public class MysqlTableManager
extends TableManager {
    protected String createDbSpecific(String command) {
        return command + " type=InnoDB";
    }

    protected void alter(SQLDBConnection dbc, TableManager.CheckingStrategy cs) throws SQLException {
        Statement st = dbc.createStatement();
        ResultSet rs = st.executeQuery("SHOW CREATE TABLE " + this.getDBName());
        rs.next();
        String def = rs.getString(2).trim();
        if (def.lastIndexOf(41) > def.lastIndexOf(" TYPE=InnoDB") && def.lastIndexOf(41) > def.lastIndexOf(" ENGINE=InnoDB")) {
            String s = "ALTER TABLE " + this.getDBName() + " TYPE=InnoDB";
            Logger.getLogger("org.makumba.db.init.tablechecking").info(this.getSQLDatabase().getConfiguration() + ": " + s);
            st.executeUpdate(s);
        }
        rs.close();
        st.close();
        super.alter(dbc, cs);
    }

    protected String getTableMissingStateName(SQLDBConnection dbc) {
        try {
            String version2 = dbc.getMetaData().getDriverVersion();
            int major = dbc.getMetaData().getDriverMajorVersion();
            int minor = dbc.getMetaData().getDriverMinorVersion();
            String mark = "" + major + "." + minor + ".";
            String minorStr = version2.substring(version2.indexOf(mark) + mark.length());
            minorStr = minorStr.indexOf(45) == -1 ? minorStr.substring(0, minorStr.indexOf(32)) : minorStr.substring(0, minorStr.indexOf(45));
            int minor2 = Integer.parseInt(minorStr);
            if (major > 3 || major == 3 && minor > 0 || major == 3 && minor == 0 && minor2 >= 8) {
                return "tableMissing";
            }
            return "tableMissing-before308";
        }
        catch (Exception e) {
            return "tableMissing";
        }
    }

    protected int getSQLType(String fieldName) {
        switch (this.getFieldDefinition(fieldName).getIntegerType()) {
            case 8: {
                return -1;
            }
        }
        return super.getSQLType(fieldName);
    }
}

