/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaError;
import org.makumba.db.makumba.Database;
import org.makumba.db.makumba.sql.TableManager;
import org.makumba.providers.QueryAnalysis;

public class ParameterAssigner {
    TableManager paramHandler;
    QueryAnalysis tree;
    static final Object[] empty = new Object[0];

    ParameterAssigner(Database db, QueryAnalysis qA) {
        this.tree = qA;
        if (qA.parameterNumber() > 0) {
            this.paramHandler = (TableManager)db.makePseudoTable(qA.getParameterTypes());
        }
    }

    public String assignParameters(PreparedStatement ps, Object[] args) throws SQLException {
        if (this.tree.parameterNumber() == 0) {
            return null;
        }
        try {
            Hashtable<String, Integer> correct = new Hashtable<String, Integer>();
            Hashtable<String, InvalidValueException> errors = new Hashtable<String, InvalidValueException>();
            for (int i = 0; i < this.tree.parameterNumber(); ++i) {
                FieldDefinition fd = this.paramHandler.getDataDefinition().getFieldDefinition("param" + i);
                Integer para = new Integer(this.tree.parameterAt(i));
                String spara = "$" + para;
                Object value = args[para - 1];
                try {
                    value = fd.checkValue(value);
                }
                catch (InvalidValueException e) {
                    if (correct.get(spara) == null) {
                        errors.put(spara, e);
                    }
                    this.paramHandler.setNullArgument("param" + i, ps, i + 1);
                    continue;
                }
                correct.put(spara, para);
                errors.remove(spara);
                this.paramHandler.setUpdateArgument("param" + i, ps, i + 1, value);
            }
            if (errors.size() > 0) {
                String s = "";
                Enumeration e = errors.keys();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    s = s + "\nargument: " + o + "; exception:\n" + errors.get(o);
                }
                return s;
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new MakumbaError("wrong number of arguments to query ");
        }
        return null;
    }
}

