/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.makumba.FieldDefinition;
import org.makumba.providers.datadefinition.makumba.validation.SingleFieldValidationRule;

public abstract class RangeValidationRule
extends SingleFieldValidationRule {
    protected static final String rule = "\\[(\\d+|\\?)\\.\\.(\\d+|\\?)\\]";
    protected static final Pattern pattern = Pattern.compile(RangeValidationRule.getAcceptedRules());
    protected String lowerLimitString;
    protected String upperLimitString;
    protected Number lowerLimit;
    protected Number upperLimit;

    public static String getAcceptedRules() {
        return rule;
    }

    public static Matcher getMatcher(String rule) {
        return pattern.matcher(rule);
    }

    public static boolean matches(String rule) {
        return RangeValidationRule.getMatcher(rule).matches();
    }

    protected RangeValidationRule() {
    }

    public RangeValidationRule(FieldDefinition fd, String fieldName, String errorMessage, String ruleName, int[] allowedTypes, String lowerLimitString, String upperLimitString) {
        super(fd, fieldName, errorMessage, ruleName, allowedTypes);
        this.lowerLimitString = lowerLimitString.trim();
        this.upperLimitString = upperLimitString.trim();
    }

    public String getLowerLimitString() {
        return this.lowerLimitString;
    }

    public String getUpperLimitString() {
        return this.upperLimitString;
    }

    public Number getLowerLimit() {
        return this.lowerLimit;
    }

    public Number getUpperLimit() {
        return this.upperLimit;
    }
}

