/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.collections.AST;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.hql.antlr.HqlTokenTypes;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.makumba.commons.ClassResource;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.query.hql.HQLQueryAnalysisProvider;
import org.makumba.providers.query.hql.HqlAnalyzeWalker;
import org.makumba.providers.query.hql.MddObjectType;
import org.makumba.providers.query.mql.HqlSqlTokenTypes;
import org.makumba.providers.query.mql.MqlSqlGenerator;
import org.makumba.providers.query.mql.MqlSqlWalker;

public class ParserTest {
    private static QueryAnalysisProvider qap = new HQLQueryAnalysisProvider();
    private static PrintWriter pw = new PrintWriter(System.out);
    private static ASTPrinter printerHql = new ASTPrinter(HqlTokenTypes.class);
    private static ASTPrinter printerHqlSql = new ASTPrinter(HqlSqlTokenTypes.class);
    public static final String regExpInSET = "in[\\s]+set[\\s]*\\(";
    public static final Pattern patternInSet = Pattern.compile("in[\\s]+set[\\s]*\\(");

    public static void main(String[] argv) {
        int line = 1;
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)ClassResource.get("org/makumba/providers/query/mql/queries.txt").getContent()));
            String query = null;
            while ((query = rd.readLine()) != null) {
                query = ParserTest.preProcess(query);
                ParserTest.analyseQuery(line, query);
                ++line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("analyzed " + line + " queries");
    }

    private static void transformOQL(AST a) {
        if (a == null) {
            return;
        }
        if (a.getType() == 120 && a.getText().startsWith("$")) {
            a.setType(116);
            Node para = new Node();
            para.setType(120);
            para.setText("makumbaParam" + a.getText().substring(1));
            a.setFirstChild((AST)para);
            a.setText(":");
        } else if (a.getType() == 97 || a.getType() == 103) {
            if (ParserTest.isNil(a.getFirstChild())) {
                ParserTest.setNullTest(a);
                a.setFirstChild(a.getFirstChild().getNextSibling());
            } else if (ParserTest.isNil(a.getFirstChild().getNextSibling())) {
                ParserTest.setNullTest(a);
                a.getFirstChild().setNextSibling(null);
            }
        }
        ParserTest.transformOQL(a.getFirstChild());
        ParserTest.transformOQL(a.getNextSibling());
    }

    private static void setNullTest(AST a) {
        if (a.getType() == 97) {
            a.setType(77);
            a.setText("is null");
        } else {
            a.setType(76);
            a.setText("is not null");
        }
    }

    private static boolean isNil(AST a) {
        return a.getType() == 120 && a.getText().toUpperCase().equals("NIL");
    }

    private static void analyseQuery(int line, String query) {
        AST hql = null;
        AST hql_sql = null;
        try {
            HqlParser parser = HqlParser.getInstance((String)query);
            parser.statement();
            if (parser.getParseErrorHandler().getErrorCount() > 0) {
                parser.getParseErrorHandler().throwQueryException();
            }
            hql = parser.getAST();
            ParserTest.transformOQL(hql);
            MqlSqlWalker m = new MqlSqlWalker();
            m.statement(hql);
            if (m.error != null) {
                throw m.error;
            }
            hql_sql = m.getAST();
            MqlSqlGenerator mg = new MqlSqlGenerator();
            mg.statement(hql_sql);
            if (mg.error != null) {
                throw mg.error;
            }
            HqlAnalyzeWalker walker = new HqlAnalyzeWalker();
            walker.setTypeComputer(new MddObjectType());
            walker.setDebug(query);
            walker.statement(hql);
        }
        catch (Throwable t) {
            System.out.println(line + ": " + t.getMessage() + " " + query);
            if (t.getMessage().indexOf("defined twice") != -1) {
                return;
            }
            if (t.getMessage().indexOf("FROM expected") != -1) {
                return;
            }
            if (t.getMessage().indexOf("Unknown label") != -1) {
                return;
            }
            if (t.getMessage().indexOf("unknown alias") != -1) {
                return;
            }
            if (t.getMessage().indexOf("No such field") != -1) {
                return;
            }
            if (t.getMessage().indexOf("survey") != -1) {
                return;
            }
            if (hql != null && hql_sql == null) {
                printerHql.showAst(hql, pw);
            }
            if (hql_sql != null) {
                printerHqlSql.showAst(hql_sql, pw);
            }
            t.printStackTrace();
        }
    }

    public static String preProcess(String query) {
        query = query.replaceAll("->", "__");
        Matcher m = patternInSet.matcher(query.toLowerCase());
        while (m.find()) {
            int start = m.start();
            int beginSet = m.group().indexOf("set");
            query = query.substring(0, start + beginSet) + "   " + query.substring(start + beginSet + 3);
        }
        query = query.replaceAll("IN SET", "IN    ");
        return query;
    }
}

