/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.MRUConfiguration;
import org.jboss.cache.eviction.MRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.Region;

public class MRUAlgorithm
extends BaseEvictionAlgorithm {
    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new MRUQueue();
    }

    protected boolean shouldEvictNode(NodeEntry ne) {
        MRUConfiguration config = (MRUConfiguration)this.region.getEvictionConfiguration();
        return this.evictionQueue.size() > config.getMaxNodes();
    }

    protected void processVisitedNodes(Fqn fqn) throws EvictionException {
        super.processVisitedNodes(fqn);
        ((MRUQueue)this.evictionQueue).moveToTopOfStack(fqn);
    }
}

