/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;

public class FileCacheLoader
implements CacheLoader {
    File root = null;
    TreeCache cache = null;
    Log log = LogFactory.getLog(this.getClass());
    HashMap transactions = new HashMap();
    public static final String DATA = "data.dat";
    public static final String DIR_SUFFIX = "fdb";

    public void setConfig(Properties props) {
        String location;
        String string = location = props != null ? props.getProperty("location") : null;
        if (location != null && location.length() > 0) {
            this.root = new File(location);
        }
    }

    public void setCache(TreeCache c) {
        this.cache = c;
    }

    public void create() throws Exception {
        if (this.root == null) {
            String tmpLocation = System.getProperty("java.io.tmpdir", "C;\\tmp");
            this.root = new File(tmpLocation);
        }
        if (!this.root.exists()) {
            boolean created;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Creating cache loader location " + this.root));
            }
            if (!(created = this.root.mkdirs())) {
                throw new IOException("Unable to create cache loader location " + this.root);
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Set getChildrenNames(Fqn fqn) throws Exception {
        File parent = this.getDirectory(fqn, false);
        if (parent == null) {
            return null;
        }
        File[] children = parent.listFiles();
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (!child.isDirectory() || !child.getName().endsWith(DIR_SUFFIX)) continue;
            String child_name = child.getName();
            child_name = child_name.substring(0, child_name.lastIndexOf(DIR_SUFFIX) - 1);
            s.add(child_name);
        }
        return s.size() == 0 ? null : s;
    }

    public Map get(Fqn fqn) throws Exception {
        return this.loadAttributes(fqn);
    }

    public boolean exists(Fqn fqn) throws Exception {
        File f = this.getDirectory(fqn, false);
        return f != null;
    }

    public Object put(Fqn fqn, Object key, Object value) throws Exception {
        Object retval = null;
        HashMap<Object, Object> m = this.loadAttributes(fqn);
        if (m == null) {
            m = new HashMap<Object, Object>();
        }
        retval = m.put(key, value);
        this.storeAttributes(fqn, m);
        return retval;
    }

    public void put(Fqn fqn, Map attributes) throws Exception {
        this.put(fqn, attributes, false);
    }

    public void put(Fqn fqn, Map attributes, boolean erase) throws Exception {
        Map m;
        Map map = m = erase ? new HashMap() : this.loadAttributes(fqn);
        if (m == null) {
            m = new HashMap();
        }
        if (attributes != null) {
            m.putAll(attributes);
        }
        this.storeAttributes(fqn, m);
    }

    void put(Fqn fqn) throws Exception {
        this.getDirectory(fqn, true);
    }

    public void put(List modifications) throws Exception {
        if (modifications == null) {
            return;
        }
        Iterator it = modifications.iterator();
        block8: while (it.hasNext()) {
            Modification m = (Modification)it.next();
            switch (m.getType()) {
                case 2: {
                    this.put(m.getFqn(), m.getData());
                    continue block8;
                }
                case 3: {
                    this.put(m.getFqn(), m.getData(), true);
                    continue block8;
                }
                case 1: {
                    this.put(m.getFqn(), m.getKey(), m.getValue());
                    continue block8;
                }
                case 6: {
                    this.removeData(m.getFqn());
                    continue block8;
                }
                case 5: {
                    this.remove(m.getFqn(), m.getKey());
                    continue block8;
                }
                case 4: {
                    this.remove(m.getFqn());
                    continue block8;
                }
            }
            this.log.error((Object)("modification type " + m.getType() + " not known"));
        }
    }

    public Object remove(Fqn fqn, Object key) throws Exception {
        Object retval = null;
        Map m = this.loadAttributes(fqn);
        if (m == null) {
            return null;
        }
        retval = m.remove(key);
        this.storeAttributes(fqn, m);
        return retval;
    }

    public void remove(Fqn fqn) throws Exception {
        boolean flag;
        File dir = this.getDirectory(fqn, false);
        if (dir != null && !(flag = this.removeDirectory(dir, true))) {
            this.log.warn((Object)("failed removing " + fqn));
        }
    }

    public void removeData(Fqn fqn) throws Exception {
        boolean flag;
        File data;
        File f = this.getDirectory(fqn, false);
        if (f != null && (data = new File(f, DATA)) != null && data.exists() && !(flag = data.delete())) {
            this.log.warn((Object)("failed removing file " + data.getName()));
        }
    }

    public void prepare(Object tx, List modifications, boolean one_phase) throws Exception {
        if (one_phase) {
            this.put(modifications);
        } else {
            this.transactions.put(tx, modifications);
        }
    }

    public void commit(Object tx) throws Exception {
        List modifications = (List)this.transactions.get(tx);
        if (modifications == null) {
            throw new Exception("transaction " + tx + " not found in transaction table");
        }
        this.put(modifications);
        this.transactions.remove(tx);
    }

    public void rollback(Object tx) {
        this.transactions.remove(tx);
    }

    public byte[] loadEntireState() throws Exception {
        ByteArrayOutputStream out_stream = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream out = new MarshalledValueOutputStream((OutputStream)out_stream);
        this.loadStateFromFilessystem(Fqn.fromString("/"), (ObjectOutputStream)out);
        out.close();
        return out_stream.toByteArray();
    }

    public void storeEntireState(byte[] state) throws Exception {
        ByteArrayInputStream in_stream = new ByteArrayInputStream(state);
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)in_stream);
        this.remove(Fqn.fromString("/"));
        try {
            while (true) {
                NodeData nd = (NodeData)in.readObject();
                if (nd.attrs != null) {
                    this.put(nd.fqn, nd.attrs, true);
                    continue;
                }
                this.put(nd.fqn);
            }
        }
        catch (EOFException eof_ex) {
            return;
        }
    }

    protected void loadStateFromFilessystem(Fqn fqn, ObjectOutputStream out) throws Exception {
        Map attrs = this.get(fqn);
        NodeData nd = attrs == null || attrs.size() == 0 ? new NodeData(fqn) : new NodeData(fqn, attrs);
        out.writeObject(nd);
        Set children_names = this.getChildrenNames(fqn);
        if (children_names == null) {
            return;
        }
        Iterator it = children_names.iterator();
        while (it.hasNext()) {
            String child_name = (String)it.next();
            Fqn tmp_fqn = new Fqn(fqn, child_name);
            this.loadStateFromFilessystem(tmp_fqn, out);
        }
    }

    File getDirectory(Fqn fqn, boolean create) {
        File f = new File(this.getFullPath(fqn));
        if (!f.exists()) {
            if (create) {
                f.mkdirs();
            } else {
                return null;
            }
        }
        return f;
    }

    boolean removeDirectory(File dir, boolean include_start_dir) {
        boolean success = true;
        File[] subdirs = dir.listFiles();
        for (int i = 0; i < subdirs.length; ++i) {
            File file = subdirs[i];
            if (file.isFile() && file.getName().equals(DATA)) {
                if (file.delete()) continue;
                success = false;
                continue;
            }
            if (!file.isDirectory() || !file.getName().endsWith(DIR_SUFFIX)) continue;
            if (!this.removeDirectory(file, false)) {
                success = false;
            }
            if (file.delete()) continue;
            success = false;
        }
        if (include_start_dir && !dir.equals(this.root) && !dir.delete()) {
            success = false;
        }
        return success;
    }

    String getFullPath(Fqn fqn) {
        StringBuffer sb = new StringBuffer(this.root.getAbsolutePath() + File.separator);
        for (int i = 0; i < fqn.size(); ++i) {
            Object tmp = fqn.get(i);
            String tmp_dir = tmp instanceof String ? (String)tmp : tmp.toString();
            sb.append(tmp_dir).append(".").append(DIR_SUFFIX).append(File.separator);
        }
        return sb.toString();
    }

    protected Map loadAttributes(Fqn fqn) throws Exception {
        File f = this.getDirectory(fqn, false);
        if (f == null) {
            return null;
        }
        File child = new File(f, DATA);
        if (!child.exists()) {
            return new HashMap(0);
        }
        FileInputStream in = new FileInputStream(child);
        MarshalledValueInputStream input = new MarshalledValueInputStream((InputStream)in);
        Map m = (Map)input.readObject();
        in.close();
        return m;
    }

    protected void storeAttributes(Fqn fqn, Map attrs) throws Exception {
        File f = this.getDirectory(fqn, true);
        File child = new File(f, DATA);
        if (!child.exists()) {
            child.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(child);
        ObjectOutputStream output = new ObjectOutputStream(out);
        output.writeObject(attrs);
        out.close();
    }
}

