/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.util.Properties;
import org.jgroups.Address;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;

public class JGroupsTransport
implements Transport,
Runnable {
    Properties config = null;
    JChannel channel = null;
    Thread t = null;
    String props = null;
    String group_name = "PerfGroup";
    Receiver receiver = null;

    public Object getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public void create(Properties properties) throws Exception {
        this.config = properties;
        this.props = this.config.getProperty("props");
        this.channel = new JChannel(this.props);
    }

    public void start() throws Exception {
        this.channel.connect(this.group_name);
        this.t = new Thread((Runnable)this, "JGroupsTransport receiver thread");
        this.t.start();
    }

    public void stop() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        this.t = null;
    }

    public void destroy() {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public void send(Object destination, byte[] payload) throws Exception {
        Message msg = new Message((Address)destination, null, payload);
        this.channel.send(msg);
    }

    public void run() {
        while (this.t != null) {
            try {
                Object obj = this.channel.receive(0L);
                if (!(obj instanceof Message)) continue;
                Message msg = (Message)obj;
                Address sender = msg.getSrc();
                byte[] payload = msg.getBuffer();
                if (this.receiver == null) continue;
                try {
                    this.receiver.receive(sender, payload);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            catch (ChannelNotConnectedException e) {
                this.t = null;
            }
            catch (ChannelClosedException e) {
                this.t = null;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
    }
}

