/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.util;

import eu.medsea.util.InvalidMagicMimeEntryException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Vector;

public class MagicMimeEntry {
    public static final int STRING_TYPE = 1;
    public static final int BELONG_TYPE = 2;
    public static final int SHORT_TYPE = 3;
    public static final int LELONG_TYPE = 4;
    public static final int BESHORT_TYPE = 5;
    public static final int LESHORT_TYPE = 6;
    public static final int BYTE_TYPE = 7;
    public static final int UNKNOWN_TYPE = 20;
    private ArrayList subEntries = new ArrayList();
    int checkBytesFrom;
    int type;
    String typeStr;
    String content;
    String mimeType;
    String mimeEnc;
    MagicMimeEntry parent;
    boolean isBetween;

    public MagicMimeEntry(ArrayList entries) throws InvalidMagicMimeEntryException {
        this(0, null, entries);
    }

    private MagicMimeEntry(int level, MagicMimeEntry parent, ArrayList entries) throws InvalidMagicMimeEntryException {
        int thisLevel;
        if (entries == null || entries.size() == 0) {
            return;
        }
        try {
            this.addEntry((String)entries.get(0));
        }
        catch (Exception e) {
            throw new InvalidMagicMimeEntryException(entries);
        }
        entries.remove(0);
        this.parent = parent;
        if (parent != null) {
            parent.subEntries.add(this);
        }
        while (entries.size() > 0 && (thisLevel = this.howManyGreaterThans((String)entries.get(0))) > level) {
            new MagicMimeEntry(thisLevel, this, entries);
        }
    }

    public String toString() {
        return "MimeMagicType: " + this.checkBytesFrom + ", " + this.type + ", " + this.content + ", " + this.mimeType + ", " + this.mimeEnc;
    }

    public void traverseAndPrint(String tabs) {
        System.out.println(tabs + this.toString());
        int len = this.subEntries.size();
        for (int i = 0; i < len; ++i) {
            MagicMimeEntry me = (MagicMimeEntry)this.subEntries.get(i);
            me.traverseAndPrint(tabs + "\t");
        }
    }

    private int howManyGreaterThans(String aLine) {
        int i;
        if (aLine == null) {
            return -1;
        }
        int len = aLine.length();
        for (i = 0; i < len && aLine.charAt(i) == '>'; ++i) {
        }
        return i;
    }

    void addEntry(String aLine) {
        String trimmed = aLine.replaceAll("^>*", "");
        String[] tokens = trimmed.split("\t");
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < tokens.length; ++i) {
            if ("".equals(tokens[i])) continue;
            v.add(tokens[i]);
        }
        tokens = new String[v.size()];
        if ((tokens = v.toArray(tokens)).length > 0) {
            String tok = tokens[0].trim();
            try {
                this.checkBytesFrom = tok.startsWith("0x") ? Integer.parseInt(tok.substring(2), 16) : Integer.parseInt(tok);
            }
            catch (NumberFormatException e) {
                this.addEntry(trimmed.replaceAll("  ", "\t"));
                return;
            }
        }
        if (tokens.length > 1) {
            this.typeStr = tokens[1].trim();
            this.type = this.getType(this.typeStr);
        }
        if (tokens.length > 2) {
            this.content = this.ltrim(tokens[2]);
            this.content = MagicMimeEntry.stringWithEscapeSubstitutions(this.content);
        }
        if (tokens.length > 3) {
            this.mimeType = tokens[3].trim();
        }
        if (tokens.length > 4) {
            this.mimeEnc = tokens[4].trim();
        }
    }

    private String ltrim(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == ' ') continue;
            return s.substring(i);
        }
        return s;
    }

    private int getType(String tok) {
        if (tok.startsWith("string")) {
            return 1;
        }
        if (tok.startsWith("belong")) {
            return 2;
        }
        if (tok.equals("short")) {
            return 3;
        }
        if (tok.startsWith("lelong")) {
            return 4;
        }
        if (tok.startsWith("beshort")) {
            return 5;
        }
        if (tok.startsWith("leshort")) {
            return 6;
        }
        if (tok.equals("byte")) {
            return 7;
        }
        return 20;
    }

    public int getCheckBytesFrom() {
        return this.checkBytesFrom;
    }

    public int getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMatch(byte[] content) throws IOException {
        ByteBuffer buf = this.readBuffer(content);
        if (buf == null) {
            return null;
        }
        buf.position(0);
        boolean matches = this.match(buf);
        if (matches) {
            int subLen = this.subEntries.size();
            String myMimeType = this.getMimeType();
            if (subLen > 0) {
                String mtype = null;
                for (int k = 0; k < subLen; ++k) {
                    MagicMimeEntry me = (MagicMimeEntry)this.subEntries.get(k);
                    mtype = me.getMatch(content);
                    if (mtype == null) continue;
                    return mtype;
                }
                if (myMimeType != null) {
                    return myMimeType;
                }
            } else {
                return myMimeType;
            }
        }
        return null;
    }

    public String getMatch(RandomAccessFile raf) throws IOException {
        ByteBuffer buf = this.readBuffer(raf);
        if (buf == null) {
            return null;
        }
        boolean matches = this.match(buf);
        if (matches) {
            String myMimeType = this.getMimeType();
            if (this.subEntries.size() > 0) {
                String mtype = null;
                for (int i = 0; i < this.subEntries.size(); ++i) {
                    MagicMimeEntry me = (MagicMimeEntry)this.subEntries.get(i);
                    mtype = me.getMatch(raf);
                    if (mtype == null) continue;
                    return mtype;
                }
                if (myMimeType != null) {
                    return myMimeType;
                }
            } else {
                return myMimeType;
            }
        }
        return null;
    }

    private ByteBuffer readBuffer(byte[] content) throws IOException {
        ByteBuffer buf;
        int startPos = this.getCheckBytesFrom();
        if (startPos > content.length) {
            return null;
        }
        switch (this.getType()) {
            case 1: {
                int len = this.getContent().length();
                buf = ByteBuffer.allocate(len + 1);
                buf.put(content, startPos, len);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                buf = ByteBuffer.allocate(2);
                buf.put(content, startPos, 2);
                break;
            }
            case 2: 
            case 4: {
                buf = ByteBuffer.allocate(4);
                buf.put(content, startPos, 4);
                break;
            }
            case 7: {
                buf = ByteBuffer.allocate(1);
                buf.put(buf.array(), startPos, 1);
            }
            default: {
                buf = null;
            }
        }
        return buf;
    }

    private ByteBuffer readBuffer(RandomAccessFile raf) throws IOException {
        ByteBuffer buf;
        int startPos = this.getCheckBytesFrom();
        if ((long)startPos > raf.length()) {
            return null;
        }
        raf.seek(startPos);
        switch (this.getType()) {
            case 1: {
                int len = 0;
                int index = this.typeStr.indexOf(">");
                if (index != -1) {
                    len = Integer.parseInt(this.typeStr.substring(index + 1, this.typeStr.length() - 1));
                    this.isBetween = true;
                } else {
                    len = this.getContent().length();
                }
                buf = ByteBuffer.allocate(len + 1);
                raf.read(buf.array(), 0, len);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                buf = ByteBuffer.allocate(2);
                raf.read(buf.array(), 0, 2);
                break;
            }
            case 2: 
            case 4: {
                buf = ByteBuffer.allocate(4);
                raf.read(buf.array(), 0, 4);
                break;
            }
            case 7: {
                buf = ByteBuffer.allocate(1);
                raf.read(buf.array(), 0, 1);
            }
            default: {
                buf = null;
            }
        }
        return buf;
    }

    private boolean match(ByteBuffer buf) throws IOException {
        boolean matches = true;
        switch (this.getType()) {
            case 1: {
                matches = this.matchString(buf);
                break;
            }
            case 3: {
                matches = this.matchShort(buf, ByteOrder.BIG_ENDIAN, false, (short)255);
                break;
            }
            case 5: 
            case 6: {
                ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
                if (this.getType() == 6) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                boolean needMask = false;
                short sMask = 255;
                int indx = this.typeStr.indexOf(38);
                if (indx >= 0) {
                    sMask = (short)Integer.parseInt(this.typeStr.substring(indx + 3), 16);
                    needMask = true;
                } else if (this.getContent().startsWith("&")) {
                    sMask = (short)Integer.parseInt(this.getContent().substring(3), 16);
                    needMask = true;
                }
                matches = this.matchShort(buf, byteOrder, needMask, sMask);
                break;
            }
            case 2: 
            case 4: {
                ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
                if (this.getType() == 4) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                boolean needMask = false;
                long lMask = -1L;
                int indx = this.typeStr.indexOf(38);
                if (indx >= 0) {
                    lMask = Long.parseLong(this.typeStr.substring(indx + 3), 16);
                    needMask = true;
                } else if (this.getContent().startsWith("&")) {
                    lMask = Long.parseLong(this.getContent().substring(3), 16);
                    needMask = true;
                }
                matches = this.matchLong(buf, byteOrder, needMask, lMask);
                break;
            }
            case 7: {
                matches = this.matchByte(buf);
            }
            default: {
                matches = false;
            }
        }
        return matches;
    }

    private boolean matchString(ByteBuffer bbuf) throws IOException {
        if (this.isBetween) {
            String buffer = new String(bbuf.array());
            return buffer.contains(this.getContent());
        }
        int read = this.getContent().length();
        for (int j = 0; j < read; ++j) {
            if ((bbuf.get(j) & 0xFF) == this.getContent().charAt(j)) continue;
            return false;
        }
        return true;
    }

    private boolean matchByte(ByteBuffer bbuf) throws IOException {
        byte b = bbuf.get(0);
        return b == this.getContent().charAt(0);
    }

    private boolean matchShort(ByteBuffer bbuf, ByteOrder bo, boolean needMask, short sMask) throws IOException {
        bbuf.order(bo);
        String testContent = this.getContent();
        short got = testContent.startsWith("0x") ? (short)Integer.parseInt(testContent.substring(2), 16) : (testContent.startsWith("&") ? (short)Integer.parseInt(testContent.substring(3), 16) : (short)Integer.parseInt(testContent));
        short found = bbuf.getShort();
        if (needMask) {
            found = (short)(found & sMask);
        }
        return got == found;
    }

    private boolean matchLong(ByteBuffer bbuf, ByteOrder bo, boolean needMask, long lMask) throws IOException {
        bbuf.order(bo);
        String testContent = this.getContent();
        long got = testContent.startsWith("0x") ? Long.parseLong(testContent.substring(2), 16) : (testContent.startsWith("&") ? Long.parseLong(testContent.substring(3), 16) : Long.parseLong(testContent));
        long found = bbuf.getInt();
        if (needMask) {
            found = (short)(found & lMask);
        }
        return got == found;
    }

    private static String stringWithEscapeSubstitutions(String s) {
        char c;
        StringBuffer ret = new StringBuffer();
        int len = s.length();
        for (int indx = 0; indx < len && (c = s.charAt(indx)) != '\n'; ++indx) {
            if (c == '\\') {
                if (++indx >= len) {
                    ret.append(c);
                    break;
                }
                char cn = s.charAt(indx);
                if (cn == '\\') {
                    ret.append('\\');
                    continue;
                }
                if (cn == ' ') {
                    ret.append(' ');
                    continue;
                }
                if (cn == 't') {
                    ret.append('\t');
                    continue;
                }
                if (cn == 'n') {
                    ret.append('\n');
                    continue;
                }
                if (cn == 'r') {
                    ret.append('\r');
                    continue;
                }
                if (cn >= '0' && cn <= '7') {
                    int escape = cn - 48;
                    if (++indx >= len) {
                        ret.append((char)escape);
                        break;
                    }
                    cn = s.charAt(indx);
                    if (cn >= '0' && cn <= '7') {
                        escape <<= 3;
                        escape |= cn - 48;
                        if (++indx >= len) {
                            ret.append((char)escape);
                            break;
                        }
                        cn = s.charAt(indx);
                        if (cn >= '0' && cn <= '7') {
                            escape <<= 3;
                            escape |= cn - 48;
                        } else {
                            --indx;
                        }
                    } else {
                        --indx;
                    }
                    ret.append((char)escape);
                    continue;
                }
                ret.append(cn);
                continue;
            }
            ret.append(c);
        }
        return new String(ret);
    }
}

