/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.db.makumba.StalePreventionThread;

public abstract class ResourcePool {
    Stack<Object> stack = new Stack();
    Stack<Date> timeStack = new Stack();
    Vector<Object> all = new Vector();
    WeakReference<ResourcePool> poolRef = new WeakReference<ResourcePool>(this);
    long sleeping;
    long stale;
    Thread stalePreventionThread;

    public abstract Object create() throws Exception;

    Object createAndCount() throws Exception {
        Object o = this.create();
        this.all.addElement(o);
        Logger.getLogger("org.makumba.util.pool").fine("pool size: " + this.all.size());
        return o;
    }

    public void init(int n) throws Exception {
        while (n > 0) {
            this.put(this.createAndCount());
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws Exception {
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            if (this.stack.isEmpty()) {
                return this.createAndCount();
            }
            this.timeStack.pop();
            Logger.getLogger("org.makumba.util.pool.member").fine("pool members: " + this.timeStack.size());
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o) {
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            this.stack.push(o);
            this.timeStack.push(new Date());
            Logger.getLogger("org.makumba.util.pool.member").fine("pool members: " + this.timeStack.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.poolRef.clear();
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            if (this.stalePreventionThread != null) {
                this.stalePreventionThread.interrupt();
            }
            this.stack.clear();
            this.timeStack.clear();
            for (int i = 0; i < this.all.size(); ++i) {
                this.close(this.all.elementAt(i));
            }
            this.all.clear();
        }
    }

    protected void finalize() {
        this.close();
    }

    public void renew(Object o) {
    }

    public void close(Object o) {
    }

    public void startStalePreventionThread(long sleepingTime, long staleTime) {
        this.sleeping = sleepingTime;
        this.stale = staleTime;
        this.stalePreventionThread = new StalePreventionThread(this.poolRef, this.sleeping);
        this.stalePreventionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renewAll() {
        Stack<Object> stack = this.stack;
        synchronized (stack) {
            for (int i = 0; i < this.timeStack.size(); ++i) {
                if (((Date)this.timeStack.elementAt(i)).getTime() + this.stale >= new Date().getTime() + this.sleeping) continue;
                Logger.getLogger("org.makumba.util.pool").fine("renewing resource " + this.stack.elementAt(i) + " not used since " + this.timeStack.elementAt(i));
                this.renew(this.stack.elementAt(i));
                this.timeStack.setElementAt(new Date(), i);
            }
        }
    }

    public int getSize() {
        return this.stack.size();
    }
}

