/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.datadefinition.makumba;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.MakumbaSystem;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.ValidationRule;
import org.makumba.providers.datadefinition.makumba.FileRecordInfo;
import org.makumba.providers.datadefinition.makumba.RecordParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
implements Serializable,
FieldDefinition {
    private static final long serialVersionUID = 1L;
    DataDefinition dd;
    static final DualHashBidiMap integerTypeMap = new DualHashBidiMap();
    String name;
    String type;
    boolean fixed;
    boolean notNull;
    boolean unique;
    Object defaultValue;
    String description;
    Object extra1;
    Object extra2;
    Object extra3;
    private Hashtable<String, ValidationRule> validationRules = new Hashtable();
    static final Date emptyDate;
    static final Object emptyInt;
    static final Object emptyReal;

    @Override
    public DataDefinition getDataDefinition() {
        return this.dd;
    }

    public static FieldInfo getFieldInfo(String name, Object type, boolean typeSearch) {
        if (type instanceof FieldInfo) {
            return new FieldInfo(name, (FieldInfo)type);
        }
        String t = ((String)type).trim();
        if (!typeSearch || t.indexOf(" ") == -1) {
            return new FieldInfo(name, t);
        }
        t = name + "=" + t;
        return (FieldInfo)new RecordParser().parse(t).getFieldDefinition(name);
    }

    public static FieldInfo getFieldInfo(String name, Object type, boolean typeSearch, String description) {
        FieldInfo a = FieldInfo.getFieldInfo(name, type, typeSearch);
        a.description = description;
        return a;
    }

    public FieldInfo(DataDefinition ri, String name) {
        this.dd = ri;
        this.name = name;
    }

    public FieldInfo(FieldInfo fi) {
        this(fi.dd, fi.name);
        this.type = fi.type;
        this.fixed = fi.fixed;
        this.notNull = fi.notNull;
        this.unique = fi.unique;
        this.defaultValue = fi.defaultValue;
        this.description = fi.description;
    }

    public FieldInfo(String name, FieldInfo fi) {
        this.name = name;
        this.type = fi.type;
        this.fixed = fi.fixed;
        this.notNull = fi.notNull;
        this.unique = fi.unique;
        this.defaultValue = fi.defaultValue;
        this.description = fi.description;
        this.extra1 = fi.extra1;
        this.extra2 = fi.extra2;
        this.extra3 = fi.extra3;
        if (this.type.equals("ptrIndex")) {
            this.type = "ptr";
            this.extra1 = fi.getDataDefinition();
        }
        this.validationRules = fi.validationRules;
    }

    public FieldInfo(String name, String t) {
        try {
            this.name = name;
            this.type = t;
            this.fixed = false;
            this.notNull = false;
            this.unique = false;
            if (this.type.equals("char")) {
                this.extra2 = new Integer(255);
            } else if (this.type.startsWith("char")) {
                int n = this.type.indexOf("[");
                int m = this.type.indexOf("]");
                if (!this.type.endsWith("]") || this.type.substring(3, n).trim().length() > 1) {
                    throw new InvalidValueException("invalid char type " + this.type);
                }
                this.extra2 = new Integer(Integer.parseInt(this.type.substring(n + 1, m)));
                this.type = "char";
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new InvalidValueException("bad type " + this.type);
        }
        catch (NumberFormatException f) {
            throw new InvalidValueException("bad char[] size " + this.type);
        }
    }

    public static String getStringType(int integerType) {
        return (String)integerTypeMap.getKey((Object)new Integer(integerType));
    }

    @Override
    public boolean isAssignableFrom(FieldDefinition fi) {
        switch (this.getIntegerType()) {
            case 4: {
                return this.is_int_AssignableFrom(fi);
            }
            case 5: {
                return this.is_intEnum_AssignableFrom(fi);
            }
            case 0: 
            case 1: {
                return this.is_ptrRel_AssignableFrom(fi);
            }
            case 15: {
                return this.is_real_AssignableFrom(fi);
            }
            case 12: {
                return this.is_set_AssignableFrom(fi);
            }
        }
        return this.base_isAssignableFrom(fi);
    }

    public boolean base_isAssignableFrom(FieldDefinition fi) {
        return fi.getType().equals("nil") || this.getType().equals(fi.getType());
    }

    public boolean is_int_AssignableFrom(FieldDefinition fi) {
        return this.base_isAssignableFrom(fi) || fi.getType().equals("intEnum");
    }

    public boolean is_intEnum_AssignableFrom(FieldDefinition fi) {
        return this.is_int_AssignableFrom(fi) || fi.getType().equals("int") || fi.getType().equals("char");
    }

    public boolean is_ptrRel_AssignableFrom(FieldDefinition fi) {
        return "nil".equals(fi.getType()) || this.getType().equals(fi.getType()) && ((FieldInfo)fi).extra1 instanceof DataDefinition && ((DataDefinition)((FieldInfo)fi).extra1).getName().equals(this.getForeignTable().getName());
    }

    public boolean is_real_AssignableFrom(FieldDefinition fi) {
        return this.base_isAssignableFrom(fi) || fi.getType().equals("intEnum") || fi.getType().equals("int");
    }

    public boolean is_set_AssignableFrom(FieldDefinition fi) {
        return "nil".equals(fi.getType()) || this.getType().equals(fi.getType()) && this.getForeignTable().getName().equals(fi.getForeignTable().getName());
    }

    public String toString() {
        return this.getType();
    }

    @Override
    public Object checkValue(Object value) {
        switch (this.getIntegerType()) {
            case 17: {
                return this.check_setintEnum_Value(value);
            }
        }
        return this.base_checkValue(value);
    }

    public Object base_checkValue(Object value) {
        if (!value.equals(this.getNull())) {
            return this.checkValueImpl(value);
        }
        return value;
    }

    public Object check_setintEnum_Value(Object value) {
        try {
            Object o = this.getEnum().checkValue(value);
            Vector<Object> v = new Vector<Object>();
            if (o != null && o instanceof Integer) {
                v.addElement(o);
            }
            return v;
        }
        catch (InvalidValueException ive) {
            this.normalCheck(value);
            Vector v = (Vector)value;
            for (int i = 0; i < v.size(); ++i) {
                if (v.elementAt(i) == null || v.elementAt(i).equals(Pointer.NullInteger)) {
                    throw new InvalidValueException(this, "set members cannot be null");
                }
                v.setElementAt(this.getEnum().checkValue(v.elementAt(i)), i);
            }
            return v;
        }
    }

    @Override
    public void checkInsert(Dictionary d) {
        Object o = d.get(this.getName());
        if (this.isNotNull() && (o == null || o.equals(this.getNull()))) {
            throw new InvalidValueException(this, "A non-null value is needed for notnull fields");
        }
        if (o != null) {
            d.put(this.getName(), this.checkValue(o));
        }
    }

    @Override
    public void checkUpdate(Dictionary d) {
        Object o = d.get(this.getName());
        if (o == null) {
            return;
        }
        if (this.isFixed()) {
            throw new InvalidValueException(this, "You cannot update a fixed field");
        }
        d.put(this.getName(), this.checkValue(o));
    }

    @Override
    public Vector getDeprecatedValues() {
        switch (this.getIntegerType()) {
            case 5: {
                return this.get_intEnum_DeprecatedValues();
            }
        }
        return null;
    }

    public Vector get_intEnum_DeprecatedValues() {
        return (Vector)this.extra3;
    }

    @Override
    public Object getEmptyValue() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: 
            case 8: 
            case 18: {
                return "";
            }
            case 19: {
                return false;
            }
            case 9: 
            case 10: 
            case 11: {
                return emptyDate;
            }
            case 4: 
            case 5: {
                return emptyInt;
            }
            case 15: {
                return emptyReal;
            }
        }
        return null;
    }

    @Override
    public Object getNull() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return Pointer.NullString;
            }
            case 9: 
            case 10: 
            case 11: {
                return Pointer.NullDate;
            }
            case 4: 
            case 5: {
                return Pointer.NullInteger;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 13: {
                if (this.isFileType()) {
                    return Pointer.NullText;
                }
                return Pointer.Null;
            }
            case 15: {
                return Pointer.NullReal;
            }
            case 12: 
            case 16: 
            case 17: {
                return Pointer.NullSet;
            }
            case 8: 
            case 18: {
                return Pointer.NullText;
            }
            case 19: {
                return Pointer.NullBoolean;
            }
        }
        throw new RuntimeException("Unknown case handling for field type '" + this + "', integer type " + this.getIntegerType());
    }

    @Override
    public String getName() {
        return this.getDataName();
    }

    public final String getDataName() {
        return this.name;
    }

    @Override
    public boolean hasDescription() {
        return !this.description.equals(this.name);
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return this.name;
        }
        if (this.description.trim().equals("")) {
            return this.name;
        }
        return this.description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isIndexPointerField() {
        return this.getDataDefinition().getIndexPointerFieldName() == this.name;
    }

    @Override
    public int getIntegerType() {
        return (Integer)integerTypeMap.get((Object)this.getType());
    }

    @Override
    public String getDataType() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return "char";
            }
            case 9: {
                return "datetime";
            }
            case 10: 
            case 11: {
                return "timestamp";
            }
            case 4: 
            case 5: {
                return "int";
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "pointer";
            }
            case 15: {
                return "real";
            }
            case 12: {
                return "set";
            }
            case 16: {
                return "setchar";
            }
            case 13: {
                return "null";
            }
            case 17: {
                return "setint";
            }
            case 8: {
                return "text";
            }
            case 18: {
                return "binary";
            }
            case 19: {
                return "boolean";
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public Class<?> getJavaType() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return String.class;
            }
            case 9: 
            case 10: 
            case 11: {
                return Date.class;
            }
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return Pointer.class;
            }
            case 15: {
                return Double.class;
            }
            case 12: 
            case 16: 
            case 17: {
                return Vector.class;
            }
            case 13: {
                return null;
            }
            case 8: 
            case 18: {
                return Text.class;
            }
            case 19: {
                return Boolean.class;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return this.getEmptyValue();
        }
        return this.defaultValue;
    }

    @Override
    public Enumeration getValues() {
        switch (this.getIntegerType()) {
            case 5: 
            case 7: {
                return ((Vector)this.extra1).elements();
            }
            case 16: 
            case 17: {
                return ((Vector)this.getEnum().extra1).elements();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public Enumeration getNames() {
        switch (this.getIntegerType()) {
            case 5: 
            case 7: {
                return ((Vector)this.extra2).elements();
            }
            case 16: 
            case 17: {
                return ((Vector)this.getEnum().extra2).elements();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public int getEnumeratorSize() {
        switch (this.getIntegerType()) {
            case 5: 
            case 7: {
                return ((Vector)this.extra1).size();
            }
            case 16: 
            case 17: {
                return ((Vector)this.getEnum().extra1).size();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public String getStringAt(int i) {
        switch (this.getIntegerType()) {
            case 5: 
            case 7: {
                return ((Vector)this.extra1).elementAt(i).toString();
            }
            case 16: 
            case 17: {
                return ((Vector)this.getEnum().extra1).elementAt(i).toString();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public String getNameFor(int i) {
        switch (this.getIntegerType()) {
            case 5: {
                return this.get_intEnum_NameFor(i);
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String get_intEnum_NameFor(int n) {
        Vector names = (Vector)this.extra2;
        Vector values = (Vector)this.extra1;
        for (int i = 0; i < values.size(); ++i) {
            if (!values.elementAt(i).equals(new Integer(n))) continue;
            return (String)names.elementAt(i);
        }
        throw new InvalidValueException(this, "Can't find a name for " + n + " in " + values + " with names " + names);
    }

    @Override
    public String getNameAt(int i) {
        switch (this.getIntegerType()) {
            case 7: {
                return (String)((Vector)this.extra1).elementAt(i);
            }
            case 5: {
                return (String)((Vector)this.extra2).elementAt(i);
            }
            case 16: {
                return (String)((Vector)this.getEnum().extra1).elementAt(i);
            }
            case 17: {
                return (String)((Vector)this.getEnum().extra2).elementAt(i);
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public int getDefaultInt() {
        switch (this.getIntegerType()) {
            case 4: 
            case 5: {
                return (Integer)this.getDefaultValue();
            }
            case 17: {
                return (Integer)this.getEnum().defaultValue;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public int getIntAt(int i) {
        switch (this.getIntegerType()) {
            case 5: {
                return (Integer)((Vector)this.extra1).elementAt(i);
            }
            case 17: {
                return (Integer)((Vector)this.getEnum().extra1).elementAt(i);
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public String getDefaultString() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: 
            case 8: 
            case 18: {
                return (String)this.getDefaultValue();
            }
            case 16: {
                return (String)this.getEnum().defaultValue;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public int getWidth() {
        switch (this.getIntegerType()) {
            case 6: 
            case 7: {
                return (Integer)this.extra2;
            }
            case 16: {
                return (Integer)this.getEnum().extra2;
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public Object checkValueImpl(Object value) {
        switch (this.getIntegerType()) {
            case 6: {
                return this.check_char_ValueImpl(value);
            }
            case 7: {
                return this.check_charEnum_ValueImpl(value);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.check_date_ValueImpl(value);
            }
            case 4: {
                return this.check_int_ValueImpl(value);
            }
            case 5: {
                return this.check_intEnum_ValueImpl(value);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 17: {
                if (this.isFileType() && !(value instanceof Pointer)) {
                    return this.check_binary_ValueImpl(value);
                }
                return this.check_ptrIndex_ValueImpl(value);
            }
            case 15: {
                return this.check_real_ValueImpl(value);
            }
            case 12: {
                return this.check_set_ValueImpl(value);
            }
            case 16: {
                return this.check_setcharEnum_ValueImpl(value);
            }
            case 13: {
                return this.check_setComplex_ValueImpl(value);
            }
            case 8: {
                return this.check_text_ValueImpl(value);
            }
            case 18: 
            case 20: {
                return this.check_binary_ValueImpl(value);
            }
            case 19: {
                return this.check_boolean_ValueImpl(value);
            }
        }
        throw new RuntimeException("Unknown case handling for field type '" + this + "', integer type " + this.getIntegerType());
    }

    public Object check_char_ValueImpl(Object value) {
        this.normalCheck(value);
        String s = (String)value;
        if (s.length() > this.getWidth()) {
            throw new InvalidValueException(this, "String too long for char[] field. Maximum width: " + this.getWidth() + " given width " + s.length() + ".\n\tGiven value <" + s + ">");
        }
        return value;
    }

    public Object check_charEnum_ValueImpl(Object value) {
        this.check_char_ValueImpl(value);
        Vector names = (Vector)this.extra1;
        for (int i = 0; i < names.size(); ++i) {
            if (!names.elementAt(i).equals(value)) continue;
            return value;
        }
        throw new InvalidValueException(this, "value set to char enumerator (" + value + ") is not a member of " + names);
    }

    public Object check_date_ValueImpl(Object value) {
        return this.normalCheck(value);
    }

    public Object check_int_ValueImpl(Object value) {
        if (!(value instanceof Integer) && !(value instanceof Long)) {
            throw new InvalidValueException((FieldDefinition)this, this.getJavaType(), value);
        }
        if (value instanceof Integer) {
            return value;
        }
        return ((Long)value).intValue();
    }

    public Object check_intEnum_ValueImpl(Object value) {
        Vector names = (Vector)this.extra2;
        Vector values = (Vector)this.extra1;
        if (value instanceof Integer) {
            for (int i = 0; i < values.size(); ++i) {
                if (!values.elementAt(i).equals(value)) continue;
                return value;
            }
            throw new InvalidValueException(this, "int value set to int enumerator (" + value + ") is not a member of " + values);
        }
        if (!(value instanceof String)) {
            throw new InvalidValueException(this, "int enumerators only accept values of type Integer or String. Value supplied (" + value + ") is of type " + value.getClass().getName());
        }
        for (int i = 0; i < names.size(); ++i) {
            if (!names.elementAt(i).equals(value)) continue;
            return values.elementAt(i);
        }
        throw new InvalidValueException(this, "string value set to int enumerator (" + value + ") is neither a member of " + names + " nor amember of " + values);
    }

    public Object check_ptrIndex_ValueImpl(Object value) {
        if (value instanceof Pointer) {
            if (!((Pointer)value).getType().equals(this.getPointedType().getName())) {
                throw new InvalidValueException((FieldDefinition)this, this.getPointedType().getName(), (Pointer)value);
            }
            return value;
        }
        if (value instanceof String) {
            return new Pointer(this.getPointedType().getName(), (String)value);
        }
        throw new InvalidValueException(this, "Only java.lang.String and org.makumba.Pointer (or a java.util.Vector containing elements of those types) are assignable to makumba pointers, given value <" + value + "> is of type " + value.getClass().getName());
    }

    public Object check_real_ValueImpl(Object value) {
        if (value instanceof Integer) {
            return value;
        }
        return this.normalCheck(value);
    }

    public Object check_set_ValueImpl(Object value) {
        try {
            Object o = this.check_ptrIndex_ValueImpl(value);
            Vector<Object> v = new Vector<Object>();
            if (o != null && o instanceof Pointer) {
                v.addElement(o);
            }
            return v;
        }
        catch (InvalidValueException ive) {
            this.normalCheck(value);
            Vector v = (Vector)value;
            FieldDefinition ptr = this.getForeignTable().getFieldDefinition(this.getForeignTable().getIndexPointerFieldName());
            for (int i = 0; i < v.size(); ++i) {
                if (v.elementAt(i) == null || v.elementAt(i).equals(Pointer.Null)) {
                    throw new InvalidValueException(this, "set members cannot be null");
                }
                try {
                    v.setElementAt(ptr.checkValue(v.elementAt(i)), i);
                    continue;
                }
                catch (InvalidValueException e) {
                    throw new InvalidValueException(this, "the set member <" + v.elementAt(i) + "> is not assignable to pointers of type " + this.getForeignTable().getName());
                }
            }
            return v;
        }
    }

    public Object check_setcharEnum_ValueImpl(Object value) {
        try {
            Object o = this.getEnum().checkValue(value);
            Vector<Object> v = new Vector<Object>();
            if (o != null && o instanceof String) {
                v.addElement(o);
            }
            return v;
        }
        catch (InvalidValueException ive) {
            this.normalCheck(value);
            Vector v = (Vector)value;
            for (int i = 0; i < v.size(); ++i) {
                if (v.elementAt(i) == null || v.elementAt(i).equals(Pointer.NullString)) {
                    throw new InvalidValueException(this, "set members cannot be null");
                }
                v.setElementAt(this.getEnum().checkValue(v.elementAt(i)), i);
            }
            return v;
        }
    }

    public Object check_setComplex_ValueImpl(Object value) {
        throw new InvalidValueException(this, "subsets cannot be assigned directly");
    }

    public Object check_text_ValueImpl(Object value) {
        try {
            return Text.getText(value);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(this, e.getMessage());
        }
    }

    public Object check_binary_ValueImpl(Object value) {
        try {
            return Text.getText(value);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(this, e.getMessage());
        }
    }

    public Object check_boolean_ValueImpl(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        return this.normalCheck(value);
    }

    FieldInfo getEnum() {
        return (FieldInfo)((DataDefinition)this.extra1).getFieldDefinition("enum");
    }

    public DataDefinition get_ptrOne_Subtable() {
        return (DataDefinition)this.extra1;
    }

    @Override
    public Date getDefaultDate() {
        switch (this.getIntegerType()) {
            case 9: 
            case 10: 
            case 11: {
                return (Date)this.getDefaultValue();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    @Override
    public DataDefinition getForeignTable() {
        switch (this.getIntegerType()) {
            case 0: 
            case 1: {
                return this.get_ptrRel_ForeignTable();
            }
            case 12: {
                return this.get_set_ForeignTable();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public DataDefinition get_ptrRel_ForeignTable() {
        return (DataDefinition)this.extra1;
    }

    public DataDefinition get_set_ForeignTable() {
        if (this.extra3 == null) {
            return this.pointerToForeign().getForeignTable();
        }
        return (DataDefinition)this.extra3;
    }

    FieldDefinition pointerToForeign() {
        return this.getSubtable().getFieldDefinition(this.getSubtable().getFieldNames().elementAt(4));
    }

    @Override
    public DataDefinition getSubtable() {
        switch (this.getIntegerType()) {
            case 2: 
            case 13: 
            case 16: 
            case 17: 
            case 20: {
                return this.get_ptrOne_Subtable();
            }
            case 12: {
                return this.get_set_Subtable();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public DataDefinition get_set_Subtable() {
        return (DataDefinition)this.extra1;
    }

    @Override
    public DataDefinition getPointedType() {
        switch (this.getIntegerType()) {
            case 3: {
                return this.get_ptrIndex_PointedType();
            }
            case 2: 
            case 13: 
            case 16: 
            case 17: 
            case 20: {
                return this.get_ptrOne_PointedType();
            }
            case 0: 
            case 1: 
            case 12: {
                return this.get_ptrRel_PointedType();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public DataDefinition get_ptrIndex_PointedType() {
        return this.getDataDefinition();
    }

    public DataDefinition get_ptrOne_PointedType() {
        return this.getSubtable();
    }

    public DataDefinition get_ptrRel_PointedType() {
        return this.getForeignTable();
    }

    @Override
    public String getTitleField() {
        switch (this.getIntegerType()) {
            case 0: 
            case 12: {
                return this.get_ptr_TitleField();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public String get_ptr_TitleField() {
        if (this.hasTitleFieldIndicated()) {
            return (String)this.extra2;
        }
        return this.getForeignTable().getTitleFieldName();
    }

    @Override
    public boolean hasTitleFieldIndicated() {
        switch (this.getIntegerType()) {
            case 0: 
            case 12: {
                return this.has_ptr_TitleFieldIndicated();
            }
        }
        throw new RuntimeException("Shouldn't be here");
    }

    public boolean has_ptr_TitleFieldIndicated() {
        return this.extra2 != null;
    }

    protected Object normalCheck(Object value) {
        if (!this.getJavaType().isInstance(value)) {
            throw new InvalidValueException((FieldDefinition)this, this.getJavaType(), value);
        }
        return value;
    }

    @Override
    public boolean isDefaultField() {
        return this.getIntegerType() == 3 || this.getIntegerType() == 10 || this.getIntegerType() == 11;
    }

    @Override
    public boolean shouldEditBySingleInput() {
        return this.getIntegerType() != 2 && this.getIntegerType() != 13;
    }

    @Override
    public boolean isDateType() {
        return this.getIntegerType() == 9 || this.getIntegerType() == 10 || this.getIntegerType() == 11;
    }

    @Override
    public boolean isIntegerType() {
        return this.getIntegerType() == 4;
    }

    @Override
    public boolean isRealType() {
        return this.getIntegerType() == 15;
    }

    @Override
    public boolean isNumberType() {
        return this.isIntegerType() || this.isRealType();
    }

    @Override
    public boolean isBinaryType() {
        return this.getIntegerType() == 18;
    }

    @Override
    public boolean isFileType() {
        return this.extra1 != null && this.extra1 instanceof FileRecordInfo;
    }

    @Override
    public boolean isSetType() {
        return this.getIntegerType() == 12 || this.isInternalSet();
    }

    @Override
    public boolean isEnumType() {
        return this.getIntegerType() == 5 || this.getIntegerType() == 7;
    }

    @Override
    public boolean isSetEnumType() {
        return this.getIntegerType() == 17 || this.getIntegerType() == 16;
    }

    @Override
    public boolean isStringType() {
        return this.getIntegerType() == 6 || this.getIntegerType() == 8;
    }

    @Override
    public boolean isInternalSet() {
        return this.getIntegerType() == 13 || this.getIntegerType() == 17 || this.getIntegerType() == 16;
    }

    @Override
    public boolean isPointer() {
        return this.getIntegerType() == 0;
    }

    @Override
    public boolean isExternalSet() {
        return this.getIntegerType() == 12;
    }

    @Override
    public boolean isComplexSet() {
        return this.getIntegerType() == 13;
    }

    @Override
    public void addValidationRule(Collection<ValidationRule> rules) {
        if (rules != null) {
            Iterator<ValidationRule> iter = rules.iterator();
            while (iter.hasNext()) {
                this.addValidationRule(iter.next());
            }
        }
    }

    @Override
    public void addValidationRule(ValidationRule rule) {
        this.validationRules.put(rule.getRuleName(), rule);
    }

    @Override
    public Collection<ValidationRule> getValidationRules() {
        ArrayList<ValidationRule> arrayList = new ArrayList<ValidationRule>(this.validationRules.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    static {
        integerTypeMap.put((Object)"ptr", (Object)new Integer(0));
        integerTypeMap.put((Object)"ptrRel", (Object)new Integer(1));
        integerTypeMap.put((Object)"ptrOne", (Object)new Integer(2));
        integerTypeMap.put((Object)"ptrIndex", (Object)new Integer(3));
        integerTypeMap.put((Object)"int", (Object)new Integer(4));
        integerTypeMap.put((Object)"intEnum", (Object)new Integer(5));
        integerTypeMap.put((Object)"char", (Object)new Integer(6));
        integerTypeMap.put((Object)"charEnum", (Object)new Integer(7));
        integerTypeMap.put((Object)"text", (Object)new Integer(8));
        integerTypeMap.put((Object)"binary", (Object)new Integer(18));
        integerTypeMap.put((Object)"boolean", (Object)new Integer(19));
        integerTypeMap.put((Object)"date", (Object)new Integer(9));
        integerTypeMap.put((Object)"dateCreate", (Object)new Integer(10));
        integerTypeMap.put((Object)"dateModify", (Object)new Integer(11));
        integerTypeMap.put((Object)"file", (Object)new Integer(20));
        integerTypeMap.put((Object)"set", (Object)new Integer(12));
        integerTypeMap.put((Object)"setComplex", (Object)new Integer(13));
        integerTypeMap.put((Object)"nil", (Object)new Integer(14));
        integerTypeMap.put((Object)"real", (Object)new Integer(15));
        integerTypeMap.put((Object)"setcharEnum", (Object)new Integer(16));
        integerTypeMap.put((Object)"setintEnum", (Object)new Integer(17));
        GregorianCalendar c = new GregorianCalendar(MakumbaSystem.getTimeZone());
        c.clear();
        c.set(1900, 0, 1);
        emptyDate = c.getTime();
        emptyInt = new Integer(0);
        emptyReal = new Double(0.0);
    }
}

