/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy.servlet.jsp.tagext;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.LogFactory;
import org.w3c.tidy.servlet.RepositoryFactory;
import org.w3c.tidy.servlet.jsp.tagext.LinkTag;
import org.w3c.tidy.servlet.properties.JTidyServletProperties;
import org.w3c.tidy.servlet.util.HTMLEncode;

public class ValidationImageTag
extends TagSupport {
    private static final long serialVersionUID = 29137L;
    private boolean srcOnly;
    private String requestID;
    private String imgName;
    private String onclick;

    public int doEndTag() throws JspException {
        if (this.pageContext.getAttribute("JTidyIgnore") == null) {
            try {
                String out = null;
                String requestID = this.requestID;
                JTidyServletProperties properties = JTidyServletProperties.getInstance();
                if (requestID == null || requestID.equalsIgnoreCase("this")) {
                    RepositoryFactory factory = properties.getRepositoryFactoryInstance();
                    Object key = factory.getResponseID(this.pageContext.getSession(), (HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse(), false);
                    requestID = key.toString();
                }
                out = this.srcOnly ? LinkTag.getImageLink(requestID, (HttpServletRequest)this.pageContext.getRequest()) : ValidationImageTag.getImageHTML(requestID, this.imgName, this.onclick, (HttpServletRequest)this.pageContext.getRequest());
                this.pageContext.getOut().write(out);
            }
            catch (IOException e) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"ValidationImageTag write error", (Throwable)e);
                throw new JspException(e.getMessage());
            }
        }
        return 6;
    }

    public static String getImageHTML(String requestID, String imgName, String onclick, HttpServletRequest request) {
        StringBuffer out = new StringBuffer(120);
        JTidyServletProperties properties = JTidyServletProperties.getInstance();
        String servletURI = request.getContextPath() + properties.getProperty("JTidyServletURI", "/JTidy");
        if (imgName == null) {
            imgName = "JTidyValidationImage";
        }
        out.append("<a name=\"");
        out.append(imgName);
        out.append("Link\" ");
        out.append("id=\"");
        out.append(imgName);
        out.append("Link\" href=\"");
        out.append(HTMLEncode.encodeHREFQuery(servletURI, new String[]{"requestID", requestID, "action", "report", "src", "1"}));
        out.append("\" ");
        if (onclick != null && onclick.length() > 0) {
            out.append("onclick=\"").append(onclick).append("\"");
        }
        out.append(">");
        out.append("<img name=\"");
        out.append(imgName);
        out.append("\" id=\"");
        out.append(imgName);
        out.append("\" alt=\"Page Validation\" ");
        out.append("src=\"");
        out.append(LinkTag.getImageLink(requestID, request));
        out.append("\" width=\"").append(properties.getProperty("imageWidth", "32"));
        out.append("\" height=\"").append(properties.getProperty("imageHeight", "26"));
        out.append("\" ");
        if (properties.getBooleanProperty("xhtml", true)) {
            out.append("/");
        }
        out.append("></a>");
        return out.toString();
    }

    public void release() {
        super.release();
        this.srcOnly = false;
        this.requestID = null;
        this.onclick = null;
        this.imgName = null;
    }

    public void setSrcOnly(boolean srcOnly) {
        this.srcOnly = srcOnly;
    }

    public void setRequestID(String requestID) {
        this.requestID = requestID;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public void setImgName(String imgName) {
        this.imgName = imgName;
    }
}

