/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons.attributes;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.makumba.AttributeNotFoundException;
import org.makumba.Attributes;
import org.makumba.LogicException;
import org.makumba.Pointer;
import org.makumba.Text;
import org.makumba.UnauthenticatedException;
import org.makumba.UnauthorizedException;
import org.makumba.commons.DbConnectionProvider;
import org.makumba.commons.attributes.HttpParameters;
import org.makumba.commons.attributes.MultipartHttpParameters;
import org.makumba.controller.Logic;
import org.makumba.providers.TransactionProvider;

public class RequestAttributes
implements Attributes {
    public static final String PARAMETERS_NAME = "makumba.parameters";
    public static final String ATTRIBUTES_NAME = "makumba.attributes";
    public static final String CONTROLLER_NAME = "makumba.controller";
    HttpServletRequest request;
    Object controller;
    private TransactionProvider tp;
    public static final String PROVIDER_ATTRIBUTE = "org.makumba.providerAttribute";
    public static final Object notFound = "not found";

    public String getRequestDatabase() {
        return this.tp.getDefaultDataSourceName();
    }

    public Object getRequestController() {
        return this.controller;
    }

    public static RequestAttributes getAttributes(HttpServletRequest req) throws LogicException {
        if (req.getAttribute(ATTRIBUTES_NAME) == null) {
            req.setAttribute(ATTRIBUTES_NAME, (Object)new RequestAttributes(req));
        }
        return (RequestAttributes)req.getAttribute(ATTRIBUTES_NAME);
    }

    RequestAttributes(HttpServletRequest req) throws LogicException {
        this(Logic.getLogic(req.getServletPath()), req, null);
    }

    public RequestAttributes(Object controller, HttpServletRequest req, String db) throws LogicException {
        block4: {
            this.tp = TransactionProvider.getInstance();
            if (db == null) {
                db = this.getRequestDatabase();
            }
            this.request = req;
            this.controller = controller;
            if (req.getAttribute(CONTROLLER_NAME + controller.getClass().getName()) == null) {
                req.setAttribute(CONTROLLER_NAME + controller.getClass().getName(), controller);
                try {
                    RequestAttributes.getConnectionProvider(req).setContext(this);
                    RequestAttributes.getConnectionProvider(req).setTransactionProvider(Logic.getTransactionProvider(controller));
                    Logic.doInit(req.getServletPath(), (Attributes)this, db, RequestAttributes.getConnectionProvider(req));
                    Logic.doInit(controller, (Attributes)this, db, RequestAttributes.getConnectionProvider(req));
                }
                catch (UnauthorizedException e) {
                    if (req.getServletPath().endsWith("login.jsp")) break block4;
                    throw e;
                }
            }
        }
    }

    public static DbConnectionProvider getConnectionProvider(HttpServletRequest req) {
        DbConnectionProvider prov = (DbConnectionProvider)req.getAttribute(PROVIDER_ATTRIBUTE);
        if (prov == null) {
            prov = new DbConnectionProvider();
            req.setAttribute(PROVIDER_ATTRIBUTE, (Object)prov);
        }
        return prov;
    }

    public static HttpParameters getParameters(HttpServletRequest req) {
        if (req.getAttribute(PARAMETERS_NAME) == null) {
            req.setAttribute(PARAMETERS_NAME, (Object)RequestAttributes.makeParameters(req));
        }
        return (HttpParameters)req.getAttribute(PARAMETERS_NAME);
    }

    public static HttpParameters makeParameters(HttpServletRequest req) {
        if (req.getContentType() != null && req.getContentType().indexOf("multipart") != -1) {
            return new MultipartHttpParameters(req);
        }
        return new HttpParameters(req);
    }

    public static void setAttribute(HttpServletRequest req, String var, Object o) {
        if (o != null) {
            req.setAttribute(var, o);
            req.removeAttribute(var + "_null");
        } else {
            req.removeAttribute(var);
            req.setAttribute(var + "_null", (Object)"null");
        }
    }

    public Object setAttribute(String s, Object o) {
        String snull = s + "_null";
        HttpSession ss = this.request.getSession(true);
        Object value = ss.getAttribute(s);
        ss.setAttribute(s, o);
        if (o == null) {
            ss.setAttribute(snull, (Object)"null");
        } else {
            ss.removeAttribute(snull);
        }
        return value;
    }

    public void removeAttribute(String s) throws LogicException {
        this.request.getSession(true).removeAttribute(s);
    }

    public boolean hasAttribute(String s) {
        try {
            return this.checkSessionForAttribute(s) != notFound || this.checkServletLoginForAttribute(s) != notFound || this.checkLogicForAttribute(s) != notFound || this.checkParameterForAttribute(s) != notFound;
        }
        catch (LogicException e) {
            return false;
        }
    }

    public String toString() {
        String s = "Makumba Atributes:\n";
        s = s + "\tSession: {";
        HttpSession ss = this.request.getSession(true);
        Enumeration enumSession = ss.getAttributeNames();
        while (enumSession.hasMoreElements()) {
            String key = (String)enumSession.nextElement();
            s = s + key + "=";
            Object value = ss.getAttribute(key);
            s = this.printElement(s, value);
            if (!enumSession.hasMoreElements()) continue;
            s = s + ", ";
        }
        s = s + "}\n";
        Enumeration enumRequest = this.request.getAttributeNames();
        s = s + "\tRequest: {";
        while (enumRequest.hasMoreElements()) {
            String key = (String)enumRequest.nextElement();
            s = s + key + "=";
            Object value = this.request.getAttribute(key);
            s = this.printElement(s, value);
            if (!enumRequest.hasMoreElements()) continue;
            s = s + ", ";
        }
        s = s + "}\n";
        Enumeration enumParams = this.request.getParameterNames();
        s = s + "\tParameters: {";
        while (enumParams.hasMoreElements()) {
            String key = (String)enumParams.nextElement();
            s = s + key + "=" + this.request.getParameter(key);
            if (!enumParams.hasMoreElements()) continue;
            s = s + ", ";
        }
        s = s + "}";
        return s;
    }

    private String printElement(String s, Object value) {
        s = value instanceof RequestAttributes ? s + value.getClass() : (value instanceof Text ? s + ((Text)value).toShortString(100) : s + value);
        return s;
    }

    public Object getAttribute(String s) throws LogicException {
        Object o = this.checkSessionForAttribute(s);
        if (o != notFound) {
            return o;
        }
        o = this.checkServletLoginForAttribute(s);
        if (o != notFound) {
            return o;
        }
        o = this.checkLogicForAttribute(s);
        if (o != notFound) {
            return o;
        }
        o = this.checkParameterForAttribute(s);
        if (o != notFound) {
            return o;
        }
        throw new AttributeNotFoundException(s, true);
    }

    public Object checkSessionForAttribute(String s) {
        String snull = s + "_null";
        HttpSession ss = this.request.getSession(true);
        Object value = ss.getAttribute(s);
        if (value != null) {
            return value;
        }
        if (ss.getAttribute(snull) != null) {
            return null;
        }
        value = this.request.getAttribute(s);
        if (value != null) {
            return value;
        }
        if (this.request.getAttribute(snull) != null) {
            return null;
        }
        return notFound;
    }

    public Object checkServletLoginForAttribute(String s) {
        if (this.request.getRemoteUser() != null && this.request.isUserInRole(s)) {
            this.request.getSession(true).setAttribute(s, (Object)this.request.getRemoteUser());
            return this.request.getRemoteUser();
        }
        return notFound;
    }

    public Object checkLogicForAttribute(String s) throws LogicException {
        HttpSession ss = this.request.getSession(true);
        boolean nullValue = false;
        Object value = null;
        try {
            value = Logic.getAttribute(this.getRequestController(), s, this, this.getRequestDatabase(), RequestAttributes.getConnectionProvider(this.request));
            if (value instanceof Map) {
                Map mp = (Map)value;
                value = mp.get(s);
                for (Map.Entry entr : mp.entrySet()) {
                    if (((String)entr.getKey()).equals(s)) {
                        value = entr.getValue();
                    }
                    if (entr.getValue() == Pointer.Null) {
                        this.removeFromSession((String)entr.getKey(), ss);
                        continue;
                    }
                    ss.setAttribute((String)entr.getKey(), entr.getValue());
                }
            }
            if (value == null || value == Pointer.Null) {
                nullValue = true;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (UnauthenticatedException ue) {
            ue.setAttributeName(s);
            throw ue;
        }
        if (value != null) {
            ss.setAttribute(s, value);
            return value;
        }
        if (nullValue) {
            this.removeFromSession(s, ss);
            return null;
        }
        return notFound;
    }

    private void removeFromSession(String s, HttpSession ss) {
        String snull = s + "_null";
        ss.removeAttribute(s);
        ss.setAttribute(snull, (Object)"x");
    }

    public Object checkParameterForAttribute(String s) {
        Object value = RequestAttributes.getParameters(this.request).getParameter(s);
        if (value != null) {
            return value;
        }
        return notFound;
    }

    public Map toMap() {
        String attrName;
        HttpSession ss = this.request.getSession(true);
        Enumeration enumSession = ss.getAttributeNames();
        Enumeration enumRequest = this.request.getAttributeNames();
        Enumeration enumParams = this.request.getParameterNames();
        HashMap<String, Object> allAttributes = new HashMap<String, Object>();
        while (enumSession.hasMoreElements()) {
            attrName = (String)enumSession.nextElement();
            allAttributes.put(attrName, ss.getAttribute(attrName));
        }
        while (enumRequest.hasMoreElements()) {
            attrName = (String)enumRequest.nextElement();
            allAttributes.put(attrName, ss.getAttribute(attrName));
        }
        while (enumParams.hasMoreElements()) {
            attrName = (String)enumParams.nextElement();
            allAttributes.put(attrName, ss.getAttribute(attrName));
        }
        return allAttributes;
    }
}

