/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.list.engine.valuecomputer;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.makumba.FieldDefinition;
import org.makumba.LogicException;
import org.makumba.analyser.AnalysableTag;
import org.makumba.analyser.PageCache;
import org.makumba.commons.MultipleKey;
import org.makumba.commons.attributes.PageAttributes;
import org.makumba.list.engine.ComposedQuery;
import org.makumba.list.engine.QueryExecution;
import org.makumba.list.engine.valuecomputer.NullableValueComputer;
import org.makumba.list.engine.valuecomputer.SetValueComputer;
import org.makumba.list.html.RecordViewer;
import org.makumba.list.tags.QueryTag;
import org.makumba.list.tags.ValueTag;

public class ValueComputer {
    MultipleKey parentKey;
    int projectionIndex;
    String expr;
    protected FieldDefinition type;

    public static ValueComputer getValueComputerAtAnalysis(AnalysableTag analyzed, MultipleKey parentListKey, String expr, PageCache pageCache) {
        expr = expr.trim();
        Object check = QueryTag.getQuery(pageCache, parentListKey).checkExprSetOrNullable(expr);
        FieldDefinition set = null;
        String nullableExpr = null;
        if (check instanceof String) {
            nullableExpr = (String)check;
        }
        if (check instanceof FieldDefinition) {
            set = (FieldDefinition)check;
        }
        if (nullableExpr == null && set == null) {
            return new ValueComputer(analyzed, parentListKey, expr, pageCache);
        }
        if (set == null) {
            return new NullableValueComputer(analyzed, parentListKey, nullableExpr, expr, pageCache);
        }
        return new SetValueComputer(analyzed, parentListKey, set, expr, pageCache);
    }

    ValueComputer() {
    }

    ValueComputer(MultipleKey listKey, String expr, PageCache pageCache) {
        this.parentKey = listKey;
        this.expr = expr;
        QueryTag.getQuery(pageCache, this.parentKey).checkProjectionInteger(expr);
    }

    ValueComputer(AnalysableTag analyzed, MultipleKey parentListKey, String expr, PageCache pageCache) {
        this(parentListKey, expr, pageCache);
    }

    MultipleKey getQueryKey() {
        return this.parentKey;
    }

    public void doEndAnalyze(PageCache pageCache) {
        ComposedQuery q = QueryTag.getQuery(pageCache, this.getQueryKey());
        this.projectionIndex = q.checkProjectionInteger(this.expr);
        if (this.type == null) {
            this.type = q.getResultType().getFieldDefinition(this.projectionIndex);
        }
    }

    public Object getValue(PageContext pc) throws LogicException {
        return QueryExecution.getFor((MultipleKey)this.getQueryKey(), (PageContext)pc, null, null).currentListData().data[this.projectionIndex];
    }

    public void print(ValueTag running, PageCache pageCache) throws JspException, LogicException {
        Object o = this.getValue(running.getPageContext());
        String s = null;
        if (running.getPrintVar() != null || running.getVar() == null) {
            s = ((RecordViewer)pageCache.retrieve("org.makumba.formatters", this.getQueryKey())).format(this.projectionIndex, o, running.getParams());
        }
        if (running.getVar() != null) {
            PageAttributes.setAttribute(running.getPageContext(), running.getVar(), o);
        }
        if (running.getPrintVar() != null) {
            running.getPageContext().setAttribute(running.getPrintVar(), (Object)s);
        }
        if (running.getPrintVar() == null && running.getVar() == null) {
            try {
                running.getPageContext().getOut().print(s);
            }
            catch (Exception e) {
                throw new JspException(e.toString());
            }
        }
    }

    public String getFormattedValue(ValueTag running, PageCache pageCache) throws JspException, LogicException {
        Object o = this.getValue(running.getPageContext());
        String s = null;
        if (running.getPrintVar() != null || running.getVar() == null) {
            s = ((RecordViewer)pageCache.retrieve("org.makumba.formatters", this.getQueryKey())).format(this.projectionIndex, o, running.getParams());
        }
        return s;
    }

    public FieldDefinition getType() {
        return this.type;
    }

    public static boolean isPointer(PageCache pageCache, MultipleKey parentListKey, String expr) {
        ComposedQuery cq = QueryTag.getQuery(pageCache, parentListKey);
        if (cq.checkExprSetOrNullable(expr) instanceof FieldDefinition) {
            return false;
        }
        return cq.qep.getQueryAnalysis("SELECT " + expr + " FROM " + cq.getFromSection()).getProjectionType().getFieldDefinition(0).getType().equals("ptr");
    }
}

