/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.CommonAST;
import antlr.SemanticException;
import antlr.collections.AST;
import java.util.HashSet;
import org.apache.commons.collections.CollectionUtils;
import org.makumba.FieldDefinition;
import org.makumba.InvalidValueException;
import org.makumba.Pointer;
import org.makumba.commons.NameResolver;
import org.makumba.providers.query.mql.MqlSqlWalker;

public class MqlNode
extends CommonAST {
    NameResolver.TextList text;
    MqlSqlWalker walker;
    private MqlNode father;
    private FieldDefinition makType;
    private String originalText;
    public static String[] simpleStringFunctions = new String[]{"lower", "upper", "trim", "rtrim", "ltrim"};
    public static String[] intToStringFunctions = new String[]{"char"};
    public static String[] stringToIntFunctions = new String[]{"ascii", "character_length"};
    public static String[] dateToIntFunctions = new String[]{"dayOfMonth", "dayOfWeek", "dayOfYear", "month", "hour", "minute(", "second("};
    public static String[] dateToStringFunctions = new String[]{"monthName", "dayName"};
    public static String[] nonParametricDateFunctions = new String[]{"current_date", "current_time", "current_timestamp"};
    public static HashSet<String> stringFunctions = new HashSet();
    public static HashSet<String> intFunctions = new HashSet();
    public static HashSet<String> dateFunctions = new HashSet();

    protected MqlSqlWalker getWalker() {
        return this.walker;
    }

    protected void setWalker(MqlSqlWalker walker) {
        this.walker = walker;
    }

    public void setFather(MqlNode node) {
        this.father = node;
    }

    public void setFirstChild(AST a) {
        super.setFirstChild(a);
        if (a != null) {
            ((MqlNode)a).setFather(this);
            this.oneMoreChild((MqlNode)a);
        }
    }

    public void setNextSibling(AST a) {
        super.setNextSibling(a);
        if (this.father != null) {
            this.father.oneMoreChild((MqlNode)a);
        }
    }

    protected void oneMoreChild(MqlNode child) {
        FieldDefinition tp = this.findMakType(child);
        if (tp != null) {
            this.makType = tp;
        }
        if ((this.getType() == 26 || this.getType() == 80) && child.getType() == 74) {
            MqlNode inListMember = (MqlNode)child.getFirstChild();
            do {
                if (inListMember.getType() == 142) {
                    this.walker.setParameterType(inListMember, (MqlNode)this.getFirstChild());
                    continue;
                }
                try {
                    this.checkAndRewriteOperand((MqlNode)this.getFirstChild(), inListMember);
                }
                catch (SemanticException e) {
                    this.walker.error = e;
                    return;
                }
            } while ((inListMember = (MqlNode)inListMember.getNextSibling()) != null);
        }
    }

    protected FieldDefinition findMakType(MqlNode child) {
        switch (this.getType()) {
            case 78: {
                return this.getFunctionType(child);
            }
            case 68: 
            case 87: 
            case 88: {
                return child.getMakType();
            }
            case 54: {
                if (child.getType() != 57) break;
                return ((MqlNode)child.getFirstChild()).getMakType();
            }
        }
        return null;
    }

    private FieldDefinition getFunctionType(MqlNode child) {
        String type = null;
        String name = child.getText();
        if (dateFunctions.contains(name)) {
            type = "date";
        }
        if (intFunctions.contains(name)) {
            type = "int";
        }
        if (stringFunctions.contains(name)) {
            type = "char[255]";
        }
        if (type != null) {
            child.setType(141);
            return this.walker.currentContext.ddp.makeFieldDefinition("x", type);
        }
        return null;
    }

    protected void setMakType(FieldDefinition fd) {
        if (fd.getType().equals("ptrIndex")) {
            fd = this.walker.currentContext.ddp.makeFieldDefinition("x", "ptr " + fd.getPointedType().getName());
        }
        this.makType = fd;
    }

    protected FieldDefinition getMakType() {
        return this.makType;
    }

    public void setText(String text) {
        super.setText(text);
        if (this.originalText == null && text.length() > 0) {
            this.originalText = text;
        }
    }

    public void setType(int type) {
        super.setType(type);
        String def = this.knownType();
        if (def != null) {
            this.setMakType(this.walker.currentContext.ddp.makeFieldDefinition("x", def));
        }
    }

    String knownType() {
        switch (this.getType()) {
            case 12: 
            case 94: 
            case 118: {
                return "int";
            }
            case 92: 
            case 93: {
                return "real";
            }
            case 6: 
            case 19: 
            case 20: 
            case 26: 
            case 38: 
            case 40: 
            case 49: 
            case 76: 
            case 77: {
                return "boolean";
            }
            case 119: {
                return "char[255]";
            }
        }
        return null;
    }

    protected void checkForOperandType(MqlNode ast) {
        if (!ast.isParam() && ast.getMakType() == null) {
            throw new IllegalStateException("No makumba type computed for " + MqlSqlWalker.printer.showAsString((AST)ast, ""));
        }
    }

    boolean isParam() {
        return this.getType() == 142 || this.getType() == 117;
    }

    void checkOperandTypes(MqlNode left, MqlNode right) throws SemanticException {
        if (!(left.isParam() && left.getMakType() == null || right.getMakType().isAssignableFrom(left.getMakType()) || right.getMakType().isNumberType() && left.getMakType().isNumberType())) {
            throw new SemanticException("incompatible operands " + left.getText() + "(" + left.getMakType() + ") and " + right.getText() + " (" + right.getMakType() + ")");
        }
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void writeTo(NameResolver.TextList t) {
        if (this.text == null) {
            t.append(this.getText());
        } else {
            t.append(this.text);
        }
    }

    public String getText() {
        if (this.text != null) {
            return this.text.toString();
        }
        return super.getText();
    }

    public void setTextList(NameResolver.TextList tl) {
        this.text = tl;
    }

    protected boolean checkAndRewriteOperand(MqlNode left, MqlNode right) throws SemanticException {
        if (right.getType() == 119 && !left.isParam()) {
            String s = right.getText();
            String arg1 = s.substring(1, s.length() - 1);
            if (arg1.length() > 0) {
                Object o = null;
                try {
                    o = left.getMakType().checkValue(arg1);
                }
                catch (InvalidValueException e) {
                    throw new SemanticException(e.getMessage());
                }
                if (o instanceof Pointer) {
                    o = new Long(((Pointer)o).longValue());
                }
                if (o instanceof Number) {
                    right.setText(o.toString());
                } else {
                    right.setText("'" + o + "'");
                }
            }
            return true;
        }
        this.checkOperandTypes(left, right);
        return false;
    }

    static {
        CollectionUtils.addAll(stringFunctions, (Object[])simpleStringFunctions);
        CollectionUtils.addAll(stringFunctions, (Object[])intToStringFunctions);
        CollectionUtils.addAll(stringFunctions, (Object[])dateToStringFunctions);
        CollectionUtils.addAll(intFunctions, (Object[])stringToIntFunctions);
        CollectionUtils.addAll(intFunctions, (Object[])dateToIntFunctions);
        CollectionUtils.addAll(dateFunctions, (Object[])nonParametricDateFunctions);
    }
}

