/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.ANTLRException;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.OQLParseError;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.RuntimeWrappedException;
import org.makumba.providers.QueryAnalysis;
import org.makumba.providers.QueryAnalysisProvider;
import org.makumba.providers.query.mql.MqlQueryAnalysis;

public class MqlQueryAnalysisProvider
extends QueryAnalysisProvider {
    public static int parsedQueries = NamedResources.makeStaticCache("MQL parsed queries", new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        protected Object makeResource(Object nm, Object hashName) throws Exception {
            return new MqlQueryAnalysis((String)nm);
        }
    }, true);

    public QueryAnalysis getRawQueryAnalysis(String query) {
        try {
            return (QueryAnalysis)NamedResources.getStaticCache(parsedQueries).getResource(query);
        }
        catch (RuntimeWrappedException e) {
            if (e.getCause() instanceof ANTLRException) {
                ANTLRException f = (ANTLRException)e.getCause();
                String s = f.getMessage();
                if (s.startsWith("line")) {
                    s = s.substring(s.indexOf(58) + 1);
                }
                throw new OQLParseError(s + "\r\nin query:\r\n" + query, f);
            }
            throw e;
        }
    }

    public boolean selectGroupOrOrderAsLabels() {
        return true;
    }

    public FieldDefinition getAlternativeField(DataDefinition dd, String fn) {
        return null;
    }

    public String getPrimaryKeyNotation(String label) {
        return label;
    }

    public String getParameterSyntax() {
        return "$";
    }
}

