/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.providers.query.mql;

import antlr.ASTFactory;
import antlr.SemanticException;
import antlr.collections.AST;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hibernate.hql.ast.util.ASTUtil;
import org.makumba.DataDefinition;
import org.makumba.DataDefinitionNotFoundError;
import org.makumba.DataDefinitionParseError;
import org.makumba.FieldDefinition;
import org.makumba.commons.NameResolver;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.query.mql.MqlNode;
import org.makumba.providers.query.mql.MqlSqlWalker;

public class QueryContext {
    DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    private QueryContext parent;
    MqlSqlWalker walker;
    MqlNode inTree = null;
    Hashtable<String, DataDefinition> labels = new Hashtable();
    Hashtable<String, DataDefinition> fromLabels = new Hashtable();
    Hashtable<String, String> aliases = new Hashtable();
    Vector<Join> joins = new Vector();
    Hashtable<String, String> joinNames = new Hashtable();
    Hashtable<String, AST> projectionLabelSearch = new Hashtable();

    public QueryContext(MqlSqlWalker mqlSqlWalker) {
        this.walker = mqlSqlWalker;
    }

    public void setParent(QueryContext currentContext) {
        this.parent = currentContext;
    }

    public QueryContext getParent() {
        return this.parent;
    }

    public AST createFromElement(String path, AST alias, int joinType) throws SemanticException {
        this.addFrom(path, alias.getText(), joinType);
        if (this.inTree == null) {
            this.inTree = (MqlNode)ASTUtil.create((ASTFactory)this.walker.fact, (int)128, (String)"");
            return this.inTree;
        }
        return null;
    }

    public void close() {
        if (this.inTree != null) {
            this.inTree.setTextList(this.getFrom());
        }
    }

    private NameResolver.TextList getFrom() {
        NameResolver.TextList tl = new NameResolver.TextList();
        this.writeFrom(tl);
        this.writeJoins(tl);
        return tl;
    }

    String addJoin(String l1, String f1, String name, String f2, DataDefinition type, int joinType) throws SemanticException {
        this.joins.addElement(new Join(l1, f1, name, f2, joinType));
        this.joinNames.put(l1 + "." + f1, name);
        this.setLabelType(name, type);
        return name;
    }

    String join(String label, String field, String labelf, int joinType) throws SemanticException {
        String s = this.joinNames.get(label + "." + field);
        if (s != null) {
            return s;
        }
        DataDefinition foreign = null;
        DataDefinition sub = null;
        DataDefinition type = this.findLabelType(label);
        String index = type.getIndexPointerFieldName();
        FieldDefinition fi = type.getFieldDefinition(field);
        if (fi == null) {
            throw new SemanticException("no such field \"" + field + "\" in makumba type \"" + type.getName() + "\"");
        }
        try {
            foreign = fi.getForeignTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sub = fi.getSubtable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String label2 = label;
        if (labelf != null) {
            label2 = labelf;
        }
        while (this.findLabelType(label2) != null) {
            label2 = label2 + "x";
        }
        if (fi.getType().equals("ptr")) {
            return this.addJoin(label, field, label2, foreign.getIndexPointerFieldName(), foreign, joinType);
        }
        if (fi.getType().equals("ptrOne")) {
            return this.addJoin(label, field, label2, sub.getIndexPointerFieldName(), sub, joinType);
        }
        if (fi.getType().equals("setComplex") || fi.getType().equals("setintEnum") || fi.getType().equals("setcharEnum")) {
            return this.addJoin(label, index, label2, index, sub, joinType);
        }
        if (fi.getType().equals("set")) {
            label2 = label + "x";
            while (this.findLabelType(label2) != null) {
                label2 = label2 + "x";
            }
            this.addJoin(label, index, label2, index, sub, 28);
            this.labels.put(label2, sub);
            String label3 = label;
            if (labelf != null) {
                label3 = labelf;
            }
            while (this.findLabelType(label3) != null) {
                label3 = label3 + "x";
            }
            return this.addJoin(label2, sub.getSetMemberFieldName(), label3, foreign.getIndexPointerFieldName(), foreign, joinType);
        }
        throw new SemanticException("\"" + field + "\" is not a set or pointer in makumba type \"" + type.getName() + "\"");
    }

    public void addFrom(String frm, String label, int joinType) throws SemanticException {
        block8: {
            String iterator = frm;
            DataDefinition type = null;
            try {
                type = this.ddp.getDataDefinition(iterator);
            }
            catch (DataDefinitionNotFoundError e) {
            }
            catch (DataDefinitionParseError p) {
                throw new SemanticException(p.getMessage());
            }
            if (type != null) {
                this.setLabelType(label, type);
                this.fromLabels.put(label, type);
                return;
            }
            int i = iterator.indexOf(46);
            if (i > 0) {
                String lbl = iterator.substring(0, i);
                while (true) {
                    lbl = this.findLabel(frm, lbl);
                    String field = iterator = iterator.substring(i + 1);
                    i = iterator.indexOf(46);
                    if (i == -1) {
                        this.join(lbl, field, label, joinType);
                        break block8;
                    }
                    field = iterator.substring(0, i);
                    lbl = this.join(lbl, field, null, joinType);
                }
            }
            if (this.findLabelType(frm) == null) {
                throw new SemanticException("could not find type \"" + frm + "\"");
            }
            this.aliases.put(label, frm);
        }
    }

    private String findLabel(String frm, String lbl) throws SemanticException {
        if (this.labels.get(lbl) == null) {
            String lbl1 = this.aliases.get(lbl);
            if (lbl1 == null) {
                if (this.parent != null) {
                    lbl1 = this.parent.findLabel(frm, lbl);
                } else {
                    throw new SemanticException("could not find type \"" + frm + "\" or label \"" + lbl + "\"");
                }
            }
            lbl = lbl1;
        }
        return lbl;
    }

    private void setLabelType(String label, DataDefinition type) throws SemanticException {
        if (this.findLabelType(label) != null) {
            throw new SemanticException("label defined twice: " + label);
        }
        this.labels.put(label, type);
    }

    DataDefinition findLabelType(String label) {
        DataDefinition d = this.labels.get(label);
        if (d == null && this.parent != null) {
            return this.parent.findLabelType(label);
        }
        return d;
    }

    protected void writeFrom(NameResolver.TextList ret) {
        boolean comma = false;
        Enumeration<String> e = this.fromLabels.keys();
        while (e.hasMoreElements()) {
            String label = e.nextElement();
            if (comma) {
                ret.append(" JOIN ");
            }
            comma = true;
            ret.append(this.getTableName(label)).append(" ").append(label);
        }
    }

    DataDefinition getTableName(String label) {
        return this.findLabelType(label);
    }

    String getFieldName(String label, String field, NameResolver nr) {
        DataDefinition ri = this.findLabelType(label);
        try {
            return nr.resolveFieldName(ri, field);
        }
        catch (NullPointerException e) {
            return field;
        }
    }

    protected void writeJoins(NameResolver.TextList ret) {
        Enumeration<Join> e = this.joins.elements();
        while (e.hasMoreElements()) {
            Join j = e.nextElement();
            switch (j.joinType) {
                case 132: {
                    ret.append(" LEFT");
                }
                case 133: {
                    ret.append(" RIGHT");
                }
                case 23: {
                    ret.append(" FULL");
                }
            }
            ret.append(" JOIN ");
            ret.append(this.getTableName(j.label2)).append(" ").append(j.label2);
            ret.append(" ON ");
            ret.append(j.label1).append(".").append(this.getTableName(j.label1), j.field1).append("= ").append(j.label2).append(".").append(this.getTableName(j.label2), j.field2);
        }
    }

    class Join {
        String label1;
        String field1;
        String label2;
        String field2;
        int joinType;

        public Join(String l1, String f1, String l2, String f2, int joinType) {
            this.label1 = l1;
            this.label2 = l2;
            this.field1 = f1;
            this.field2 = f2;
            this.joinType = joinType;
        }

        public String toString() {
            return this.label1 + "." + this.field1 + " JOIN " + this.label2 + "." + this.field2;
        }
    }
}

