/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import prefuse.data.Table;
import prefuse.data.event.TableListener;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IntIterator;

public class PrefuseTableModel
implements TableModel,
TableListener {
    private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    private int[] m_rowmap;
    private Table m_table;

    public PrefuseTableModel(Table table) {
        this.m_table = table;
    }

    private void initRowMap() {
        this.m_rowmap = new int[this.m_table.getRowCount()];
        IntIterator rows = this.m_table.rows();
        int i = 0;
        while (rows.hasNext()) {
            this.m_rowmap[i] = rows.nextInt();
            ++i;
        }
    }

    private int getRow(int rowIndex) {
        if (this.m_rowmap == null) {
            this.initRowMap();
        }
        return this.m_rowmap[rowIndex];
    }

    public int getColumnCount() {
        return this.m_table.getColumnCount();
    }

    public int getRowCount() {
        return this.m_table.getRowCount();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.m_table.isCellEditable(rowIndex, columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.m_table.getColumnType(columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object o = this.m_table.get(this.getRow(rowIndex), columnIndex);
        if (o != null && o.getClass().isArray()) {
            return StringLib.getArrayString(o);
        }
        return o;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.m_table.set(this.getRow(rowIndex), columnIndex, aValue);
    }

    public String getColumnName(int columnIndex) {
        return this.m_table.getColumnName(columnIndex);
    }

    public void addTableModelListener(TableModelListener l) {
        this.m_listeners.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.m_listeners.remove(l);
    }

    public void tableChanged(Table t, int start, int end, int col, int type) {
        Object[] lstnrs;
        if (type == 1 || type == -1) {
            this.m_rowmap = null;
        }
        if ((lstnrs = this.m_listeners.getArray()).length == 0) {
            return;
        }
        TableModelEvent evt = new TableModelEvent(this, start, end, col, type);
        for (int i = 0; i < lstnrs.length; ++i) {
            ((TableModelListener)lstnrs[i]).tableChanged(evt);
        }
    }
}

