/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.util.HashMap;
import java.util.Map;
import org.makumba.Attributes;
import org.makumba.Transaction;
import org.makumba.db.TransactionImplementation;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.TransactionProviderInterface;

public class DbConnectionProvider {
    private TransactionProviderInterface tp;
    Map<String, Transaction> connections = new HashMap<String, Transaction>(7);
    private Attributes contextAttributes;

    public Transaction getConnectionTo(String dbname) {
        Transaction db;
        if (this.tp == null) {
            this.tp = TransactionProvider.getInstance();
        }
        if ((db = this.connections.get(dbname)) == null) {
            db = this.tp.getConnectionTo(dbname);
            this.connections.put(dbname, db);
        }
        ((TransactionImplementation)db).setContext(this.contextAttributes);
        return db;
    }

    public void close() {
        for (Transaction transaction : this.connections.values()) {
            transaction.close();
        }
        this.connections.clear();
    }

    protected void finalize() {
        this.close();
    }

    public void setTransactionProvider(TransactionProviderInterface tp) {
        this.tp = tp;
    }

    public TransactionProviderInterface getTransactionProvider() {
        if (this.tp == null) {
            this.tp = TransactionProvider.getInstance();
        }
        return this.tp;
    }

    public void setContext(Attributes attributes) {
        this.contextAttributes = attributes;
    }
}

