/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.commons;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import org.makumba.commons.NameValue;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;

public class SoftNamedResources
extends NamedResources {
    private static final long serialVersionUID = 1L;

    public SoftNamedResources(String name, NamedResourceFactory f) {
        super(name, f);
    }

    protected NameValue getNameValue(Object name, Object hash) {
        NameValue nv = null;
        this.cleanCleared();
        SoftReference sr = (SoftReference)this.values.get(hash);
        if (sr == null || (nv = (NameValue)sr.get()) == null) {
            nv = new NameValue(name, hash, this.f);
            this.values.put(hash, new SoftReference<NameValue>(nv));
            ++this.misses;
        } else {
            ++this.hits;
        }
        return nv;
    }

    public String getName() {
        return this.name + " (soft cache)";
    }

    void cleanCleared() {
        Iterator i = this.values.keySet().iterator();
        while (i.hasNext()) {
            SoftReference sr = (SoftReference)this.values.get(i.next());
            if (sr.get() != null) continue;
            i.remove();
        }
    }

    public synchronized int size() {
        this.cleanCleared();
        return super.size();
    }
}

