/*
 * Decompiled with CFR 0.152.
 */
package org.makumba.db.makumba;

import java.sql.SQLException;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import org.makumba.ConfigFileError;
import org.makumba.DBError;
import org.makumba.DataDefinition;
import org.makumba.FieldDefinition;
import org.makumba.MakumbaError;
import org.makumba.Pointer;
import org.makumba.commons.NameResolver;
import org.makumba.commons.NamedResourceFactory;
import org.makumba.commons.NamedResources;
import org.makumba.commons.SoftNamedResources;
import org.makumba.commons.formatters.dateFormatter;
import org.makumba.db.makumba.DBConnection;
import org.makumba.db.makumba.DBConnectionWrapper;
import org.makumba.db.makumba.MakumbaTransactionProvider;
import org.makumba.db.makumba.Query;
import org.makumba.db.makumba.ResourcePool;
import org.makumba.db.makumba.Table;
import org.makumba.db.makumba.Update;
import org.makumba.db.makumba.sql.TableManager;
import org.makumba.providers.DataDefinitionProvider;
import org.makumba.providers.TransactionProvider;
import org.makumba.providers.TransactionProviderInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Database {
    private DataDefinitionProvider ddp = DataDefinitionProvider.getInstance();
    protected TransactionProvider tp = TransactionProvider.getInstance();
    NamedResources queries;
    NamedResources updates;
    int nconn = 0;
    int initConnections = 1;
    protected static boolean requestUTF8 = false;
    protected static boolean requestForeignKeys = false;
    protected ResourcePool connections = new ResourcePool(){

        public Object create() {
            ++Database.this.nconn;
            Database.this.config.put("jdbc_connections", "" + Database.this.nconn);
            return Database.this.makeDBConnection();
        }

        public void renew(Object o) {
            ((DBConnection)o).commit();
        }

        public void close(Object o) {
            ((DBConnection)o).close();
        }
    };
    private int dbsv = 0;
    private boolean autoIncrement;
    Properties config = null;
    Class<?> tableclass;
    String configName;
    Hashtable queryCache = new Hashtable();
    String fullName;
    protected NameResolver nr;
    NamedResources tables;
    NamedResourceFactory tableFactory = new NamedResourceFactory(){
        private static final long serialVersionUID = 1L;

        public Object getHashObject(Object name) {
            return ((DataDefinition)name).getName();
        }

        public Object makeResource(Object name, Object hashName) throws Throwable {
            return Database.this.tableclass.newInstance();
        }

        public void configureResource(Object name, Object hashName, Object resource) {
            Database.this.configureTable((Table)resource, (DataDefinition)name);
            Database.this.addTable(((Table)resource).getDataDefinition().getName());
        }
    };

    public String getName() {
        return this.configName;
    }

    protected static boolean supportsUTF8() {
        return requestUTF8;
    }

    protected static boolean supportsForeignKeys() {
        return requestForeignKeys;
    }

    public void initConnections() {
        try {
            this.connections.init(this.initConnections);
        }
        catch (Exception e) {
            throw new DBError(e);
        }
    }

    protected void closeConnections() {
        this.connections.close();
    }

    public void close() {
        Logger.getLogger("org.makumba.db.init").info("closing  " + this.getConfiguration() + "\n\tat " + dateFormatter.debugTime.format(new Date()));
        this.tables.close();
        this.queries.close();
        this.updates.close();
        this.closeConnections();
    }

    public DBConnection getDBConnection(String dataSource) {
        try {
            return new DBConnectionWrapper((DBConnection)this.connections.get(), dataSource, (TransactionProviderInterface)this.tp);
        }
        catch (Exception e) {
            throw new DBError(e);
        }
    }

    public DBConnection getDBConnection() {
        try {
            return new DBConnectionWrapper((DBConnection)this.connections.get(), this.getName(), (TransactionProviderInterface)this.tp);
        }
        catch (Exception e) {
            throw new DBError(e);
        }
    }

    protected abstract DBConnection makeDBConnection();

    public abstract boolean isDuplicateException(SQLException var1);

    public int getDbsv() {
        return this.dbsv;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public abstract Pointer getPointer(String var1, int var2);

    public String getConfiguration() {
        return this.fullName;
    }

    public String getConfiguration(String v) {
        if (v.equals("resource_pool_size")) {
            return String.valueOf(this.connections.getSize());
        }
        return this.config.getProperty(v);
    }

    protected Database(Properties config) {
        this.config = config;
        this.nr = new NameResolver(config);
        this.configName = config.getProperty("db.name");
        String s = config.getProperty("initConnections");
        if (s != null) {
            this.initConnections = Integer.parseInt(s.trim());
        }
        config.put("jdbc_connections", "0");
        try {
            if (config.get("dbsv") != null && config.get("autoIncrement") != null) {
                throw new ConfigFileError("only one of dbsv and autoIncrement can be specified");
            }
            if (config.get("dbsv") != null) {
                this.dbsv = new Integer((String)config.get("dbsv"));
            } else if (config.get("autoIncrement") != null) {
                this.autoIncrement = true;
            } else {
                throw new ConfigFileError("either dbsv or autoIncrement must be specified");
            }
            this.tableclass = this.getTableClassConfigured();
            config.put("alter#org.makumba.db.makumba.Catalog", "true");
            config.put("alter#org.makumba.db.makumba.Lock", "true");
            config.put("alter#org.makumba.controller.MultipleSubmit", "true");
            config.put("alter#org.makumba.controller.ErrorLog", "true");
            config.put("alter#org.makumba.devel.relations.Relation", "true");
            config.put("alter#org.makumba.devel.relations.WebappDatabase", "true");
            config.put("alter#org.makumba.devel.relations.RelationOrigin", "true");
        }
        catch (Exception e) {
            throw new MakumbaError(e);
        }
        this.queries = new SoftNamedResources("Database " + this.getName() + " query objects", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object makeResource(Object o) {
                Object[] multi = (Object[])o;
                return Database.this.prepareQueryImpl((String)multi[0], (String)multi[1]);
            }

            protected Object getHashObject(Object name) {
                Object[] multi = (Object[])name;
                return "" + multi[0] + "####" + multi[1];
            }
        });
        this.updates = new SoftNamedResources("Database " + this.getName() + " update objects", new NamedResourceFactory(){
            private static final long serialVersionUID = 1L;

            public Object makeResource(Object o) {
                Object[] multi = (Object[])o;
                return Database.this.prepareUpdateImpl((String)multi[0], (String)multi[1], (String)multi[2]);
            }

            protected Object getHashObject(Object name) {
                Object[] multi = (Object[])name;
                return "" + multi[0] + "####" + multi[1] + "######" + multi[2];
            }
        });
    }

    protected Class<?> getTableClassConfigured() {
        return null;
    }

    public abstract String OQLDate(Date var1);

    public Table getTable(String name) {
        int n;
        if (name.indexOf(47) != -1 && (name = name.replace('/', '.')).charAt(0) == '.') {
            name = name.substring(1);
        }
        if ((n = name.indexOf("->")) == -1) {
            return this.getTable(this.ddp.getDataDefinition(name));
        }
        Table t = this.getTable(name.substring(0, n));
        while ((n = (name = name.substring(n + 2)).indexOf("->")) != -1) {
            t = t.getRelatedTable(name.substring(0, n));
        }
        t = t.getRelatedTable(name);
        return t;
    }

    public Table getTable(DataDefinition ri) {
        return (Table)this.tables.getResource(ri);
    }

    public static String findConfig(Properties cnf, String pattern) {
        String ret = null;
        Enumeration<Object> e = cnf.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!pattern.startsWith(key) || ret != null && ret.length() >= key.length()) continue;
            ret = key;
        }
        return ret;
    }

    public abstract Query prepareQueryImpl(String var1, String var2);

    public abstract Update prepareUpdateImpl(String var1, String var2, String var3);

    public abstract int getMinPointerValue();

    public abstract int getMaxPointerValue();

    public void deleteFrom(DBConnection c, String table, DBConnection sourceDB, boolean ignoreDbsv) {
        DataDefinition dd = this.ddp.getDataDefinition(table);
        Logger.getLogger("org.makumba.db.admin.delete").info("deleted " + this.getTable(table).deleteFrom(c, sourceDB, ignoreDbsv) + " old objects from " + table);
        Enumeration<String> e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            FieldDefinition fi = dd.getFieldDefinition(e.nextElement());
            if (!fi.getType().startsWith("set") && !fi.getType().equals("ptrOne")) continue;
            this.deleteFrom(c, fi.getSubtable().getName(), sourceDB, ignoreDbsv);
        }
    }

    public void deleteFrom(String sourceDB, String table, boolean ignoreDbsv) {
        String[] _tables = new String[]{table};
        this.deleteFrom(sourceDB, _tables, ignoreDbsv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFrom(String source, String[] tables, boolean ignoreDbsv) {
        DBConnection c = this.getDBConnection();
        DBConnection sourceDBc = MakumbaTransactionProvider.getDatabase(source).getDBConnection();
        try {
            this.deleteFrom(c, tables, sourceDBc, ignoreDbsv);
        }
        finally {
            c.close();
            sourceDBc.close();
        }
    }

    public void deleteFrom(DBConnection c, String[] tables, DBConnection sourceDB, boolean ignoreDbsv) {
        for (int i = 0; i < tables.length; ++i) {
            this.deleteFrom(c, tables[i], sourceDB, ignoreDbsv);
        }
    }

    public void copyFrom(String sourceDB, String table, boolean ignoreDbsv) {
        String[] _tables = new String[]{table};
        this.copyFrom(sourceDB, _tables, ignoreDbsv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(String source, String[] tables, boolean ignoreDbsv) {
        DBConnection c = this.getDBConnection();
        DBConnection sourceDBc = MakumbaTransactionProvider.getDatabase(source).getDBConnection();
        try {
            this.copyFrom(c, tables, sourceDBc, ignoreDbsv);
        }
        finally {
            c.close();
            sourceDBc.close();
        }
    }

    public void copyFrom(DBConnection c, String[] tables, DBConnection sourceDB, boolean ignoreDbsv) {
        this.deleteFrom(c, tables, sourceDB, ignoreDbsv);
        for (int i = 0; i < tables.length; ++i) {
            this.copyFrom(c, tables[i], sourceDB, ignoreDbsv);
        }
    }

    public void copyFrom(DBConnection c, String table, DBConnection sourceDB, boolean ignoreDbsv) {
        DataDefinition dd = this.ddp.getDataDefinition(table);
        this.getTable(table).copyFrom(c, c.getHostDatabase().getTable(table), sourceDB, ignoreDbsv);
        Enumeration<String> e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            FieldDefinition fi = dd.getFieldDefinition(e.nextElement());
            if (!fi.getType().startsWith("set") && !fi.getType().equals("ptrOne")) continue;
            this.copyFrom(c, fi.getSubtable().getName(), sourceDB, ignoreDbsv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(String source, boolean ignoreDbsv) {
        DBConnection c = this.getDBConnection();
        DBConnection sourceDB = MakumbaTransactionProvider.findDatabase(source).getDBConnection();
        try {
            Vector<Dictionary<String, Object>> v = sourceDB.executeQuery("SELECT c.name AS name FROM org.makumba.db.Catalog c", null);
            String[] _tables = new String[v.size()];
            for (int i = 0; i < _tables.length; ++i) {
                String nm = (String)v.elementAt(i).get("name");
                Logger.getLogger("org.makumba.db.admin.copy").info(nm);
                _tables[i] = nm;
            }
            this.copyFrom(c, _tables, sourceDB, ignoreDbsv);
        }
        finally {
            c.close();
            sourceDB.close();
        }
    }

    public void openTables(String[] _tables) {
        for (int i = 0; i < _tables.length; ++i) {
            this.openTable(_tables[i]);
        }
    }

    public void openTable(String table) {
        this.getTable(table);
        DataDefinition dd = this.ddp.getDataDefinition(table);
        Enumeration<String> e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            FieldDefinition fi = dd.getFieldDefinition(e.nextElement());
            if (!fi.getType().startsWith("set") && !fi.getType().equals("ptrOne")) continue;
            this.openTable(fi.getSubtable().getName());
        }
    }

    public void checkForeignKeys(String table) {
        this.getTable(table);
        DataDefinition dd = this.ddp.getDataDefinition(table);
        Enumeration<String> e = dd.getFieldNames().elements();
        while (e.hasMoreElements()) {
            FieldDefinition fi = dd.getFieldDefinition(e.nextElement());
            if (!fi.getType().startsWith("set") && !fi.getType().equals("ptrOne")) continue;
            this.openTable(fi.getSubtable().getName());
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addTable(String s) {
        if (s.equals("org.makumba.db.makumba.Catalog")) {
            return;
        }
        DBConnection c = this.getDBConnection();
        try {
            Enumeration<Dictionary<String, Object>> e = c.executeQuery("SELECT c FROM org.makumba.db.makumba.Catalog c WHERE c.name=$1", s).elements();
            if (!e.hasMoreElements()) {
                Hashtable<String, String> h = new Hashtable<String, String>(3);
                ((Dictionary)h).put("name", s);
                this.getTable("org.makumba.db.makumba.Catalog").insertRecord(c, h);
            }
        }
        finally {
            c.close();
        }
    }

    public Table makePseudoTable(DataDefinition ri) {
        Table ret = null;
        try {
            ret = (Table)this.tableclass.newInstance();
        }
        catch (Throwable t) {
            throw new MakumbaError(t);
        }
        this.configureTable(ret, ri);
        return ret;
    }

    void configureTable(Table tbl, DataDefinition ri) {
        tbl.db = this;
        tbl.setDataDefinition(ri);
        tbl.open(this.config, this.nr);
    }

    public boolean usesHibernateIndexes() {
        return false;
    }

    public String getTypeNameInSource(DataDefinition dd) {
        String nameInSource = ((TableManager)this.getTable(dd)).getDBName();
        return nameInSource;
    }

    public String getFieldNameInSource(DataDefinition dd, String field) {
        String nameInSource = ((TableManager)this.getTable(dd)).getFieldDBName(field);
        return nameInSource;
    }

    public Properties getConfigurationProperties() {
        return this.config;
    }

    public NameResolver getNameResolver() {
        return this.nr;
    }
}

